# AUTOGENERATED! DO NOT EDIT! File to edit: nbks/04_generate_pseudo_labels.ipynb (unless otherwise specified).

__all__ = ['generate_pseudo_labels']

# Cell
from fastcore.all import *
import pandas as pd
import numpy as np
from .utils import *

# Cell
@call_parse
def generate_pseudo_labels(
    path:   Param("Directory of prediction CSVs to average", Path)=".",
    name:   Param("File name to save as", str)="pseudo_labels.csv",
    thresh: Param("Min probabilty for pseudo label", float)=0.95,
) -> Path:
    """Generates pseudo labels and saves in path dir."""
    avg_preds_df = get_averaged_preds(path)

    # One-hot encode highly confident predictions
    high_confidence_preds_mask = avg_preds_df >= thresh
    avg_preds_df[high_confidence_preds_mask] = 1.0
    avg_preds_df[~high_confidence_preds_mask] = 0.0

    # Only keep predictions model was highly confident on
    pseudo_labels = avg_preds_df[high_confidence_preds_mask.any(axis=1)]

    pseudo_labels.to_csv(path/name)
    return path/name