import { Construct } from 'constructs';
export * from './policy';
export interface ClusterAutoScalerOptions {
    /**
     * service account for aws-load-balancer-controller.
     *
     * @default - true
     */
    readonly createServiceAccount?: boolean;
    /**
     * Service Account Name
     *
     * @default - cluster-autoscaler
     */
    readonly serviceAccountName?: string;
    /**
       * Extra commands for controller.
       * @default - [
          './cluster-autoscaler',
          '--v=4',
          '----stderrthreshold=info',
          '--cloud-provider=aws',
          '--skip-nodes-with-local-storage=false',
          '--expander=least-waste'
          ]
       */
    readonly command?: string[];
    /**
       * Namespace
       *
       * @default - kube-system
       */
    readonly namespace?: string;
    /**
       * image for deployment
       */
    readonly image?: string;
}
export declare class ClusterAutoScaler extends Construct {
    /**
    * service account for aws-load-balancer-controller.
    *
    * @default - true
    */
    readonly createServiceAccount?: boolean;
    /**
     * Service Account Name
     *
     * @default - cluster-autoscaler
     */
    readonly serviceAccountName?: string;
    /**
     * Extra commands for controller.
     * @default - [
          './cluster-autoscaler',
          '--v=4',
          '----stderrthreshold=info',
          '--cloud-provider=aws',
          '--skip-nodes-with-local-storage=false',
          '--expander=least-waste'
          ]
     */
    readonly command?: string[];
    /**
     * Namespace
     *
     * @default - kube-system
     */
    readonly namespace?: string;
    /**
     * image for deployment
     */
    readonly image?: string;
    constructor(scope: Construct, name: string, opts: ClusterAutoScalerOptions);
    private commandFunc;
}
