# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ergast_py', 'ergast_py.constants', 'ergast_py.models']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27.1,<3.0.0', 'uritemplate>=4.1.1,<5.0.0']

setup_kwargs = {
    'name': 'ergast-py',
    'version': '0.3.0',
    'description': 'A comprehensive Python wrapper for the Ergast API.',
    'long_description': '<h1 align="center"><b>Ergast-Py</b></h1>\n\n<p align="center">\n    <img src="https://img.shields.io/github/stars/Samuel-Roach/ergast-py?color=purple&style=for-the-badge"/>\n    <img src="https://img.shields.io/github/languages/code-size/Samuel-Roach/ergast-py?style=for-the-badge"/>\n    <img src="https://img.shields.io/github/commit-activity/m/Samuel-Roach/ergast-py?color=green&style=for-the-badge"/>\n    <br>\n    <img src="https://img.shields.io/pypi/v/ergast-py?color=yellow&style=for-the-badge"/>\n    <img alt="GitHub" src="https://img.shields.io/github/license/Samuel-roach/Ergast-py?color=orange&style=for-the-badge">\n    <img alt="Downloads" src="https://img.shields.io/pypi/dw/ergast-py?color=red&style=for-the-badge">\n</p>\n\nA comprehensive Python wrapper for the Ergast API. Built for easy use and functionality, Ergast-py aims to bring the Ergast API into the Python network as seemlessly as possible.\n\n> NOTE: Ergast-py is still in active development, so all features are experimental and subject to change. Differences may occur between what is documented in this README.md and what is actually available in Ergast-py\n\n<p align="center">\n   <img width="500" src="images/../img/banner.png" alt="Command prompt example of how to use Ergast">\n</p>\n\n# What is Ergast?\n\n[Ergast](http://ergast.com/mrd/) is a free, experimental API for accessing motor-racing data, dating back to the beginning of World Championships in 1950. The website provides plenty of detail into how effective the API can be, and the many options that are available for data gathering using it.\n\n# Why should I use Ergast-Py?\n\nErgast-Py provides a clean, Python orientated wrapper for this API. It has been designed to remove the heavy lifting of handling the API formatting behind the scenes, allowing developers to easily access the data that is relevant to them. All the data is conformed into clean class code, allowing for users to keep a Python-centric mindset whilst developing.\n\n# How to install\n\nErgast-py is a [pip package](https://pypi.org/project/ergast-py/), so can be installed with the pip command:\n\n```\npip install ergast-py\n```\n\n# Usage\n\nOnce ergast-py is installed on your system you can then begin using the library in querying the ergast API. To begin, initialise an instance of the ``Ergast()`` class.\n\nNote: Whilst the package is called ``ergast-py``, you need to import ``ergast_py``\n\n```python\nimport ergast_py\n\ne = ergast_py.Ergast()\n\n# For v0.1.0 and prior\nfrom ergast_py import ergast.Ergast\n\ne = Ergast()\n```\n\nQueries can then be built up with function calls in a sequential manner. Once you\'ve built up a query, finally define what data you wish to get using a ``get_xyz()`` function.\n\n```python\n# http://ergast.com/api/f1/2008/5/results\nrace_results = e.season(2008).round(5).get_results()\n\n# http://ergast.com/api/f1/drivers/massa\nfelipe_massa = e.driver_str("massa").get_driver()\n\n# http://ergast.com/api/f1/current/constructorStandings/3\nconstructor_standings = e.season().standing(3).get_constructor_standings()\n```\n\n# Structure and Types\n\nErgast-py has many models which allow the user to more effectively use and manipulate the data available to them through Ergast. All models of data are available through ``.models.xyz``.\n\n<details>\n<summary>Available models in ergast-py</summary>\n</br>\n\n| Name                  | Description                                               |\n| --------------------- | --------------------------------------------------------- |\n| AverageSpeed          | The average speed achieved during a fastest lap           |\n| Circuit               | Details about a Formula One circuit                       |\n| ConstructorStanding   | A single constructor\'s representation in the standings    |\n| Constructor           | A Formula One constructor                                 |\n| DriverStanding        | A single driver\'s representation in the standings         |\n| Driver                | A Formula One driver                                      |\n| FastestLap            | A fastest lap achieved by a driver                        |\n| Lap                   | Details about a drivers lap                               |\n| Location              | The position of a circuit                                 |\n| PitStop               | Details about a driver\'s pit stop                         |\n| Race                  | Full representation of a Formula One race                 |\n| Result                | Details about a driver\'s result                           |\n| Season                | Details about a Formula One season                        |\n| StandingsList         | A list of standings; constructors or drivers              |\n| Status                | Details about the final status of a driver in a race      |\n| Timing                | Details about the timings of a driver during a lap        |\n\n</details>\n\n# Query building\n\nThere are 3 types of query available in the ``Ergast()`` class. <b>FILTER</b> functions build up the query, by filtering down the data that you will receive. <b>PAGING</b> functions control the flow of data if there is excessive amounts, limiting it to not overflow the API. <b>RETURN</b> functions detail what type of data you\'re expecting back from the query.\n\nThe order of the builder functions is inconsequential, however the final function called should be a <i>return</i> function.\n```\nErgast().{paging/filter}.{return}\n```\n\nMore detail on the available functions within the ``Ergast()`` class is available below.\n\n<details>\n<summary><b>FILTER</b> functions</summary>\n</br>\n\n| Name            | Arguments                | Notes                                                                          |\n| --------------- | ------------------------ | ------------------------------------------------------------------------------ |\n| season          | year: int                | If you call season with no arguments it will default to the current season     |\n| round           | round_no: int            | If you call round with no arguments it will default to the last round          |\n| driver          | driver: Driver           | The Driver equivalent of ``driver_str``                                        |\n| driver_str      | driver: str              | The String equivalent of ``driver``. Must use driver\'s driverId                |\n| constructor     | constructor: Constructor | The Constructor equivalent of ``constructor_str``                              |\n| constructor_str | constructor: str         | The String equivalent of ``constructor``. Must use constructor\'s constructorId |\n| qualifying      | position: int            | Position at the <i>end</i> of qualifying                                       |\n| sprint          | position: int            |                                                                                |\n| grid            | position: int            | Position lined up on the grid                                                  |\n| result          | position: int            |                                                                                |\n| fastest         | position: int            | Ranking in list of each drivers fastest lap                                    |\n| circuit         | circuit: Circuit         | The Circuit equivalent of ``circuit_str``                                      |\n| circuit_str     | circuit: str             | The String equivalent of ``circuit``. Must use circuit\'s circuitId             |\n| status          | status: int              | The Integer equivalent of ``status_string``. Must use statusId                 |\n| status_str      | status: str              | The String equivalent of ``status``                                            |\n| standing        | position: int            | Position of Driver or Constructor in standing                                  |\n| lap             | lap_number: int          |                                                                                |\n| pit_stop        | stop_number: int         |                                                                                |\n\n</details>\n\n<details>\n<summary><b>PAGING</b> functions</summary>\n</br>\n\n| Name             | Arguments   |\n| ---------------- | ----------- |\n| limit            | amount: int |\n| offset           | amount: int |\n\n\n</details>\n\n<details>\n<summary><b>RETURN</b> functions</summary>\n</br>\n\n> NOTE: All the functions that return a single object will raise an Exception if your query is returning more than one item.\n\n| Name                      | Return Type           |\n| ------------------------- | --------------------- |\n| get_circuits              | list[Circuit]         |\n| get_circuit               | Circuit               |\n| get_constructors          | list[Constructor]     |\n| get_constructor           | Constructor           |\n| get_drivers               | list[Driver]          |\n| get_driver                | Driver                |\n| get_qualifyings           | list[Race]            |\n| get_qualifying            | Race                  |\n| get_sprints               | list[Race]            |\n| get_sprint                | Race                  |\n| get_results               | list[Race]            |\n| get_result                | Race                  |\n| get_races                 | list[Race]            |\n| get_race                  | Race                  |\n| get_seasons               | list[Season]          |\n| get_season                | Season                |\n| get_statuses              | list[Status]          |\n| get_status                | Status                |\n| get_driver_standings      | list[StandingsList]   |\n| get_driver_standing       | StandingsList         |\n| get_constructor_standings | list[StandingsList]   |\n| get_constructor_standing  | StandingsList         |\n| get_laps                  | list[Race]            |\n| get_lap                   | Race                  |\n| get_pit_stops             | list[Race]            |\n| get_pit_stop              | Race                  |\n\n</details>\n\n# Credits\n\nThis library would not be possible without the freely available [Ergast](http://ergast.com/mrd/) API. For full information about the API and it\'s responsible use, please refer to their website. [Poetry](https://python-poetry.org/) was used for package building and releasing.\n',
    'author': 'Samuel Roach',
    'author_email': 'samuelroach.2000@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Samuel-Roach/ergast-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
