"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTrackerConsumer = exports.CfnTracker = exports.CfnRouteCalculator = exports.CfnPlaceIndex = exports.CfnMap = exports.CfnGeofenceCollection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-06-19T15:11:21.266Z","fingerprint":"yfcZo4+/PSoHpGvTbAEIaYYlIk62R52fxJtpguwibGA="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnGeofenceCollectionProps`
 *
 * @param properties - the TypeScript properties of a `CfnGeofenceCollectionProps`
 *
 * @returns the result of the validation.
 */
function CfnGeofenceCollectionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('collectionName', cdk.requiredValidator)(properties.collectionName));
    errors.collect(cdk.propertyValidator('collectionName', cdk.validateString)(properties.collectionName));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    return errors.wrap('supplied properties not correct for "CfnGeofenceCollectionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::GeofenceCollection` resource
 *
 * @param properties - the TypeScript properties of a `CfnGeofenceCollectionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::GeofenceCollection` resource.
 */
// @ts-ignore TS6133
function cfnGeofenceCollectionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGeofenceCollectionPropsValidator(properties).assertSuccess();
    return {
        CollectionName: cdk.stringToCloudFormation(properties.collectionName),
        Description: cdk.stringToCloudFormation(properties.description),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
    };
}
// @ts-ignore TS6133
function CfnGeofenceCollectionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('collectionName', 'CollectionName', cfn_parse.FromCloudFormation.getString(properties.CollectionName));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::GeofenceCollection`
 *
 * The `AWS::Location::GeofenceCollection` resource specifies the ability to detect and act when a tracked device enters or exits a defined geographical boundary known as a geofence.
 *
 * @cloudformationResource AWS::Location::GeofenceCollection
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html
 */
class CfnGeofenceCollection extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::GeofenceCollection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGeofenceCollection.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnGeofenceCollectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnGeofenceCollection);
            }
            throw error;
        }
        cdk.requireProperty(props, 'collectionName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCollectionArn = cdk.Token.asString(this.getAtt('CollectionArn'));
        this.attrCreateTime = cdk.Token.asString(this.getAtt('CreateTime'));
        this.attrUpdateTime = cdk.Token.asString(this.getAtt('UpdateTime'));
        this.collectionName = props.collectionName;
        this.description = props.description;
        this.kmsKeyId = props.kmsKeyId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGeofenceCollectionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGeofenceCollection(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGeofenceCollection.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            collectionName: this.collectionName,
            description: this.description,
            kmsKeyId: this.kmsKeyId,
        };
    }
    renderProperties(props) {
        return cfnGeofenceCollectionPropsToCloudFormation(props);
    }
}
exports.CfnGeofenceCollection = CfnGeofenceCollection;
_a = JSII_RTTI_SYMBOL_1;
CfnGeofenceCollection[_a] = { fqn: "@aws-cdk/aws-location.CfnGeofenceCollection", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGeofenceCollection.CFN_RESOURCE_TYPE_NAME = "AWS::Location::GeofenceCollection";
/**
 * Determine whether the given properties match those of a `CfnMapProps`
 *
 * @param properties - the TypeScript properties of a `CfnMapProps`
 *
 * @returns the result of the validation.
 */
function CfnMapPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configuration', cdk.requiredValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('configuration', CfnMap_MapConfigurationPropertyValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('mapName', cdk.requiredValidator)(properties.mapName));
    errors.collect(cdk.propertyValidator('mapName', cdk.validateString)(properties.mapName));
    errors.collect(cdk.propertyValidator('pricingPlan', cdk.validateString)(properties.pricingPlan));
    return errors.wrap('supplied properties not correct for "CfnMapProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::Map` resource
 *
 * @param properties - the TypeScript properties of a `CfnMapProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::Map` resource.
 */
// @ts-ignore TS6133
function cfnMapPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMapPropsValidator(properties).assertSuccess();
    return {
        Configuration: cfnMapMapConfigurationPropertyToCloudFormation(properties.configuration),
        MapName: cdk.stringToCloudFormation(properties.mapName),
        Description: cdk.stringToCloudFormation(properties.description),
        PricingPlan: cdk.stringToCloudFormation(properties.pricingPlan),
    };
}
// @ts-ignore TS6133
function CfnMapPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configuration', 'Configuration', CfnMapMapConfigurationPropertyFromCloudFormation(properties.Configuration));
    ret.addPropertyResult('mapName', 'MapName', cfn_parse.FromCloudFormation.getString(properties.MapName));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('pricingPlan', 'PricingPlan', properties.PricingPlan != null ? cfn_parse.FromCloudFormation.getString(properties.PricingPlan) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::Map`
 *
 * The `AWS::Location::Map` resource specifies a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.
 *
 * @cloudformationResource AWS::Location::Map
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-map.html
 */
class CfnMap extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::Map`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMap.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnMapProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMap);
            }
            throw error;
        }
        cdk.requireProperty(props, 'configuration', this);
        cdk.requireProperty(props, 'mapName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCreateTime = cdk.Token.asString(this.getAtt('CreateTime'));
        this.attrDataSource = cdk.Token.asString(this.getAtt('DataSource'));
        this.attrMapArn = cdk.Token.asString(this.getAtt('MapArn'));
        this.attrUpdateTime = cdk.Token.asString(this.getAtt('UpdateTime'));
        this.configuration = props.configuration;
        this.mapName = props.mapName;
        this.description = props.description;
        this.pricingPlan = props.pricingPlan;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMapPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMap(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMap.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            configuration: this.configuration,
            mapName: this.mapName,
            description: this.description,
            pricingPlan: this.pricingPlan,
        };
    }
    renderProperties(props) {
        return cfnMapPropsToCloudFormation(props);
    }
}
exports.CfnMap = CfnMap;
_b = JSII_RTTI_SYMBOL_1;
CfnMap[_b] = { fqn: "@aws-cdk/aws-location.CfnMap", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMap.CFN_RESOURCE_TYPE_NAME = "AWS::Location::Map";
/**
 * Determine whether the given properties match those of a `MapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `MapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnMap_MapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('style', cdk.requiredValidator)(properties.style));
    errors.collect(cdk.propertyValidator('style', cdk.validateString)(properties.style));
    return errors.wrap('supplied properties not correct for "MapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::Map.MapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `MapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::Map.MapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnMapMapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMap_MapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Style: cdk.stringToCloudFormation(properties.style),
    };
}
// @ts-ignore TS6133
function CfnMapMapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('style', 'Style', cfn_parse.FromCloudFormation.getString(properties.Style));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnPlaceIndexProps`
 *
 * @param properties - the TypeScript properties of a `CfnPlaceIndexProps`
 *
 * @returns the result of the validation.
 */
function CfnPlaceIndexPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataSource', cdk.requiredValidator)(properties.dataSource));
    errors.collect(cdk.propertyValidator('dataSource', cdk.validateString)(properties.dataSource));
    errors.collect(cdk.propertyValidator('dataSourceConfiguration', CfnPlaceIndex_DataSourceConfigurationPropertyValidator)(properties.dataSourceConfiguration));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('pricingPlan', cdk.validateString)(properties.pricingPlan));
    return errors.wrap('supplied properties not correct for "CfnPlaceIndexProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::PlaceIndex` resource
 *
 * @param properties - the TypeScript properties of a `CfnPlaceIndexProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::PlaceIndex` resource.
 */
// @ts-ignore TS6133
function cfnPlaceIndexPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaceIndexPropsValidator(properties).assertSuccess();
    return {
        DataSource: cdk.stringToCloudFormation(properties.dataSource),
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        DataSourceConfiguration: cfnPlaceIndexDataSourceConfigurationPropertyToCloudFormation(properties.dataSourceConfiguration),
        Description: cdk.stringToCloudFormation(properties.description),
        PricingPlan: cdk.stringToCloudFormation(properties.pricingPlan),
    };
}
// @ts-ignore TS6133
function CfnPlaceIndexPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataSource', 'DataSource', cfn_parse.FromCloudFormation.getString(properties.DataSource));
    ret.addPropertyResult('indexName', 'IndexName', cfn_parse.FromCloudFormation.getString(properties.IndexName));
    ret.addPropertyResult('dataSourceConfiguration', 'DataSourceConfiguration', properties.DataSourceConfiguration != null ? CfnPlaceIndexDataSourceConfigurationPropertyFromCloudFormation(properties.DataSourceConfiguration) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('pricingPlan', 'PricingPlan', properties.PricingPlan != null ? cfn_parse.FromCloudFormation.getString(properties.PricingPlan) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::PlaceIndex`
 *
 * Specifies a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
 *
 * > If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [AWS service terms](https://docs.aws.amazon.com/service-terms) for more details.
 *
 * @cloudformationResource AWS::Location::PlaceIndex
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-placeindex.html
 */
class CfnPlaceIndex extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::PlaceIndex`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPlaceIndex.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnPlaceIndexProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPlaceIndex);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dataSource', this);
        cdk.requireProperty(props, 'indexName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCreateTime = cdk.Token.asString(this.getAtt('CreateTime'));
        this.attrIndexArn = cdk.Token.asString(this.getAtt('IndexArn'));
        this.attrUpdateTime = cdk.Token.asString(this.getAtt('UpdateTime'));
        this.dataSource = props.dataSource;
        this.indexName = props.indexName;
        this.dataSourceConfiguration = props.dataSourceConfiguration;
        this.description = props.description;
        this.pricingPlan = props.pricingPlan;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPlaceIndexPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPlaceIndex(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPlaceIndex.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dataSource: this.dataSource,
            indexName: this.indexName,
            dataSourceConfiguration: this.dataSourceConfiguration,
            description: this.description,
            pricingPlan: this.pricingPlan,
        };
    }
    renderProperties(props) {
        return cfnPlaceIndexPropsToCloudFormation(props);
    }
}
exports.CfnPlaceIndex = CfnPlaceIndex;
_c = JSII_RTTI_SYMBOL_1;
CfnPlaceIndex[_c] = { fqn: "@aws-cdk/aws-location.CfnPlaceIndex", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPlaceIndex.CFN_RESOURCE_TYPE_NAME = "AWS::Location::PlaceIndex";
/**
 * Determine whether the given properties match those of a `DataSourceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DataSourceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaceIndex_DataSourceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('intendedUse', cdk.validateString)(properties.intendedUse));
    return errors.wrap('supplied properties not correct for "DataSourceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::PlaceIndex.DataSourceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DataSourceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::PlaceIndex.DataSourceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaceIndexDataSourceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaceIndex_DataSourceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        IntendedUse: cdk.stringToCloudFormation(properties.intendedUse),
    };
}
// @ts-ignore TS6133
function CfnPlaceIndexDataSourceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('intendedUse', 'IntendedUse', properties.IntendedUse != null ? cfn_parse.FromCloudFormation.getString(properties.IntendedUse) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnRouteCalculatorProps`
 *
 * @param properties - the TypeScript properties of a `CfnRouteCalculatorProps`
 *
 * @returns the result of the validation.
 */
function CfnRouteCalculatorPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('calculatorName', cdk.requiredValidator)(properties.calculatorName));
    errors.collect(cdk.propertyValidator('calculatorName', cdk.validateString)(properties.calculatorName));
    errors.collect(cdk.propertyValidator('dataSource', cdk.requiredValidator)(properties.dataSource));
    errors.collect(cdk.propertyValidator('dataSource', cdk.validateString)(properties.dataSource));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('pricingPlan', cdk.validateString)(properties.pricingPlan));
    return errors.wrap('supplied properties not correct for "CfnRouteCalculatorProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::RouteCalculator` resource
 *
 * @param properties - the TypeScript properties of a `CfnRouteCalculatorProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::RouteCalculator` resource.
 */
// @ts-ignore TS6133
function cfnRouteCalculatorPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRouteCalculatorPropsValidator(properties).assertSuccess();
    return {
        CalculatorName: cdk.stringToCloudFormation(properties.calculatorName),
        DataSource: cdk.stringToCloudFormation(properties.dataSource),
        Description: cdk.stringToCloudFormation(properties.description),
        PricingPlan: cdk.stringToCloudFormation(properties.pricingPlan),
    };
}
// @ts-ignore TS6133
function CfnRouteCalculatorPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('calculatorName', 'CalculatorName', cfn_parse.FromCloudFormation.getString(properties.CalculatorName));
    ret.addPropertyResult('dataSource', 'DataSource', cfn_parse.FromCloudFormation.getString(properties.DataSource));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('pricingPlan', 'PricingPlan', properties.PricingPlan != null ? cfn_parse.FromCloudFormation.getString(properties.PricingPlan) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::RouteCalculator`
 *
 * Specifies a route calculator resource in your AWS account.
 *
 * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
 *
 * > If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [AWS service terms](https://docs.aws.amazon.com/service-terms) for more details.
 *
 * @cloudformationResource AWS::Location::RouteCalculator
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-routecalculator.html
 */
class CfnRouteCalculator extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::RouteCalculator`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRouteCalculator.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnRouteCalculatorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnRouteCalculator);
            }
            throw error;
        }
        cdk.requireProperty(props, 'calculatorName', this);
        cdk.requireProperty(props, 'dataSource', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCalculatorArn = cdk.Token.asString(this.getAtt('CalculatorArn'));
        this.attrCreateTime = cdk.Token.asString(this.getAtt('CreateTime'));
        this.attrUpdateTime = cdk.Token.asString(this.getAtt('UpdateTime'));
        this.calculatorName = props.calculatorName;
        this.dataSource = props.dataSource;
        this.description = props.description;
        this.pricingPlan = props.pricingPlan;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnRouteCalculatorPropsFromCloudFormation(resourceProperties);
        const ret = new CfnRouteCalculator(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRouteCalculator.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            calculatorName: this.calculatorName,
            dataSource: this.dataSource,
            description: this.description,
            pricingPlan: this.pricingPlan,
        };
    }
    renderProperties(props) {
        return cfnRouteCalculatorPropsToCloudFormation(props);
    }
}
exports.CfnRouteCalculator = CfnRouteCalculator;
_d = JSII_RTTI_SYMBOL_1;
CfnRouteCalculator[_d] = { fqn: "@aws-cdk/aws-location.CfnRouteCalculator", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRouteCalculator.CFN_RESOURCE_TYPE_NAME = "AWS::Location::RouteCalculator";
/**
 * Determine whether the given properties match those of a `CfnTrackerProps`
 *
 * @param properties - the TypeScript properties of a `CfnTrackerProps`
 *
 * @returns the result of the validation.
 */
function CfnTrackerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('positionFiltering', cdk.validateString)(properties.positionFiltering));
    errors.collect(cdk.propertyValidator('trackerName', cdk.requiredValidator)(properties.trackerName));
    errors.collect(cdk.propertyValidator('trackerName', cdk.validateString)(properties.trackerName));
    return errors.wrap('supplied properties not correct for "CfnTrackerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::Tracker` resource
 *
 * @param properties - the TypeScript properties of a `CfnTrackerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::Tracker` resource.
 */
// @ts-ignore TS6133
function cfnTrackerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrackerPropsValidator(properties).assertSuccess();
    return {
        TrackerName: cdk.stringToCloudFormation(properties.trackerName),
        Description: cdk.stringToCloudFormation(properties.description),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        PositionFiltering: cdk.stringToCloudFormation(properties.positionFiltering),
    };
}
// @ts-ignore TS6133
function CfnTrackerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('trackerName', 'TrackerName', cfn_parse.FromCloudFormation.getString(properties.TrackerName));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('positionFiltering', 'PositionFiltering', properties.PositionFiltering != null ? cfn_parse.FromCloudFormation.getString(properties.PositionFiltering) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::Tracker`
 *
 * Specifies a tracker resource in your AWS account , which lets you receive current and historical location of devices.
 *
 * @cloudformationResource AWS::Location::Tracker
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html
 */
class CfnTracker extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::Tracker`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTracker.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnTrackerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTracker);
            }
            throw error;
        }
        cdk.requireProperty(props, 'trackerName', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCreateTime = cdk.Token.asString(this.getAtt('CreateTime'));
        this.attrTrackerArn = cdk.Token.asString(this.getAtt('TrackerArn'));
        this.attrUpdateTime = cdk.Token.asString(this.getAtt('UpdateTime'));
        this.trackerName = props.trackerName;
        this.description = props.description;
        this.kmsKeyId = props.kmsKeyId;
        this.positionFiltering = props.positionFiltering;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTrackerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTracker(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTracker.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            trackerName: this.trackerName,
            description: this.description,
            kmsKeyId: this.kmsKeyId,
            positionFiltering: this.positionFiltering,
        };
    }
    renderProperties(props) {
        return cfnTrackerPropsToCloudFormation(props);
    }
}
exports.CfnTracker = CfnTracker;
_e = JSII_RTTI_SYMBOL_1;
CfnTracker[_e] = { fqn: "@aws-cdk/aws-location.CfnTracker", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTracker.CFN_RESOURCE_TYPE_NAME = "AWS::Location::Tracker";
/**
 * Determine whether the given properties match those of a `CfnTrackerConsumerProps`
 *
 * @param properties - the TypeScript properties of a `CfnTrackerConsumerProps`
 *
 * @returns the result of the validation.
 */
function CfnTrackerConsumerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('consumerArn', cdk.requiredValidator)(properties.consumerArn));
    errors.collect(cdk.propertyValidator('consumerArn', cdk.validateString)(properties.consumerArn));
    errors.collect(cdk.propertyValidator('trackerName', cdk.requiredValidator)(properties.trackerName));
    errors.collect(cdk.propertyValidator('trackerName', cdk.validateString)(properties.trackerName));
    return errors.wrap('supplied properties not correct for "CfnTrackerConsumerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Location::TrackerConsumer` resource
 *
 * @param properties - the TypeScript properties of a `CfnTrackerConsumerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Location::TrackerConsumer` resource.
 */
// @ts-ignore TS6133
function cfnTrackerConsumerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTrackerConsumerPropsValidator(properties).assertSuccess();
    return {
        ConsumerArn: cdk.stringToCloudFormation(properties.consumerArn),
        TrackerName: cdk.stringToCloudFormation(properties.trackerName),
    };
}
// @ts-ignore TS6133
function CfnTrackerConsumerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('consumerArn', 'ConsumerArn', cfn_parse.FromCloudFormation.getString(properties.ConsumerArn));
    ret.addPropertyResult('trackerName', 'TrackerName', cfn_parse.FromCloudFormation.getString(properties.TrackerName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Location::TrackerConsumer`
 *
 * The `AWS::Location::TrackerConsumer` resource specifies an association between a geofence collection and a tracker resource. The geofence collection is referred to as the *consumer* of the tracker. This allows the tracker resource to communicate location data to the linked geofence collection.
 *
 * > Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
 *
 * @cloudformationResource AWS::Location::TrackerConsumer
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-trackerconsumer.html
 */
class CfnTrackerConsumer extends cdk.CfnResource {
    /**
     * Create a new `AWS::Location::TrackerConsumer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTrackerConsumer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_CfnTrackerConsumerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnTrackerConsumer);
            }
            throw error;
        }
        cdk.requireProperty(props, 'consumerArn', this);
        cdk.requireProperty(props, 'trackerName', this);
        this.consumerArn = props.consumerArn;
        this.trackerName = props.trackerName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTrackerConsumerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTrackerConsumer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTrackerConsumer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            consumerArn: this.consumerArn,
            trackerName: this.trackerName,
        };
    }
    renderProperties(props) {
        return cfnTrackerConsumerPropsToCloudFormation(props);
    }
}
exports.CfnTrackerConsumer = CfnTrackerConsumer;
_f = JSII_RTTI_SYMBOL_1;
CfnTrackerConsumer[_f] = { fqn: "@aws-cdk/aws-location.CfnTrackerConsumer", version: "1.204.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTrackerConsumer.CFN_RESOURCE_TYPE_NAME = "AWS::Location::TrackerConsumer";
//# sourceMappingURL=data:application/json;base64,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