# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aws_adfs']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.24,<2.0',
 'botocore>=1.23,<2.0',
 'click>=8.0,<9.0',
 'configparser==5.2',
 'fido2>=1.0,<2.0',
 'lxml>=4.9,<5.0',
 'requests>=2.27,<3.0']

extras_require = \
{':platform_system != "Windows"': ['requests-kerberos>=0.14,<0.15'],
 ':platform_system == "Windows"': ['requests-negotiate-sspi>=0.5,<0.6']}

entry_points = \
{'console_scripts': ['aws-adfs = aws_adfs.commands:cli']}

setup_kwargs = {
    'name': 'aws-adfs',
    'version': '2.3.1',
    'description': 'AWS CLI authenticator via ADFS - small command-line tool to authenticate via ADFS and assume chosen role',
    'long_description': '# aws-adfs\n[![PyPI version](https://badge.fury.io/py/aws-adfs.svg)](https://badge.fury.io/py/aws-adfs)\n[![Travis build](https://api.travis-ci.org/venth/aws-adfs.svg?branch=master)](https://api.travis-ci.org/venth/aws-adfs.svg?branch=master)\n![Build Status](https://github.com/venth/aws-adfs/workflows/Build/badge.svg?branch=master)\n\nThe project provides command line tool - `aws-adfs` to ease AWS cli authentication against ADFS (multi factor authentication with active directory).\n\n## `aws-adfs` command line tool\n\n* allows you to re-login to STS without entering credentials for an extended period of time, without having to store the user\'s actual credentials. It also lets an organization control the period in which a user can re-login to STS without entering credentials, by altering the ADFS session lifetime.\n\n* supports automation tools like ansible by providing security token in `AWS_SESSION_TOKEN`/`AWS_SECURITY_TOKEN` environment variables.\n\n* supports using Security Support Provider Interface (SSPI) on Windows OS.\n\n### MFA integration\n\naws-adfs integrates with:\n* [duo security](https://duo.com) MFA provider with support for FIDO U2F (CTAP1) / FIDO2 (CTAP2) hardware authenticators\n* [Symantec VIP](https://vip.symantec.com/) MFA provider\n* [RSA SecurID](https://www.rsa.com/) MFA provider\n\n# Installation\n\n* user local installation with [pipx](https://github.com/pypa/pipx)\n\n    ```\n    pipx install aws-adfs\n    ```\n\n* user local installation with pip\n\n    ```\n    pip install aws-adfs\n    ```\n\n    Please note, that you need to add $HOME/.local/bin to your PATH\n\n* system wide installation\n\n    ```\n    sudo pip install aws-adfs\n    ```\n\n* virtualenvs\n\n    ```\n    virtualenv aws-adfs\n    source aws-adfs/bin/activate\n    pip install aws-adfs\n    ...\n    ...\n    deactivate\n    ```\n\n* Windows 10\n\n   - Install latest supported Visual C++ downloads from Microsoft for Visual Studio 2015, 2017 and 2019:\n      - https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads\n      - https://aka.ms/vs/16/release/vc_redist.x64.exe\n    - Install Python 3.7 from Microsoft Store:\n      - https://www.microsoft.com/en-us/p/python-37/9nj46sx7x90p\n    - Start PowerShell as Administrator\n    - Go to `C:\\Program Files`:\n        ```\n        C:\n        cd \'C:\\Program Files\\\'\n        ```\n    - Create virtual env:\n      ```\n      python3 -m venv aws-adfs\n      ```\n    - Install `aws-adfs`:\n      ```\n      & \'C:\\Program Files\\aws-adfs\\Scripts\\pip\' install aws-adfs\n      ```\n    - Run it:\n      ```\n      & \'C:\\Program Files\\aws-adfs\\Scripts\\aws-adfs\' login --adfs-host=your-adfs-hostname\n      ```\n\n# Examples of usage\n\n## `aws-adfs`\n* login to your adfs host with disabled ssl verification on aws cli profile: adfs\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --no-ssl-verification\n    ```\n\n    and verification\n\n    ```\n    aws --profile=adfs s3 ls\n    ```\n\n* login to your adfs host with disabled ssl verification on specified aws cli profile: specified-profile\n\n    ```\n    aws-adfs login --profile=specified-profile --adfs-host=your-adfs-hostname --no-ssl-verification\n    ```\n\n    and verification\n\n    ```\n    aws --profile=specified-profile s3 ls\n    ```\n\n* login to your adfs host and fetch roles for AWS GovCloud (US)\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --provider-id urn:amazon:webservices:govcloud --region us-gov-west-1\n    ```\n\n    and verification\n\n    ```\n    aws s3 ls\n    ```\n\n* login to your adfs host within ansible playbook\n\n    ```\n    ---\n    - name: "Auth sts aws"\n      command: "aws-adfs login --adfs-host sts.example.com --env --stdout --role-arn arn:aws:iam::000123456789:role/ADMIN"\n      register: sts_result\n      environment:\n        - username: "{{ ansible_user }}@example.com"\n        - password: "{{ ansible_ssh_pass }}"\n\n    - name: "Set sts facts"\n      set_fact:\n        sts: "{{ sts_result.stdout | from_json }}"\n\n    - name: "List s3 Buckets"\n      aws_s3_bucket_facts:\n        aws_access_key: "{{\xa0sts.AccessKeyId }}"\n        aws_secret_key: "{{\xa0sts.SecretAccessKey }}"\n        security_token: "{{\xa0sts.SessionToken }}"\n        region: "us-east-1"\n      register: buckets\n\n    - name: "Print Buckets"\n      debug:\n        var: buckets\n    ```\n\n* login to your adfs host by passing username and password credentials via a file\n\n    ```\n    aws-adfs login --adfs-host=your-adfs-hostname --authfile=/path/and/file/name\n    ```\n\n    Auth file should be in format of\n\n    ```\n    [profile_name]\n    username = your_username\n    password = your_password\n    ```\n\n* .aws/config profile for automatically refreshing credentials\n    ```\n    [profile example-role-ue1]\n    credential_process=aws-adfs login --region=us-east-1 --role-arn=arn:aws:iam::1234567891234:role/example-role --adfs-host=adfs.example.com --stdout\n    ```\n    Warning: see [AWS documentation](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sourcing-external.html) about security considerations to take when sourcing credentials with an external process.\n\n* help, help, help?\n    ```\n    $ aws-adfs --help\n    Usage: aws-adfs [OPTIONS] COMMAND [ARGS]...\n\n    Options:\n      --version  Show current tool version\n      --help  Show this message and exit.\n\n    Commands:\n      list   lists available profiles\n      login  Authenticates an user with active directory...\n      reset  removes stored profile\n    ```\n\n    ```\n    $ aws-adfs list --help\n    Usage: aws-adfs list [OPTIONS]\n\n      lists available profiles\n\n    Options:\n      --version  Show current tool version\n      --help  Show this message and exit.\n    ```\n\n    ```\n    $ aws-adfs login --help\n    Usage: aws-adfs login [OPTIONS]\n\n      Authenticates an user with active directory credentials\n\n    Options:\n      --profile TEXT                  AWS cli profile that will be authenticated.\n                                      After successful authentication just use:\n                                      aws --profile <authenticated profile>\n                                      <service> ...\n      --region TEXT                   The default AWS region that this script will\n                                      connect to for all API calls\n      --ssl-verification / --no-ssl-verification\n                                      SSL certificate verification: Whether or not\n                                      strict certificate verification is done,\n                                      False should only be used for dev/test\n      --adfs-ca-bundle TEXT           Override CA bundle for SSL certificate\n                                      verification for ADFS server only.\n      --adfs-host TEXT                For the first time for a profile it has to\n                                      be provided, next time for the same profile\n                                      it will be loaded from the stored\n                                      configuration\n      --output-format [json|text|table]\n                                      Output format used by aws cli\n      --provider-id TEXT              Provider ID, e.g urn:amazon:webservices\n                                      (optional)\n      --s3-signature-version [s3v4]   s3 signature version: Identifies the version\n                                      of AWS Signature to support for\n                                      authenticated requests. Valid values: s3v4\n      --username-password-command TEXT\n                                      Read username and password from the output\n                                      of a shell command (expected JSON format:\n                                      `{"username": "myusername", "password":\n                                      "mypassword"}`)\n      --env                           Read username, password from environment\n                                      variables (username and password).\n      --stdin                         Read username, password from standard input\n                                      separated by a newline.\n      --authfile TEXT                 Read username, password from a local file\n                                      (optional)\n      --stdout                        Print aws_session_token in json on stdout.\n      --printenv                      Output commands to set AWS_ACCESS_KEY_ID,\n                                      AWS_SECRET_ACCESS_KEY, AWS_SESSION_TOKEN,\n                                      AWS_DEFAULT_REGION environmental variables\n                                      instead of saving them to the aws\n                                      configuration file.\n      --print-console-signin-url      Output a URL that lets users who sign in to\n                                      your organization\'s network securely access\n                                      the AWS Management Console.\n      --console-role-arn TEXT         Role to assume for use in conjunction with\n                                      --print-console-signin-url\n      --console-external-id TEXT      External ID to pass in assume role for use\n                                      in conjunction with --print-console-signin-\n                                      url\n      --role-arn TEXT                 Predefined role arn to selects, e.g. aws-\n                                      adfs login --role-arn arn:aws:iam::123456789\n                                      012:role/YourSpecialRole\n      --session-duration INTEGER      Define the amount of seconds you want to\n                                      establish your STS session, e.g. aws-adfs\n                                      login --session-duration 3600\n      --no-session-cache              Do not use AWS session cache in\n                                      ~/.aws/adfs_cache/ directory.\n      --assertfile TEXT               Use SAML assertion response from a local\n                                      file\n      --sspi / --no-sspi              Whether or not to use Kerberos SSO\n                                      authentication via SSPI (Windows only,\n                                      defaults to True).\n      --duo-factor TEXT               Use a specific Duo factor, overriding the\n                                      default one configured server side. Known\n                                      Duo factors that can be used with aws-adfs\n                                      are `Duo Push`, `WebAuthn Security Key`, and\n                                      `Phone Call`.\n      --duo-device TEXT               Use a specific Duo device, overriding the\n                                      default one configured server side. Depends\n                                      heavily on the Duo factor used. Known Duo\n                                      devices that can be used with aws-adfs are\n                                      `phone1` for `Duo Push` and `Phone Call`\n                                      factors, and the security key ID for\n                                      `WebAuthn Security Key` factor.\n      --help                          Show this message and exit.\n    ```\n    ```\n    $ aws-adfs reset --help                                                                                                                                              13:39\n    Usage: aws-adfs reset [OPTIONS]\n\n      removes stored profile\n\n    Options:\n      --profile TEXT  AWS cli profile that will be removed\n      --help          Show this message and exit.\n    ```\n\n# Known issues\n\n* duo-security\n\n    `Error: Cannot begin authentication process. The error response: {"message": "Unknown authentication method.", "stat": "FAIL"}`\n\n    Please setup preferred auth method in duo-security settings (settings\' -> \'My Settings & Devices\').\n\n* USB FIDO2 does not work in Windows Subsystem for Linux (WSL)\n\n    `OSError: [Errno 2] No such file or directory: \'/sys/class/hidraw\'`\n\n    USB devices are not accessible in WSL, please install and run `aws-adfs` on the Windows 10 host and then access the credentials in WSL from the filesystem. Example:\n\n    ```\n    export AWS_CONFIG_FILE=/mnt/c/Users/username/.aws/config\n    export AWS_SHARED_CREDENTIALS_FILE=/mnt/c/Users/username/.aws/credentials\n    ```\n\n*  FIDO2 devices are not detected on Windows 10 build 1903 or newer\n\n    Running `aws-adfs` as Administrator is required since Windows 10 build 1903 to access FIDO2 devices, cf. https://github.com/Yubico/python-fido2/issues/55)\n\n* in cases of trouble with lxml please install\n\n  ```\n  sudo apt-get install python-dev libxml2-dev libxslt1-dev zlib1g-dev\n  ```\n\n* in cases of trouble with pykerberos please install\n\n  ```\n  sudo apt-get install python-dev libkrb5-dev\n  ```\n\n* in cases of trouble with OSX Sierra (obsolete OpenSSL), upgrade OpenSSL. Example:\n  ```\n  brew upgrade openssl\n  ```\n  AND add explicit directive to .bash_profile:\n  ```\n  export PATH=$(brew --prefix openssl)/bin:$PATH\n  ```\n\n* only python >= 3.7 to <4.0 are supported:\n  - python 2.6 is not supported\n  - python 2.7 is not supported\n  - python 3.2 is not supported\n  - python 3.3 is not supported\n  - python 3.4 is not supported\n  - python 3.5 is not supported\n  - python 3.6 is not supported\n\n# Development\n\n* update dependencies:\n```\npoetry update\n```\n\n* run unit tests:\n```\npoetry run pytest\n```\n\n* release:\n\n```\npoetry version patch # or minor, major, prepatch, preminor, premajor, prerelease\nexport CHANGELOG_GITHUB_TOKEN=$(gopass show -o pins/Github/github-changelog-generator)\ndocker run -it --rm -v "$(pwd)":/usr/local/src/your-app -e CHANGELOG_GITHUB_TOKEN githubchangeloggenerator/github-changelog-generator -u venth -p aws-adfs --future-release=$(poetry version -s)\ngit add .\ngit commit -m "Release $(poetry version -s)"\ngit tag --annotate -m "Release $(poetry version -s)" $(poetry version -s)\ngit push\n```\n\n# Changelog\n\nSee the [CHANGELOG.md](CHANGELOG.md) file, which is generated using [github-changelog-generator](https://github.com/github-changelog-generator/github-changelog-generator).\n',
    'author': 'Venth',
    'author_email': 'artur.krysiak.warszawa@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
