from dateutil.relativedelta import relativedelta
from edc_visit_schedule import Schedule, Visit

from ...constants import DELIVERY, SCHEDULE_PREGNANCY
from .crfs import crfs_missed
from .crfs import crfs_prn
from .crfs import crfs_prn as default_crfs_prn
from .crfs_pregnancy import crfs_pregnancy

schedule = Schedule(
    name=SCHEDULE_PREGNANCY,
    verbose_name="Delivery and Birth Outcomes Follow-up",
    onschedule_model="meta_prn.onschedulepregnancy",
    offschedule_model="meta_prn.offschedulepregnancy",
    consent_model="meta_consent.subjectconsent",
    appointment_model="edc_appointment.appointment",
)


visit = Visit(
    code=DELIVERY,
    title="Delivery",
    timepoint=200,
    rbase=relativedelta(days=0),
    rlower=relativedelta(days=0),
    rupper=relativedelta(months=12),
    crfs=crfs_pregnancy,
    crfs_prn=crfs_prn or default_crfs_prn,
    crfs_missed=crfs_missed,
    facility_name="7-day-clinic",
)


schedule.add_visit(visit=visit)
