# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 pool: pulumi.Input[str],
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 certificate_template: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['CertificateConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pem_csr: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input['CertificateConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] name: The name for this Certificate.
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "pool", pool)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if certificate_template is not None:
            pulumi.set(__self__, "certificate_template", certificate_template)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pem_csr is not None:
            pulumi.set(__self__, "pem_csr", pem_csr)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Input[str]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Authority name.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @certificate_template.setter
    def certificate_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_template", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['CertificateConfigArgs']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['CertificateConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @pem_csr.setter
    def pem_csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_csr", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 certificate_descriptions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]] = None,
                 certificate_template: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['CertificateConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pem_certificate: Optional[pulumi.Input[str]] = None,
                 pem_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pem_csr: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 revocation_details: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]] certificate_descriptions: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input['CertificateConfigArgs'] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time that this resource was created on the server. This is in RFC3339 text format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[str] name: The name for this Certificate.
        :param pulumi.Input[str] pem_certificate: Output only. The pem-encoded, signed X.509 certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pem_certificates: Required. Expected to be in leaf-to-root order according to RFC 5246.
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]] revocation_details: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[str] update_time: Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if certificate_descriptions is not None:
            pulumi.set(__self__, "certificate_descriptions", certificate_descriptions)
        if certificate_template is not None:
            pulumi.set(__self__, "certificate_template", certificate_template)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_certificates is not None:
            pulumi.set(__self__, "pem_certificates", pem_certificates)
        if pem_csr is not None:
            pulumi.set(__self__, "pem_csr", pem_csr)
        if pool is not None:
            pulumi.set(__self__, "pool", pool)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if revocation_details is not None:
            pulumi.set(__self__, "revocation_details", revocation_details)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Authority name.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="certificateDescriptions")
    def certificate_descriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "certificate_descriptions")

    @certificate_descriptions.setter
    def certificate_descriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateDescriptionArgs']]]]):
        pulumi.set(self, "certificate_descriptions", value)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @certificate_template.setter
    def certificate_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_template", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['CertificateConfigArgs']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['CertificateConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that this resource was created on the server. This is in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user-defined metadata to apply to this resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[pulumi.Input[str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @pem_certificate.setter
    def pem_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_certificate", value)

    @property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")

    @pem_certificates.setter
    def pem_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pem_certificates", value)

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @pem_csr.setter
    def pem_csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_csr", value)

    @property
    @pulumi.getter
    def pool(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @pool.setter
    def pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "revocation_details")

    @revocation_details.setter
    def revocation_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRevocationDetailArgs']]]]):
        pulumi.set(self, "revocation_details", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 certificate_template: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['CertificateConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pem_csr: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Certificate corresponds to a signed X.509 certificate issued by a Certificate.

        > **Note:** The Certificate Authority that is referenced by this resource **must** be
        `tier = "ENTERPRISE"`

        ## Example Usage
        ### Privateca Certificate With Template

        ```python
        import pulumi
        import pulumi_gcp as gcp

        template = gcp.certificateauthority.CertificateTemplate("template",
            location="us-central1",
            description="An updated sample certificate template",
            identity_constraints=gcp.certificateauthority.CertificateTemplateIdentityConstraintsArgs(
                allow_subject_alt_names_passthrough=True,
                allow_subject_passthrough=True,
                cel_expression=gcp.certificateauthority.CertificateTemplateIdentityConstraintsCelExpressionArgs(
                    description="Always true",
                    expression="true",
                    location="any.file.anywhere",
                    title="Sample expression",
                ),
            ),
            passthrough_extensions=gcp.certificateauthority.CertificateTemplatePassthroughExtensionsArgs(
                additional_extensions=[gcp.certificateauthority.CertificateTemplatePassthroughExtensionsAdditionalExtensionArgs(
                    object_id_paths=[
                        1,
                        6,
                    ],
                )],
                known_extensions=["EXTENDED_KEY_USAGE"],
            ),
            predefined_values=gcp.certificateauthority.CertificateTemplatePredefinedValuesArgs(
                additional_extensions=[gcp.certificateauthority.CertificateTemplatePredefinedValuesAdditionalExtensionArgs(
                    object_id=gcp.certificateauthority.CertificateTemplatePredefinedValuesAdditionalExtensionObjectIdArgs(
                        object_id_paths=[
                            1,
                            6,
                        ],
                    ),
                    value="c3RyaW5nCg==",
                    critical=True,
                )],
                aia_ocsp_servers=["string"],
                ca_options=gcp.certificateauthority.CertificateTemplatePredefinedValuesCaOptionsArgs(
                    is_ca=False,
                    max_issuer_path_length=6,
                ),
                key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageArgs(
                    base_key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageArgs(
                        cert_sign=False,
                        content_commitment=True,
                        crl_sign=False,
                        data_encipherment=True,
                        decipher_only=True,
                        digital_signature=True,
                        encipher_only=True,
                        key_agreement=True,
                        key_encipherment=True,
                    ),
                    extended_key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageArgs(
                        client_auth=True,
                        code_signing=True,
                        email_protection=True,
                        ocsp_signing=True,
                        server_auth=True,
                        time_stamping=True,
                    ),
                    unknown_extended_key_usages=[gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsageArgs(
                        object_id_paths=[
                            1,
                            6,
                        ],
                    )],
                ),
                policy_ids=[gcp.certificateauthority.CertificateTemplatePredefinedValuesPolicyIdArgs(
                    object_id_paths=[
                        1,
                        6,
                    ],
                )],
            ))
        test_ca = gcp.certificateauthority.Authority("test-ca",
            pool="",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="HashiCorp",
                        common_name="my-certificate-authority",
                    ),
                    subject_alt_name=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectAltNameArgs(
                        dns_names=["hashicorp.com"],
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ))
        default = gcp.certificateauthority.Certificate("default",
            pool="",
            location="us-central1",
            certificate_authority=test_ca.certificate_authority_id,
            lifetime="860s",
            pem_csr=(lambda path: open(path).read())("test-fixtures/rsa_csr.pem"),
            certificate_template=template.id)
        ```
        ### Privateca Certificate Csr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_ca = gcp.certificateauthority.Authority("test-ca",
            pool="",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="HashiCorp",
                        common_name="my-certificate-authority",
                    ),
                    subject_alt_name=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectAltNameArgs(
                        dns_names=["hashicorp.com"],
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ))
        default = gcp.certificateauthority.Certificate("default",
            pool="",
            location="us-central1",
            certificate_authority=test_ca.certificate_authority_id,
            lifetime="860s",
            pem_csr=(lambda path: open(path).read())("test-fixtures/rsa_csr.pem"))
        ```

        ## Import

        Certificate can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{project}}/{{location}}/{{pool}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{location}}/{{pool}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input[pulumi.InputType['CertificateConfigArgs']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[str] name: The name for this Certificate.
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Certificate corresponds to a signed X.509 certificate issued by a Certificate.

        > **Note:** The Certificate Authority that is referenced by this resource **must** be
        `tier = "ENTERPRISE"`

        ## Example Usage
        ### Privateca Certificate With Template

        ```python
        import pulumi
        import pulumi_gcp as gcp

        template = gcp.certificateauthority.CertificateTemplate("template",
            location="us-central1",
            description="An updated sample certificate template",
            identity_constraints=gcp.certificateauthority.CertificateTemplateIdentityConstraintsArgs(
                allow_subject_alt_names_passthrough=True,
                allow_subject_passthrough=True,
                cel_expression=gcp.certificateauthority.CertificateTemplateIdentityConstraintsCelExpressionArgs(
                    description="Always true",
                    expression="true",
                    location="any.file.anywhere",
                    title="Sample expression",
                ),
            ),
            passthrough_extensions=gcp.certificateauthority.CertificateTemplatePassthroughExtensionsArgs(
                additional_extensions=[gcp.certificateauthority.CertificateTemplatePassthroughExtensionsAdditionalExtensionArgs(
                    object_id_paths=[
                        1,
                        6,
                    ],
                )],
                known_extensions=["EXTENDED_KEY_USAGE"],
            ),
            predefined_values=gcp.certificateauthority.CertificateTemplatePredefinedValuesArgs(
                additional_extensions=[gcp.certificateauthority.CertificateTemplatePredefinedValuesAdditionalExtensionArgs(
                    object_id=gcp.certificateauthority.CertificateTemplatePredefinedValuesAdditionalExtensionObjectIdArgs(
                        object_id_paths=[
                            1,
                            6,
                        ],
                    ),
                    value="c3RyaW5nCg==",
                    critical=True,
                )],
                aia_ocsp_servers=["string"],
                ca_options=gcp.certificateauthority.CertificateTemplatePredefinedValuesCaOptionsArgs(
                    is_ca=False,
                    max_issuer_path_length=6,
                ),
                key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageArgs(
                    base_key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageArgs(
                        cert_sign=False,
                        content_commitment=True,
                        crl_sign=False,
                        data_encipherment=True,
                        decipher_only=True,
                        digital_signature=True,
                        encipher_only=True,
                        key_agreement=True,
                        key_encipherment=True,
                    ),
                    extended_key_usage=gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageArgs(
                        client_auth=True,
                        code_signing=True,
                        email_protection=True,
                        ocsp_signing=True,
                        server_auth=True,
                        time_stamping=True,
                    ),
                    unknown_extended_key_usages=[gcp.certificateauthority.CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsageArgs(
                        object_id_paths=[
                            1,
                            6,
                        ],
                    )],
                ),
                policy_ids=[gcp.certificateauthority.CertificateTemplatePredefinedValuesPolicyIdArgs(
                    object_id_paths=[
                        1,
                        6,
                    ],
                )],
            ))
        test_ca = gcp.certificateauthority.Authority("test-ca",
            pool="",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="HashiCorp",
                        common_name="my-certificate-authority",
                    ),
                    subject_alt_name=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectAltNameArgs(
                        dns_names=["hashicorp.com"],
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ))
        default = gcp.certificateauthority.Certificate("default",
            pool="",
            location="us-central1",
            certificate_authority=test_ca.certificate_authority_id,
            lifetime="860s",
            pem_csr=(lambda path: open(path).read())("test-fixtures/rsa_csr.pem"),
            certificate_template=template.id)
        ```
        ### Privateca Certificate Csr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_ca = gcp.certificateauthority.Authority("test-ca",
            pool="",
            certificate_authority_id="my-certificate-authority",
            location="us-central1",
            config=gcp.certificateauthority.AuthorityConfigArgs(
                subject_config=gcp.certificateauthority.AuthorityConfigSubjectConfigArgs(
                    subject=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectArgs(
                        organization="HashiCorp",
                        common_name="my-certificate-authority",
                    ),
                    subject_alt_name=gcp.certificateauthority.AuthorityConfigSubjectConfigSubjectAltNameArgs(
                        dns_names=["hashicorp.com"],
                    ),
                ),
                x509_config=gcp.certificateauthority.AuthorityConfigX509ConfigArgs(
                    ca_options=gcp.certificateauthority.AuthorityConfigX509ConfigCaOptionsArgs(
                        is_ca=True,
                    ),
                    key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageArgs(
                        base_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs(
                            cert_sign=True,
                            crl_sign=True,
                        ),
                        extended_key_usage=gcp.certificateauthority.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs(
                            server_auth=False,
                        ),
                    ),
                ),
            ),
            key_spec=gcp.certificateauthority.AuthorityKeySpecArgs(
                algorithm="RSA_PKCS1_4096_SHA256",
            ))
        default = gcp.certificateauthority.Certificate("default",
            pool="",
            location="us-central1",
            certificate_authority=test_ca.certificate_authority_id,
            lifetime="860s",
            pem_csr=(lambda path: open(path).read())("test-fixtures/rsa_csr.pem"))
        ```

        ## Import

        Certificate can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{project}}/{{location}}/{{pool}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:certificateauthority/certificate:Certificate default {{location}}/{{pool}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 certificate_template: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['CertificateConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pem_csr: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["certificate_authority"] = certificate_authority
            __props__.__dict__["certificate_template"] = certificate_template
            __props__.__dict__["config"] = config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lifetime"] = lifetime
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["pem_csr"] = pem_csr
            if pool is None and not opts.urn:
                raise TypeError("Missing required property 'pool'")
            __props__.__dict__["pool"] = pool
            __props__.__dict__["project"] = project
            __props__.__dict__["certificate_descriptions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["pem_certificate"] = None
            __props__.__dict__["pem_certificates"] = None
            __props__.__dict__["revocation_details"] = None
            __props__.__dict__["update_time"] = None
        super(Certificate, __self__).__init__(
            'gcp:certificateauthority/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[str]] = None,
            certificate_descriptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateDescriptionArgs']]]]] = None,
            certificate_template: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[pulumi.InputType['CertificateConfigArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifetime: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pem_certificate: Optional[pulumi.Input[str]] = None,
            pem_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            pem_csr: Optional[pulumi.Input[str]] = None,
            pool: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            revocation_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateRevocationDetailArgs']]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_authority: Certificate Authority name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateDescriptionArgs']]]] certificate_descriptions: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[str] certificate_template: The resource name for a CertificateTemplate used to issue this certificate,
               in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
               the caller must have the necessary permission to use this template. If this is
               omitted, no template will be used. This template must be in the same location
               as the Certificate.
        :param pulumi.Input[pulumi.InputType['CertificateConfigArgs']] config: The config used to create a self-signed X.509 certificate or CSR.
               Structure is documented below.
        :param pulumi.Input[str] create_time: The time that this resource was created on the server. This is in RFC3339 text format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] location: Location of the Certificate. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[str] name: The name for this Certificate.
        :param pulumi.Input[str] pem_certificate: Output only. The pem-encoded, signed X.509 certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pem_certificates: Required. Expected to be in leaf-to-root order according to RFC 5246.
        :param pulumi.Input[str] pem_csr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
        :param pulumi.Input[str] pool: The name of the CaPool this Certificate belongs to.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateRevocationDetailArgs']]]] revocation_details: Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
               this field is present.
        :param pulumi.Input[str] update_time: Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["certificate_descriptions"] = certificate_descriptions
        __props__.__dict__["certificate_template"] = certificate_template
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifetime"] = lifetime
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["pem_certificate"] = pem_certificate
        __props__.__dict__["pem_certificates"] = pem_certificates
        __props__.__dict__["pem_csr"] = pem_csr
        __props__.__dict__["pool"] = pool
        __props__.__dict__["project"] = project
        __props__.__dict__["revocation_details"] = revocation_details
        __props__.__dict__["update_time"] = update_time
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate Authority name.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="certificateDescriptions")
    def certificate_descriptions(self) -> pulumi.Output[Sequence['outputs.CertificateCertificateDescription']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "certificate_descriptions")

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> pulumi.Output[Optional[str]]:
        """
        The resource name for a CertificateTemplate used to issue this certificate,
        in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified,
        the caller must have the necessary permission to use this template. If this is
        omitted, no template will be used. This template must be in the same location
        as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.CertificateConfig']]:
        """
        The config used to create a self-signed X.509 certificate or CSR.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time that this resource was created on the server. This is in RFC3339 text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels with user-defined metadata to apply to this resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[Optional[str]]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of the Certificate. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for this Certificate.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> pulumi.Output[str]:
        """
        Output only. The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> pulumi.Output[Sequence[str]]:
        """
        Required. Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> pulumi.Output[Optional[str]]:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Output[str]:
        """
        The name of the CaPool this Certificate belongs to.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> pulumi.Output[Sequence['outputs.CertificateRevocationDetail']]:
        """
        Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if
        this field is present.
        """
        return pulumi.get(self, "revocation_details")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this CertificateAuthority was updated. This is in RFC3339 text format.
        """
        return pulumi.get(self, "update_time")

