"""
Copyright 2022 Andy Qin. All Rights Reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc

from .pooled_object import PooledObject


class PooledObjectFactory(metaclass=abc.ABCMeta):

    def __init__(self, pooled_maxsize: int = 8, least_one: bool = False) -> None:
        self.pooled_maxsize = pooled_maxsize
        self.least_one = least_one

    @abc.abstractmethod
    def creatInstantce(self) -> PooledObject:
        pass

    @abc.abstractmethod
    def destroy(self, pooled_object: PooledObject):
        pass

    @abc.abstractmethod
    def reset(self, pooled_object: PooledObject) -> PooledObject:
        pass

    @abc.abstractmethod
    def validate(self, pooled_object: PooledObject) -> bool:
        pass

    def factory_name(self) -> str:
        return self.__class__.__qualname__
