/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;

public class LocalNameFunction
implements Function {
    @Override
    public Object call(Context context2, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return LocalNameFunction.evaluate(context2.getNodeSet(), context2.getNavigator());
        }
        if (list.size() == 1) {
            return LocalNameFunction.evaluate(list, context2.getNavigator());
        }
        throw new FunctionCallException("local-name() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator navigator) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object e2 = list.get(0);
            if (e2 instanceof List) {
                return LocalNameFunction.evaluate((List)e2, navigator);
            }
            if (navigator.isElement(e2)) {
                return navigator.getElementName(e2);
            }
            if (navigator.isAttribute(e2)) {
                return navigator.getAttributeName(e2);
            }
            if (navigator.isProcessingInstruction(e2)) {
                return navigator.getProcessingInstructionTarget(e2);
            }
            if (navigator.isNamespace(e2)) {
                return navigator.getNamespacePrefix(e2);
            }
            if (navigator.isDocument(e2)) {
                return "";
            }
            if (navigator.isComment(e2)) {
                return "";
            }
            if (navigator.isText(e2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the local-name function must be a node-set");
        }
        return "";
    }
}

