/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import nu.xom.jaxen.JaxenConstants;
import nu.xom.jaxen.JaxenRuntimeException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.UnsupportedAxisException;
import nu.xom.jaxen.util.DescendantOrSelfAxisIterator;

public class FollowingAxisIterator
implements Iterator {
    private Object contextNode;
    private Navigator navigator;
    private Iterator siblings;
    private Iterator currentSibling;

    public FollowingAxisIterator(Object object, Navigator navigator) throws UnsupportedAxisException {
        this.contextNode = object;
        this.navigator = navigator;
        this.siblings = navigator.getFollowingSiblingAxisIterator(object);
        this.currentSibling = JaxenConstants.EMPTY_ITERATOR;
    }

    private boolean goForward() {
        while (!this.siblings.hasNext()) {
            if (this.goUp()) continue;
            return false;
        }
        Object e2 = this.siblings.next();
        this.currentSibling = new DescendantOrSelfAxisIterator(e2, this.navigator);
        return true;
    }

    private boolean goUp() {
        if (this.contextNode == null || this.navigator.isDocument(this.contextNode)) {
            return false;
        }
        try {
            this.contextNode = this.navigator.getParentNode(this.contextNode);
            if (this.contextNode != null && !this.navigator.isDocument(this.contextNode)) {
                this.siblings = this.navigator.getFollowingSiblingAxisIterator(this.contextNode);
                return true;
            }
            return false;
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new JaxenRuntimeException(unsupportedAxisException);
        }
    }

    @Override
    public boolean hasNext() {
        while (!this.currentSibling.hasNext()) {
            if (this.goForward()) continue;
            return false;
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSibling.next();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

