/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.GraphHelper;
import org._3pq.jgrapht.edge.DirectedEdge;
import org._3pq.jgrapht.graph.DefaultDirectedGraph;
import org._3pq.jgrapht.graph.DirectedSubgraph;

public class StrongConnectivityInspector {
    private final DirectedGraph m_graph;
    private LinkedList m_orderedVertices;
    private List m_stronglyConnectedSets;
    private List m_stronglyConnectedSubgraphs;
    private Map m_vertexToVertexData;

    public StrongConnectivityInspector(DirectedGraph directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.m_graph = directedGraph;
        this.m_vertexToVertexData = null;
        this.m_orderedVertices = null;
        this.m_stronglyConnectedSets = null;
        this.m_stronglyConnectedSubgraphs = null;
    }

    public DirectedGraph getGraph() {
        return this.m_graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List stronglyConnectedSets() {
        if (this.m_stronglyConnectedSets == null) {
            Object object;
            this.m_orderedVertices = new LinkedList();
            this.m_stronglyConnectedSets = new Vector();
            this.createVertexData();
            Iterator<Object> iterator = this.m_vertexToVertexData.values().iterator();
            while (iterator.hasNext()) {
                object = (VertexData)iterator.next();
                if (((VertexData)object).m_discovered) continue;
                this.dfsVisit(this.m_graph, (VertexData)object, null);
            }
            object = new DefaultDirectedGraph();
            GraphHelper.addGraphReversed((DirectedGraph)object, this.m_graph);
            this.resetVertexData();
            iterator = this.m_orderedVertices.iterator();
            while (iterator.hasNext()) {
                VertexData vertexData = (VertexData)iterator.next();
                if (vertexData.m_discovered) continue;
                HashSet hashSet = new HashSet();
                this.m_stronglyConnectedSets.add(hashSet);
                this.dfsVisit((DirectedGraph)object, vertexData, hashSet);
            }
            this.m_orderedVertices = null;
            this.m_vertexToVertexData = null;
        }
        return this.m_stronglyConnectedSets;
    }

    public List stronglyConnectedSubgraphs() {
        if (this.m_stronglyConnectedSubgraphs == null) {
            List list = this.stronglyConnectedSets();
            this.m_stronglyConnectedSubgraphs = new Vector(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.m_stronglyConnectedSubgraphs.add(new DirectedSubgraph(this.m_graph, (Set)iterator.next(), null));
            }
        }
        return this.m_stronglyConnectedSubgraphs;
    }

    private void createVertexData() {
        this.m_vertexToVertexData = new HashMap(this.m_graph.vertexSet().size());
        Iterator iterator = this.m_graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            this.m_vertexToVertexData.put(e2, new VertexData(e2, false, false));
        }
    }

    private void dfsVisit(DirectedGraph directedGraph, VertexData vertexData, Set set) {
        Stack<VertexData> stack = new Stack<VertexData>();
        stack.push(vertexData);
        while (!stack.isEmpty()) {
            VertexData vertexData2 = (VertexData)stack.pop();
            if (!vertexData2.m_discovered) {
                vertexData2.m_discovered = true;
                if (set != null) {
                    set.add(vertexData2.m_vertex);
                }
                stack.push(new VertexData(vertexData2, true, true));
                Iterator iterator = directedGraph.outgoingEdgesOf(vertexData2.m_vertex).iterator();
                while (iterator.hasNext()) {
                    DirectedEdge directedEdge = (DirectedEdge)iterator.next();
                    VertexData vertexData3 = (VertexData)this.m_vertexToVertexData.get(directedEdge.getTarget());
                    if (vertexData3.m_discovered) continue;
                    stack.push(vertexData3);
                }
                continue;
            }
            if (!vertexData2.m_finished || set != null) continue;
            this.m_orderedVertices.addFirst(vertexData2.m_vertex);
        }
    }

    private void resetVertexData() {
        Iterator iterator = this.m_vertexToVertexData.values().iterator();
        while (iterator.hasNext()) {
            VertexData vertexData = (VertexData)iterator.next();
            vertexData.m_discovered = false;
            vertexData.m_finished = false;
        }
    }

    private final class VertexData {
        private final Object m_vertex;
        private boolean m_discovered;
        private boolean m_finished;

        private VertexData(Object object, boolean bl, boolean bl2) {
            this.m_vertex = object;
            this.m_discovered = bl;
            this.m_finished = bl2;
        }
    }
}

