/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.rdf.RdfDataset;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.JenaTitanium;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;

public class LangJSONLD11
implements ReaderRIOT {
    private final ErrorHandler errorHandler;
    private final ParserProfile profile;

    public LangJSONLD11(Lang language, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream input, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of(input);
            this.read(document, output, context2);
        }
        catch (JsonLdError ex) {
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void handleJsonLdError(JsonLdError ex) {
        if (ex.getCause() instanceof JsonParsingException) {
            JsonParsingException exp = (JsonParsingException)ex.getCause();
            JsonLocation loc = exp.getLocation();
            this.errorHandler.error(ex.getMessage(), loc.getLineNumber(), loc.getColumnNumber());
        } else {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
        }
        throw new RiotException(ex);
    }

    @Override
    public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of(in);
            this.read(document, output, context2);
        }
        catch (JsonLdError ex) {
            ex.printStackTrace();
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void read(Document document, StreamRDF output, Context context2) throws JsonLdError {
        RdfDataset dataset = JsonLd.toRdf(document).get();
        LangJSONLD11.extractPrefixes(document, output::prefix);
        JenaTitanium.convert(dataset, output);
    }

    private static void extractPrefixes(Document document, BiConsumer<String, String> action) {
        try {
            JsonStructure js = document.getJsonContent().get();
            switch (js.getValueType()) {
                case ARRAY: {
                    LangJSONLD11.extractPrefixes(js, action);
                    break;
                }
                case OBJECT: {
                    JsonValue jv = (JsonValue)js.asJsonObject().get("@context");
                    LangJSONLD11.extractPrefixes(jv, action);
                    break;
                }
            }
        }
        catch (Throwable ex) {
            Log.warn(LangJSONLD11.class, "Unexpected problem while extracting prefixes: " + ex.getMessage(), ex);
        }
    }

    private static void extractPrefixes(JsonValue jsonValue, BiConsumer<String, String> action) {
        if (jsonValue == null) {
            return;
        }
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                jsonValue.asJsonArray().forEach(jv -> LangJSONLD11.extractPrefixes(jv, action));
                break;
            }
            case OBJECT: {
                LangJSONLD11.extractPrefixesCxtDefn(jsonValue.asJsonObject(), action);
                break;
            }
            case NULL: {
                break;
            }
            case STRING: {
                break;
            }
        }
    }

    private static void extractPrefixesCxtDefn(JsonObject jCxt, BiConsumer<String, String> action) {
        Set keys = jCxt.keySet();
        keys.stream().forEach(k -> {
            JsonValue jvx = (JsonValue)jCxt.get(k);
            if (JsonValue.ValueType.STRING != jvx.getValueType()) {
                return;
            }
            String prefix = k;
            if ("@vocab".equals(k)) {
                prefix = "";
            } else if (k.startsWith("@")) {
                return;
            }
            String uri = ((JsonString)JsonString.class.cast(jvx)).getString();
            if (uri.endsWith("#") || uri.endsWith("/") || uri.endsWith(":")) {
                action.accept(prefix, uri);
                return;
            }
        });
    }
}

