/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.inf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;

@Deprecated
public class InferenceSetupRDFS {
    final Map<Node, List<Node>> transClasses = new HashMap<Node, List<Node>>();
    final Map<Node, List<Node>> transProperties = new HashMap<Node, List<Node>>();
    final Map<Node, List<Node>> domainList = new HashMap<Node, List<Node>>();
    final Map<Node, List<Node>> rangeList = new HashMap<Node, List<Node>>();

    public InferenceSetupRDFS(Model vocab) {
        InferenceSetupRDFS.exec("SELECT ?x ?y { ?x rdfs:subClassOf+ ?y }", vocab, this.transClasses);
        InferenceSetupRDFS.exec("SELECT ?x ?y { ?x rdfs:subPropertyOf+ ?y }", vocab, this.transProperties);
        InferenceSetupRDFS.exec("SELECT ?x ?y { ?x rdfs:domain ?y }", vocab, this.domainList);
        InferenceSetupRDFS.exec("SELECT ?x ?y { ?x rdfs:range ?y }", vocab, this.rangeList);
    }

    private static void exec(String qs, Model model, Map<Node, List<Node>> multimap) {
        String preamble = StrUtils.strjoinNL("PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX  rdfs:   <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX  xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX  owl:    <http://www.w3.org/2002/07/owl#>", "PREFIX skos:    <http://www.w3.org/2004/02/skos/core#>");
        Query query = QueryFactory.create(preamble + "\n" + qs, Syntax.syntaxARQ);
        QueryExecution qexec = QueryExecutionFactory.create(query, model);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Node x = soln.get("x").asNode();
            Node y = soln.get("y").asNode();
            if (!multimap.containsKey(x)) {
                multimap.put(x, new ArrayList());
            }
            multimap.get(x).add(y);
        }
    }
}

