/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.rowset.RowSetReaderRegistry;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;

public class RowSetReaderJSON_V1
implements RowSetReader {
    public static final RowSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_JSON)) {
            throw new ResultSetException("RowSet for JSON asked for a " + lang);
        }
        return new RowSetReaderJSON_V1();
    };

    public static void install() {
        RowSetReaderRegistry.register(ResultSetLang.RS_JSON, factory);
    }

    private RowSetReaderJSON_V1() {
    }

    @Override
    public QueryExecResult readAny(InputStream in, Context context2) {
        return RowSetReaderJSON_V1.process(in, context2);
    }

    private static QueryExecResult process(InputStream in, Context context2) {
        if (context2 == null) {
            context2 = ARQ.getContext();
        }
        RowSetJSON exec = new RowSetJSON(context2);
        exec.parse(in);
        if (exec.rows != null) {
            RowSet rs = RowSetStream.create(exec.vars, exec.rows.iterator());
            return new QueryExecResult(rs);
        }
        return new QueryExecResult(exec.booleanResult);
    }

    private static class RowSetJSON {
        final Context context;
        Boolean booleanResult = null;
        List<Binding> rows = null;
        List<Var> vars = null;
        final LabelToNode labelMap;

        RowSetJSON(Context context2) {
            this.context = context2;
            boolean inputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.inputGraphBNodeLabels);
            this.labelMap = inputGraphBNodeLabels ? SyntaxLabels.createLabelToNodeAsGiven() : SyntaxLabels.createLabelToNode();
            this.rows = null;
        }

        private void parse(InputStream in) {
            JsonObject obj = JSON.parse(in);
            if (obj.hasKey("boolean")) {
                RowSetJSON.checkContains(obj, true, true, "head", "boolean");
                this.booleanResult = obj.get("boolean").getAsBoolean().value();
                this.rows = null;
                return;
            }
            this.rows = new ArrayList<Binding>(1000);
            RowSetJSON.checkContains(obj, true, true, "head", "results");
            if (!obj.get("head").isObject()) {
                throw new ResultSetException("Key 'head' must have a JSON object as value: found: " + obj.get("head"));
            }
            JsonObject head = obj.get("head").getAsObject();
            if (head.hasKey("link")) {
                ArrayList<String> links = new ArrayList<String>();
                if (head.get("link").isString()) {
                    Log.warn(this, "Link field is a string, should be an array of strings");
                    links.add(head.get("link").getAsString().value());
                } else {
                    if (!head.get("link").isArray()) {
                        throw new ResultSetException("Key 'link' must have be an array: found: " + obj.get("link"));
                    }
                    for (JsonValue v : head.get("link").getAsArray()) {
                        if (!v.isString()) {
                            throw new ResultSetException("Key 'link' must have be an array of strings: found: " + v);
                        }
                        links.add(v.getAsString().value());
                    }
                }
            }
            this.vars = RowSetJSON.parseVars(head);
            JsonObject results = obj.get("results").getAsObject();
            if (!results.get("bindings").isArray()) {
                throw new ResultSetException("'bindings' must be an array");
            }
            JsonArray array = results.get("bindings").getAsArray();
            Iterator<JsonValue> iter = array.iterator();
            BindingBuilder builder = Binding.builder();
            while (iter.hasNext()) {
                builder.reset();
                JsonValue v = iter.next();
                if (!v.isObject()) {
                    throw new ResultSetException("Entry in 'bindings' array must be an object {}");
                }
                JsonObject x = v.getAsObject();
                Set<String> varNames = x.keys();
                for (String vn : varNames) {
                    JsonValue vt = x.get(vn);
                    if (!vt.isObject()) {
                        throw new ResultSetException("Binding for variable '" + vn + "' is not a JSON object: " + vt);
                    }
                    Node n = RowSetJSON.parseOneTerm(vt.getAsObject(), this.labelMap);
                    builder.add(Var.alloc(vn), n);
                }
                this.rows.add(builder.build());
            }
        }

        private static List<Var> parseVars(JsonObject obj) {
            if (!obj.get("vars").isArray()) {
                throw new ResultSetException("Key 'vars' must be a JSON array");
            }
            JsonArray a = obj.get("vars").getAsArray();
            Iterator<JsonValue> iter = a.iterator();
            ArrayList<Var> vars = new ArrayList<Var>();
            while (iter.hasNext()) {
                JsonValue v = iter.next();
                if (!v.isString()) {
                    throw new ResultSetException("Entries in vars array must be strings");
                }
                Var var = Var.alloc(v.getAsString().value());
                vars.add(var);
            }
            return vars;
        }

        private static Node parseOneTerm(JsonObject term, LabelToNode labelMap) {
            RowSetJSON.checkContains(term, false, false, "type", "value", "xml:lang", "datatype");
            String type = RowSetJSON.stringOrNull(term, "type");
            if ("triple".equals(type) || "statement".equals(type)) {
                JsonObject x = term.get("value").getAsObject();
                return RowSetJSON.parseTripleTerm(x, labelMap);
            }
            String v = RowSetJSON.stringOrNull(term, "value");
            if ("uri".equals(type)) {
                RowSetJSON.checkContains(term, false, true, "type", "value");
                String uri = v;
                Node n = NodeFactory.createURI(v);
                return n;
            }
            if ("literal".equals(type) || "typed-literal".equals(type)) {
                String lang = RowSetJSON.stringOrNull(term, "xml:lang");
                String dtStr = RowSetJSON.stringOrNull(term, "datatype");
                if (lang != null && dtStr != null && !dtStr.equals(RDF.dtLangString.getURI())) {
                    throw new ResultSetException("Both language and datatype defined, datatype is not rdf:langString:\n" + term);
                }
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtStr);
                return NodeFactory.createLiteral(v, lang, dt);
            }
            if ("bnode".equals(type)) {
                return (Node)labelMap.get(null, v);
            }
            throw new ResultSetException("Object key not recognized as valid for an RDF term: " + term);
        }

        private static Node parseTripleTerm(JsonObject term, LabelToNode labelMap) {
            if (term.entrySet().size() != 3) {
                throw new ResultSetException("Wrong number of object keys for triple term: should be 3, got " + term.entrySet().size());
            }
            RowSetJSON.checkContainsOneOf(term, "subject", "s");
            RowSetJSON.checkContainsOneOf(term, "object", "o");
            RowSetJSON.checkContainsOneOf(term, "predicate", "property", "p");
            JsonObject sTerm = RowSetJSON.get(term, "subject", "s");
            JsonObject pTerm = RowSetJSON.get(term, "predicate", "property", "p");
            JsonObject oTerm = RowSetJSON.get(term, "object", "o");
            if (sTerm == null || pTerm == null || oTerm == null) {
                throw new ResultSetException("Bad triple term: " + term);
            }
            Node s = RowSetJSON.parseOneTerm(sTerm, labelMap);
            Node p = RowSetJSON.parseOneTerm(pTerm, labelMap);
            Node o = RowSetJSON.parseOneTerm(oTerm, labelMap);
            return NodeFactory.createTripleNode(s, p, o);
        }

        private static JsonObject get(JsonObject term, String ... fields) {
            for (String f : fields) {
                JsonValue v = term.get(f);
                if (v == null) continue;
                return v.getAsObject();
            }
            return null;
        }

        private static String stringOrNull(JsonObject obj, String key) {
            JsonValue v = obj.get(key);
            if (v == null) {
                return null;
            }
            if (!v.isString()) {
                throw new ResultSetException("Not a string: key: " + key);
            }
            return v.getAsString().value();
        }

        private static void checkContains(JsonObject term, boolean allowUndefinedKeys, boolean requireAllExpectedKeys, String ... keys) {
            List<String> expectedKeys = Arrays.asList(keys);
            HashSet<String> declared = new HashSet<String>();
            for (String k : term.keys()) {
                if (!expectedKeys.contains(k) && !allowUndefinedKeys) {
                    throw new ResultSetException("Expected only object keys " + Arrays.asList(keys) + " but encountered '" + k + "'");
                }
                if (!expectedKeys.contains(k)) continue;
                declared.add(k);
            }
            if (requireAllExpectedKeys && declared.size() < expectedKeys.size()) {
                throw new ResultSetException("One or more of the required keys " + expectedKeys + " was not found");
            }
        }

        private static void checkContainsOneOf(JsonObject term, String ... keys) {
            List<String> expectedKeys = Arrays.asList(keys);
            String found = null;
            for (String k : term.keys()) {
                if (found == null) {
                    if (!expectedKeys.contains(k)) continue;
                    found = k;
                    continue;
                }
                if (!expectedKeys.contains(k)) continue;
                throw new ResultSetException("More than one key out of " + expectedKeys);
            }
        }
    }
}

