/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.writer.DirectiveStyle;
import org.apache.jena.riot.writer.WriterConst;
import org.apache.jena.riot.writer.WriterLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public abstract class WriterStreamRDFBase
implements StreamRDF {
    protected boolean activeTripleData = false;
    protected boolean activeQuadData = false;
    protected boolean lastWasDirective = false;
    protected final PrefixMap pMap;
    protected String baseURI = null;
    protected final NodeToLabel nodeToLabel;
    protected NodeFormatterTTL fmt;
    protected final IndentedWriter out;
    protected final DirectiveStyle prefixStyle;
    protected final boolean printBase;
    protected int countPrefixesForRDF = 0;

    protected WriterStreamRDFBase(OutputStream output, Context context2) {
        this(new IndentedWriter(output), context2);
    }

    protected WriterStreamRDFBase(Writer output, Context context2) {
        this(WriterStreamRDFBase.wrap(output), context2);
    }

    protected WriterStreamRDFBase(IndentedWriter output, Context context2) {
        this(output, NodeToLabel.createScopeByDocument(), WriterLib.directiveStyle(context2), context2.isFalseOrUndef(RIOT.symTurtleOmitBase));
    }

    protected WriterStreamRDFBase(IndentedWriter output, NodeToLabel nodeToLabel, DirectiveStyle prefixStyle, boolean printBase) {
        this.out = output;
        this.baseURI = null;
        this.pMap = PrefixMapFactory.create();
        this.nodeToLabel = nodeToLabel;
        this.prefixStyle = prefixStyle;
        this.printBase = printBase;
        this.setFormatter();
    }

    private void setFormatter() {
        this.fmt = new NodeFormatterTTL(this.baseURI, this.pMap, this.nodeToLabel);
    }

    private static IndentedWriter wrap(Writer output) {
        if (!(output instanceof BufferedWriter)) {
            output = new BufferedWriter(output, 32768);
        }
        return RiotLib.create(output);
    }

    private void reset$() {
        this.activeTripleData = false;
        this.activeQuadData = false;
        this.lastWasDirective = false;
    }

    @Override
    public final void start() {
        this.reset$();
        this.startData();
    }

    @Override
    public final void finish() {
        this.endData();
        this.out.flush();
    }

    @Override
    public final void triple(Triple triple) {
        this.print(triple);
        this.activeTripleData = true;
    }

    @Override
    public final void quad(Quad quad) {
        this.print(quad);
        this.activeQuadData = true;
    }

    @Override
    public final void base(String base) {
        this.baseURI = base;
        this.lastWasDirective = true;
        this.setFormatter();
        if (this.printBase) {
            RiotLib.writeBase(this.out, base, this.prefixStyle == DirectiveStyle.SPARQL);
        }
    }

    @Override
    public final void prefix(String prefix, String iri) {
        String old;
        this.endData();
        this.prefixSetup(prefix, iri);
        this.lastWasDirective = true;
        if (this.pMap.containsPrefix(prefix) && WriterConst.rdfNS.equals(old = this.pMap.getMapping().get(prefix))) {
            --this.countPrefixesForRDF;
        }
        if (WriterConst.rdfNS.equals(iri)) {
            ++this.countPrefixesForRDF;
        }
        this.pMap.add(prefix, iri);
        RiotLib.writePrefix(this.out, prefix, iri, this.prefixStyle == DirectiveStyle.SPARQL);
    }

    protected void prefixSetup(String prefix, String iri) {
    }

    protected void outputNode(Node n) {
        this.fmt.format(this.out, n);
    }

    protected void printProperty(Node p) {
        if (this.countPrefixesForRDF <= 0 && WriterConst.RDF_type.equals(p)) {
            this.out.print('a');
        } else {
            this.outputNode(p);
        }
    }

    protected abstract void startData();

    protected abstract void endData();

    protected abstract void print(Quad var1);

    protected abstract void print(Triple var1);

    protected abstract void reset();
}

