/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.NodeFactoryExtra;

@Deprecated
public class TSVInputIterator
implements Iterator<Binding> {
    private static Pattern pattern = Pattern.compile("\t");
    private BufferedReader reader;
    private Binding currentBinding;
    private int expectedItems;
    private List<Var> vars;
    private long lineNum = 1L;
    private boolean finished = false;

    public TSVInputIterator(BufferedReader reader, List<Var> vars) {
        Objects.requireNonNull(reader);
        this.reader = reader;
        this.expectedItems = vars.size();
        this.vars = vars;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.currentBinding == null) {
            this.currentBinding = this.parseNextBinding();
        }
        if (this.currentBinding == null) {
            IO.close(this.reader);
            this.finished = true;
        }
        return !this.finished;
    }

    @Override
    public Binding next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Binding row = this.currentBinding;
        this.currentBinding = null;
        return row;
    }

    private Binding parseNextBinding() {
        String line;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            ++this.lineNum;
        }
        catch (IOException e2) {
            throw new ResultSetException("Error parsing TSV results - " + e2.getMessage());
        }
        if (line.isEmpty()) {
            if (this.expectedItems > 1) {
                throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row had 0/1 values when %d were expected", this.lineNum, this.expectedItems));
            }
            return BindingFactory.empty();
        }
        String[] tokens = pattern.split(line, -1);
        if (tokens.length != this.expectedItems) {
            throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row '%s' has %d values instead of the expected %d.", this.lineNum, line, tokens.length, this.expectedItems));
        }
        BindingBuilder builder = Binding.builder();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.equals("")) continue;
            try {
                Node node = NodeFactoryExtra.parseNode(token);
                if (!node.isConcrete()) {
                    throw new ResultSetException(String.format("Line %d: Not a concrete RDF term: %s", this.lineNum, token));
                }
                builder.add(this.vars.get(i), node);
                continue;
            }
            catch (RiotException ex) {
                throw new ResultSetException(String.format("Line %d: Data %s contains error: %s", this.lineNum, token, ex.getMessage()));
            }
        }
        return builder.build();
    }
}

