/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.builders.BuilderLib;

public class BuilderPrefixMapping {
    public static PrefixMapping build(Item elt) {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        BuilderPrefixMapping.build(pmap, elt);
        return pmap;
    }

    public static void build(PrefixMapping newMappings, Item elt) {
        if (!elt.isList()) {
            BuilderLib.broken((ItemLocation)elt, "Prefix mapping requires a list of pairs", elt);
        }
        ItemList prefixes = elt.getList();
        if (elt.isTaggedIgnoreCase("prefixmap") || elt.isTaggedIgnoreCase("prefixmapping")) {
            BuilderLib.checkLength(2, elt.getList(), "Not of length 2" + elt.shortString());
            prefixes = prefixes.cdr();
        }
        for (Item pair2 : prefixes) {
            Node iriNode;
            if (!pair2.isList() || pair2.getList().size() != 2) {
                BuilderLib.broken(pair2, "Not a prefix/IRI pair");
            }
            Item prefixItem = pair2.getList().get(0);
            Item iriItem = pair2.getList().get(1);
            String prefix = null;
            if (prefixItem.isSymbol()) {
                prefix = prefixItem.getSymbol();
            }
            if (prefix == null) {
                BuilderLib.broken(pair2, "Prefix part not recognized: " + prefixItem);
            }
            if (!prefix.endsWith(":")) {
                BuilderLib.broken(pair2, "Prefix part does not end with a ':': " + pair2);
            }
            if (StrUtils.contains(prefix = prefix.substring(0, prefix.length() - 1), ":")) {
                BuilderLib.broken(pair2, "Prefix itself contains a ':' : " + pair2);
            }
            if ((iriNode = iriItem.getNode()) == null || !iriNode.isURI()) {
                BuilderLib.broken(pair2, "Not an IRI: " + iriItem);
            }
            String iri = iriNode.getURI();
            newMappings.setNsPrefix(prefix, iri);
        }
    }
}

