/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.util.ModelCollector;
import org.apache.jena.util.iterator.ClosableIterator;

public class ModelUtils {
    public static RDFNode convertGraphNodeToRDFNode(Node node, Model model) {
        if (node.isVariable()) {
            throw new QueryException("Variable: " + node);
        }
        if (model != null) {
            return model.asRDFNode(node);
        }
        if (node.isLiteral()) {
            return new LiteralImpl(node, null);
        }
        if (node.isURI() || node.isBlank()) {
            return new ResourceImpl(node, null);
        }
        if (node.isNodeTriple()) {
            return new ResourceImpl(node, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + node);
    }

    public static RDFNode convertGraphNodeToRDFNode(Node node) {
        return ModelUtils.convertGraphNodeToRDFNode(node, null);
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node oNode;
        Node pNode;
        if (model == null) {
            throw new ARQInternalErrorException("Attempt to create statement with null model");
        }
        Node sNode = t.getSubject();
        if (!ModelUtils.isValidAsStatement(sNode, pNode = t.getPredicate(), oNode = t.getObject())) {
            return null;
        }
        return model.asStatement(t);
    }

    public static boolean isValidAsStatement(Node s, Node p, Node o) {
        if (s.isLiteral() || s.isVariable()) {
            return false;
        }
        if (!p.isURI()) {
            return false;
        }
        return !o.isVariable();
    }

    public static StmtIterator triplesToStatements(final Iterator<Triple> it, Model refModel) {
        return new StmtIteratorImpl(Iter.map(it, refModel::asStatement)){

            @Override
            public void close() {
                if (it instanceof ClosableIterator) {
                    ((ClosableIterator)it).close();
                } else {
                    Iter.close(it);
                }
            }
        };
    }

    public static ModelCollector intersectCollector() {
        return new ModelCollector.IntersectionModelCollector();
    }

    public static ModelCollector unionCollector() {
        return new ModelCollector.UnionModelCollector();
    }

    public static Iterator<Triple> statementsToTriples(Iterator<Statement> it) {
        return Iter.onClose(Iter.map(it, FrontsTriple::asTriple), () -> Iter.close(it));
    }
}

