/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;

public class ProgressDialog
extends JDialog {
    private JProgressBar progressBar;
    private JLabel label;
    private int progress;
    private IOException exception;
    private AbstractExportFileType.CancelThread thread;

    public ProgressDialog(Component parent, int steps, String string) {
        this.setTitle("Exporting file...");
        this.setModal(true);
        this.exception = null;
        this.progress = 0;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel(new GridLayout(2, 1));
        this.progressBar = new JProgressBar(0, steps);
        center.add(this.progressBar);
        this.label = new JLabel(string);
        center.add(this.label);
        this.getContentPane().add((Component)center, "Center");
        JPanel buttons = new JPanel(new FlowLayout(1));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ProgressDialog.this.cancel();
            }
        });
        buttons.add(cancel);
        this.getContentPane().add((Component)buttons, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
        if (parent != null) {
            Point pLoc = parent.getLocation();
            this.setLocation(pLoc.x + parent.getWidth() / 2 - this.getWidth() / 2, pLoc.y + parent.getHeight() / 2 - this.getHeight() / 2);
        }
    }

    public void step(String string) {
        this.progressBar.setValue(++this.progress);
        this.label.setText(string);
        this.repaint();
    }

    public void exceptionOccured(IOException e2) {
        this.exception = e2;
    }

    public IOException getException() {
        return this.exception;
    }

    public void interruptOnCancel(AbstractExportFileType.CancelThread thread) {
        this.thread = thread;
    }

    public void cancel() {
        if (this.thread != null) {
            this.thread.cancel();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        this.dispose();
    }
}

