/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType3;
import org.freehep.graphicsio.pdf.PDFFontIncluder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontTable
extends FontTable {
    private int currentFontIndex = 1;
    private PDFWriter pdf;
    private PDFRedundanceTracker tracker;
    private static final Properties replaceFonts = new Properties();

    public PDFFontTable(PDFWriter pdf) {
        this.pdf = pdf;
        this.tracker = new PDFRedundanceTracker(pdf);
    }

    public int addFontDictionary() throws IOException {
        Collection<FontTable.Entry> fonts = this.getEntries();
        if (fonts.size() > 0) {
            PDFDictionary fontList = this.pdf.openDictionary("FontList");
            for (FontTable.Entry e2 : fonts) {
                fontList.entry(e2.getReference(), this.pdf.ref(e2.getReference()));
            }
            this.pdf.close(fontList);
        }
        return fonts.size();
    }

    public void embedAll(FontRenderContext context2, boolean embed, String embedAs) throws IOException {
        Collection<FontTable.Entry> col = this.getEntries();
        for (FontTable.Entry e2 : col) {
            if (e2.isWritten()) continue;
            e2.setWritten(true);
            FontIncluder fontIncluder = null;
            if (PDFFontIncluder.isStandardFont(e2.getFont())) {
                embed = false;
            }
            if (embed) {
                if (embedAs.equals("Type3")) {
                    fontIncluder = new PDFFontEmbedderType3(context2, this.pdf, e2.getReference(), this.tracker);
                } else if (embedAs.equals("Type1")) {
                    fontIncluder = PDFFontEmbedderType1.create(context2, this.pdf, e2.getReference(), this.tracker);
                } else {
                    System.out.println("PDFFontTable: invalid value for embedAs: " + embedAs);
                }
            } else {
                fontIncluder = new PDFFontIncluder(context2, this.pdf, e2.getReference(), this.tracker);
            }
            fontIncluder.includeFont(e2.getFont(), e2.getEncoding(), e2.getReference());
        }
        this.tracker.writeAll();
    }

    @Override
    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("PDFLatin");
    }

    @Override
    public void firstRequest(FontTable.Entry e2, boolean embed, String embedAs) {
    }

    @Override
    protected Font substituteFont(Font font) {
        String fontName = replaceFonts.getProperty(font.getName(), null);
        if (fontName != null) {
            Font newFont = new Font(fontName, font.getSize(), font.getStyle());
            font = newFont.deriveFont(font.getSize2D());
        }
        return font;
    }

    @Override
    protected String createFontReference(Font f) {
        return "F" + this.currentFontIndex++;
    }

    static {
        replaceFonts.setProperty("Dialog", "Helvetica");
        replaceFonts.setProperty("DialogInput", "Courier");
        replaceFonts.setProperty("Serif", "TimesRoman");
        replaceFonts.setProperty("SansSerif", "Helvetica");
        replaceFonts.setProperty("Monospaced", "Courier");
    }
}

