/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ppm;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.freehep.graphicsio.ppm.ImageEncoder;

public class PPMEncoder
extends ImageEncoder {
    private List<String> comments = new ArrayList<String>();

    public PPMEncoder(Image img, OutputStream out) throws IOException {
        super(img, (DataOutput)new DataOutputStream(out));
    }

    public PPMEncoder(Image img, DataOutput dos) throws IOException {
        super(img, dos);
    }

    public PPMEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, (DataOutput)new DataOutputStream(out));
    }

    public PPMEncoder(ImageProducer prod, DataOutput dos) throws IOException {
        super(prod, dos);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    @Override
    protected void encodeStart(int width, int height) throws IOException {
        this.writeString("P6\n");
        for (String comment : this.comments) {
            this.writeString("# " + comment + "\n");
        }
        this.writeString(width + " " + height + "\n");
        this.writeString("255\n");
    }

    void writeString(String str2) throws IOException {
        byte[] buf = str2.getBytes();
        this.out.write(buf);
    }

    @Override
    protected void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        byte[] ppmPixels = new byte[w * 3];
        for (int row = 0; row < h; ++row) {
            int rowOff = off + row * scansize;
            for (int col = 0; col < w; ++col) {
                int i = rowOff + col;
                int j = col * 3;
                ppmPixels[j] = (byte)((rgbPixels[i] & 0xFF0000) >> 16);
                ppmPixels[j + 1] = (byte)((rgbPixels[i] & 0xFF00) >> 8);
                ppmPixels[j + 2] = (byte)(rgbPixels[i] & 0xFF);
            }
            this.out.write(ppmPixels);
        }
    }

    @Override
    protected void encodeDone() throws IOException {
    }
}

