/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;

public class Atom
extends AtomType
implements IAtom,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3137373012494608794L;
    protected Point2d point2d = (Point2d)CDKConstants.UNSET;
    protected Point3d point3d = (Point3d)CDKConstants.UNSET;
    protected Point3d fractionalPoint3d = (Point3d)CDKConstants.UNSET;
    protected Integer hydrogenCount = (Integer)CDKConstants.UNSET;
    protected Integer stereoParity = (Integer)CDKConstants.UNSET;
    protected Double charge = (Double)CDKConstants.UNSET;

    public Atom() {
        super((String)null);
    }

    public Atom(int elem) {
        this(elem, 0, 0);
    }

    public Atom(int elem, int hcnt) {
        this(elem, hcnt, 0);
    }

    public Atom(int elem, int hcnt, int fchg) {
        super((String)null);
        this.setAtomicNumber(elem);
        this.setSymbol(Elements.ofNumber(elem).symbol());
        this.setImplicitHydrogenCount(hcnt);
        this.setFormalCharge(fchg);
    }

    public Atom(String symbol) {
        super((String)null);
        if (!Atom.parseAtomSymbol(this, symbol)) {
            throw new IllegalArgumentException("Cannot pass atom symbol: " + symbol);
        }
    }

    public Atom(String elementSymbol, Point3d point3d) {
        this(elementSymbol);
        this.point3d = point3d;
    }

    public Atom(String elementSymbol, Point2d point2d) {
        this(elementSymbol);
        this.point2d = point2d;
    }

    public Atom(IElement element) {
        super(element);
        if (element instanceof IAtom) {
            this.point2d = ((IAtom)element).getPoint2d() != null ? new Point2d(((IAtom)element).getPoint2d()) : null;
            this.point3d = ((IAtom)element).getPoint3d() != null ? new Point3d(((IAtom)element).getPoint3d()) : null;
            this.fractionalPoint3d = ((IAtom)element).getFractionalPoint3d() != null ? new Point3d(((IAtom)element).getFractionalPoint3d()) : null;
            this.hydrogenCount = ((IAtom)element).getImplicitHydrogenCount();
            this.charge = ((IAtom)element).getCharge();
            this.stereoParity = ((IAtom)element).getStereoParity();
        }
    }

    @Override
    public IAtomContainer getContainer() {
        return null;
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @Override
    public Iterable<IBond> bonds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBondCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBond getBond(IAtom atom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharge(Double charge) {
        this.charge = charge;
        this.notifyChanged();
    }

    @Override
    public Double getCharge() {
        return this.charge;
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
        this.notifyChanged();
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        return this.hydrogenCount;
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
        this.notifyChanged();
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
        this.notifyChanged();
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
        this.notifyChanged();
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        this.stereoParity = stereoParity;
        this.notifyChanged();
    }

    @Override
    public Point2d getPoint2d() {
        return this.point2d;
    }

    @Override
    public Point3d getPoint3d() {
        return this.point3d;
    }

    @Override
    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    @Override
    public Integer getStereoParity() {
        return this.stereoParity;
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof IAtom)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        Atom atom = (Atom)object;
        return (this.point2d == atom.point2d || this.point2d != null && this.point2d.equals(atom.point2d)) && (this.point3d == atom.point3d || this.point3d != null && this.point3d.equals(atom.point3d)) && Objects.equals(this.hydrogenCount, atom.hydrogenCount) && Objects.equals(this.stereoParity, atom.stereoParity) && Objects.equals(this.charge, atom.charge);
    }

    @Override
    public boolean isAromatic() {
        return this.getFlag(32);
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    @Override
    public boolean isInRing() {
        return this.getFlag(2);
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    @Override
    public int getMapIdx() {
        Integer mapidx = (Integer)this.getProperty("cdk:AtomAtomMapping");
        if (mapidx == null) {
            return 0;
        }
        return mapidx;
    }

    @Override
    public void setMapIdx(int mapidx) {
        if (mapidx < 0) {
            throw new IllegalArgumentException("setMapIdx(val) value must be >= 0");
        }
        this.setProperty("cdk:AtomAtomMapping", mapidx);
    }

    @Override
    public String toString() {
        StringBuilder stringContent = new StringBuilder(64);
        stringContent.append("Atom(").append(this.hashCode());
        if (this.getSymbol() != null) {
            stringContent.append(", S:").append(this.getSymbol());
        }
        if (this.getImplicitHydrogenCount() != null) {
            stringContent.append(", H:").append(this.getImplicitHydrogenCount());
        }
        if (this.getStereoParity() != null) {
            stringContent.append(", SP:").append(this.getStereoParity());
        }
        if (this.getPoint2d() != null) {
            stringContent.append(", 2D:[").append(this.getPoint2d()).append(']');
        }
        if (this.getPoint3d() != null) {
            stringContent.append(", 3D:[").append(this.getPoint3d()).append(']');
        }
        if (this.getFractionalPoint3d() != null) {
            stringContent.append(", F3D:[").append(this.getFractionalPoint3d());
        }
        if (this.getCharge() != null) {
            stringContent.append(", C:").append(this.getCharge());
        }
        stringContent.append(", ").append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IAtom clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        if (this.point2d != null) {
            ((Atom)clone).setPoint2d(new Point2d(this.point2d.x, this.point2d.y));
        }
        if (this.point3d != null) {
            ((Atom)clone).setPoint3d(new Point3d(this.point3d.x, this.point3d.y, this.point3d.z));
        }
        if (this.fractionalPoint3d != null) {
            ((Atom)clone).setFractionalPoint3d(new Point3d(this.fractionalPoint3d.x, this.fractionalPoint3d.y, this.fractionalPoint3d.z));
        }
        return (IAtom)clone;
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean parseAtomSymbol(IAtom atom, String str2) {
        int len = str2.length();
        int pos = 0;
        int mass = -1;
        int anum = 0;
        int hcnt = -1;
        int chg = 0;
        String symbol = null;
        boolean flag = false;
        if (pos < len && Atom.isDigit(str2.charAt(pos))) {
            mass = str2.charAt(pos++) - 48;
            while (pos < len && Atom.isDigit(str2.charAt(pos))) {
                mass = 10 * mass + (str2.charAt(pos++) - 48);
            }
        } else if ("R".equals(str2)) {
            anum = 0;
            symbol = "R";
            flag = true;
        } else if ("*".equals(str2)) {
            anum = 0;
            symbol = "*";
            flag = true;
        } else if ("D".equals(str2)) {
            anum = 1;
            mass = 2;
            symbol = "H";
            flag = true;
        } else if ("T".equals(str2)) {
            anum = 1;
            mass = 3;
            symbol = "H";
            flag = true;
        }
        if (!flag) {
            if (pos < len && Atom.isUpper(str2.charAt(pos))) {
                int beg = pos++;
                while (pos < len && Atom.isLower(str2.charAt(pos))) {
                    ++pos;
                }
                Elements elem = Elements.ofString(str2.substring(beg, pos));
                if (elem == Elements.Unknown) {
                    return false;
                }
                anum = elem.number();
                block7: while (pos < len) {
                    switch (str2.charAt(pos)) {
                        case 'H': {
                            if (++pos < len && Atom.isDigit(str2.charAt(pos))) {
                                hcnt = 0;
                                while (pos < len && Atom.isDigit(str2.charAt(pos))) {
                                    hcnt = 10 * hcnt + (str2.charAt(pos++) - 48);
                                }
                                continue block7;
                            }
                            hcnt = 1;
                            continue block7;
                        }
                        case '+': {
                            if (++pos < len && Atom.isDigit(str2.charAt(pos))) {
                                chg = str2.charAt(pos++) - 48;
                                while (pos < len && Atom.isDigit(str2.charAt(pos))) {
                                    chg = 10 * chg + (str2.charAt(pos++) - 48);
                                }
                                continue block7;
                            }
                            chg = 1;
                            continue block7;
                        }
                        case '-': {
                            if (++pos < len && Atom.isDigit(str2.charAt(pos))) {
                                chg = str2.charAt(pos++) - 48;
                                while (pos < len && Atom.isDigit(str2.charAt(pos))) {
                                    chg = 10 * chg + (str2.charAt(pos++) - 48);
                                }
                                chg *= -1;
                                continue block7;
                            }
                            chg = -1;
                            continue block7;
                        }
                    }
                    return false;
                }
            } else {
                return false;
            }
            flag = pos == len && len > 0;
            symbol = Elements.ofNumber(anum).symbol();
        }
        if (!flag) {
            return false;
        }
        if (mass < 0) {
            atom.setMassNumber(null);
        } else {
            atom.setMassNumber(mass);
        }
        atom.setAtomicNumber(anum);
        atom.setSymbol(symbol);
        if (hcnt >= 0) {
            atom.setImplicitHydrogenCount(hcnt);
        }
        atom.setFormalCharge(chg);
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AtomRef) {
            return super.equals(((AtomRef)obj).deref());
        }
        return super.equals(obj);
    }
}

