/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.RingSearch;

final class PiBondModel
extends ElectronDonation {
    PiBondModel() {
    }

    @Override
    int[] contribution(IAtomContainer container2, RingSearch ringSearch) {
        int n = container2.getAtomCount();
        int[] electrons = new int[n];
        int[] piBonds = new int[n];
        for (IBond bond : container2.bonds()) {
            int u = container2.indexOf(bond.getBegin());
            int v = container2.indexOf(bond.getEnd());
            if (bond.getOrder() != IBond.Order.DOUBLE || !ringSearch.cyclic(u, v)) continue;
            int n2 = u;
            piBonds[n2] = piBonds[n2] + 1;
            int n3 = v;
            piBonds[n3] = piBonds[n3] + 1;
        }
        for (int i = 0; i < n; ++i) {
            electrons[i] = piBonds[i] == 1 ? 1 : -1;
        }
        return electrons;
    }
}

