/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.atomtype.IAtomTypeGuesser;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class StructGenAtomTypeGuesser
implements IAtomTypeGuesser {
    private static AtomTypeFactory factory = null;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(StructGenAtomTypeGuesser.class);

    @Override
    public List<IAtomType> possibleAtomTypes(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType[] types;
        if (factory == null) {
            try {
                factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", atom.getBuilder());
            }
            catch (Exception ex1) {
                logger.error(ex1.getMessage());
                logger.debug(ex1);
                throw new CDKException("Could not instantiate the AtomType list!", ex1);
            }
        }
        double bondOrderSum = atomContainer.getBondOrderSum(atom);
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        int charge = atom.getFormalCharge();
        int hcount = atom.getImplicitHydrogenCount();
        ArrayList<IAtomType> matchingTypes = new ArrayList<IAtomType>();
        for (IAtomType type : types = factory.getAtomTypes(atom.getSymbol())) {
            logger.debug("   ... matching atom ", atom, " vs ", type);
            if (!(bondOrderSum - (double)charge + (double)hcount <= type.getBondOrderSum()) || BondManipulator.isHigherOrder(maxBondOrder, type.getMaxBondOrder())) continue;
            matchingTypes.add(type);
        }
        logger.debug("    No Match");
        return matchingTypes;
    }
}

