/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.util.Collections;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

final class ImmutableAtomType
implements IAtomType {
    private final String element;
    private final Integer atomicNumber;
    private final Double naturalAbundance;
    private final Double exactMass;
    private final Integer massNumber;
    private final Integer formalCharge;
    private final IAtomType.Hybridization hybridization;
    private final Integer electronValency;
    private final Integer formalNeighbourCount;
    private final String identifier;
    private final IBond.Order maxBondOrder;
    private final Double bondOrderSum;
    private final Double covalentRadius;
    private final short flags;
    private final Map<Object, Object> properties;

    ImmutableAtomType(IAtomType type) {
        Integer piBondCount;
        this.element = type.getSymbol();
        this.atomicNumber = type.getAtomicNumber();
        this.naturalAbundance = type.getNaturalAbundance();
        this.exactMass = type.getExactMass();
        this.massNumber = type.getMassNumber();
        this.formalCharge = type.getFormalCharge();
        this.hybridization = type.getHybridization();
        this.formalNeighbourCount = type.getFormalNeighbourCount();
        this.identifier = type.getAtomTypeName();
        this.maxBondOrder = type.getMaxBondOrder();
        this.bondOrderSum = type.getBondOrderSum();
        this.covalentRadius = type.getCovalentRadius();
        this.flags = (Short)type.getFlagValue();
        this.properties = Collections.unmodifiableMap(type.getProperties());
        this.electronValency = type.getValency() != null ? type.getValency() : ((piBondCount = type.getProperty("cdk:Pi Bond Count", Integer.class)) != null && this.formalNeighbourCount != null ? Integer.valueOf(piBondCount + this.formalNeighbourCount) : null);
    }

    @Override
    public void addListener(IChemObjectListener col) {
    }

    @Override
    public int getListenerCount() {
        return 0;
    }

    @Override
    public void removeListener(IChemObjectListener col) {
    }

    @Override
    public void setNotification(boolean bool) {
    }

    @Override
    public boolean getNotification() {
        return false;
    }

    @Override
    public void notifyChanged() {
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    @Override
    public Number getFlagValue() {
        return this.flags;
    }

    @Override
    public void setProperty(Object description, Object property) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void removeProperty(Object description) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public <T> T getProperty(Object description) {
        if (!this.properties.containsKey(description)) {
            return null;
        }
        Object value = this.properties.get(description);
        return (T)value;
    }

    @Override
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.properties.get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public void setID(String identifier) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setFlag(int flagType, boolean flagValue) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public boolean getFlag(int flagType) {
        return (this.flags & flagType) != 0;
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return null;
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setSymbol(String symbol) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setExactMass(Double exactMass) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public String getSymbol() {
        return this.element;
    }

    @Override
    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    @Override
    public Double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    @Override
    public Double getExactMass() {
        return this.exactMass;
    }

    @Override
    public Integer getMassNumber() {
        return this.massNumber;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public void setAtomTypeName(String identifier) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public String getAtomTypeName() {
        return this.identifier;
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        return this.maxBondOrder;
    }

    @Override
    public Double getBondOrderSum() {
        return this.bondOrderSum;
    }

    @Override
    public void setFormalCharge(Integer charge) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public Integer getFormalCharge() {
        return this.formalCharge;
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public Integer getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        return this.hybridization;
    }

    @Override
    public void setCovalentRadius(Double radius) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    @Override
    public void setValency(Integer valency) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    @Override
    public Integer getValency() {
        return this.electronValency;
    }

    @Override
    public String toString() {
        StringBuilder resultString = new StringBuilder(64);
        resultString.append("ImmutableAtomType(").append(this.hashCode());
        if (this.getAtomTypeName() != null) {
            resultString.append(", N:").append(this.getAtomTypeName());
        }
        if (this.getMaxBondOrder() != null) {
            resultString.append(", MBO:").append((Object)this.getMaxBondOrder());
        }
        if (this.getBondOrderSum() != null) {
            resultString.append(", BOS:").append(this.getBondOrderSum());
        }
        if (this.getFormalCharge() != null) {
            resultString.append(", FC:").append(this.getFormalCharge());
        }
        if (this.getHybridization() != null) {
            resultString.append(", H:").append((Object)this.getHybridization());
        }
        if (this.getFormalNeighbourCount() != null) {
            resultString.append(", NC:").append(this.getFormalNeighbourCount());
        }
        if (this.getCovalentRadius() != null) {
            resultString.append(", CR:").append(this.getCovalentRadius());
        }
        if (this.getValency() != null) {
            resultString.append(", EV:").append(this.getValency());
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }
}

