/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config.atomtypes;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AtomTypeHandler
extends DefaultHandler {
    private final int SCALAR_UNSET = 0;
    private final int SCALAR_MAXBONDORDER = 1;
    private final int SCALAR_BONDORDERSUM = 2;
    private final int SCALAR_HYBRIDIZATION = 3;
    private final int SCALAR_FORMALNEIGHBOURCOUNT = 4;
    private final int SCALAR_VALENCY = 5;
    private final int SCALAR_DA = 6;
    private final int SCALAR_SPHERICALMATCHER = 7;
    private final int SCALAR_CHEMICALGROUPCONSTANT = 8;
    private final int SCALAR_RINGSIZE = 9;
    private final int SCALAR_ISAROMATIC = 10;
    private final int SCALAR_FORMALCHARGE = 11;
    private final int SCALAR_VANDERWAALSRADIUS = 12;
    private final int SCALAR_PIBONDCOUNT = 13;
    private final int SCALAR_LONEPAIRCOUNT = 14;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeHandler.class);
    private String currentChars;
    private List<IAtomType> atomTypes;
    private int scalarType;
    private IAtomType atomType;
    private static IChemObjectBuilder builder;

    public AtomTypeHandler(IChemObjectBuilder build) {
        builder = build;
    }

    public List<IAtomType> getAtomTypes() {
        return this.atomTypes;
    }

    @Override
    public void startDocument() {
        this.atomTypes = new ArrayList<IAtomType>();
        this.scalarType = 0;
        this.atomType = null;
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        logger.debug("END Element: ", raw);
        logger.debug("  uri: ", uri);
        logger.debug("  local: ", local);
        logger.debug("  raw: ", raw);
        logger.debug("  chars: ", this.currentChars.trim());
        if ("atomType".equals(local)) {
            this.atomTypes.add(this.atomType);
        } else if ("scalar".equals(local)) {
            this.currentChars = this.currentChars.trim();
            try {
                if (this.scalarType == 2) {
                    this.atomType.setBondOrderSum(Double.parseDouble(this.currentChars));
                } else if (this.scalarType == 1) {
                    double scalarValue = Double.parseDouble(this.currentChars);
                    if (scalarValue == 1.0) {
                        this.atomType.setMaxBondOrder(IBond.Order.SINGLE);
                    } else if (scalarValue == 2.0) {
                        this.atomType.setMaxBondOrder(IBond.Order.DOUBLE);
                    } else if (scalarValue == 3.0) {
                        this.atomType.setMaxBondOrder(IBond.Order.TRIPLE);
                    } else if (scalarValue == 4.0) {
                        this.atomType.setMaxBondOrder(IBond.Order.QUADRUPLE);
                    }
                } else if (this.scalarType == 4) {
                    this.atomType.setFormalNeighbourCount(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 5) {
                    this.atomType.setValency(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 11) {
                    this.atomType.setFormalCharge(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 3) {
                    if ("sp1".equals(this.currentChars)) {
                        this.atomType.setHybridization(IAtomType.Hybridization.SP1);
                    } else if ("sp2".equals(this.currentChars)) {
                        this.atomType.setHybridization(IAtomType.Hybridization.SP2);
                    } else if ("sp3".equals(this.currentChars)) {
                        this.atomType.setHybridization(IAtomType.Hybridization.SP3);
                    } else if ("planar".equals(this.currentChars)) {
                        this.atomType.setHybridization(IAtomType.Hybridization.PLANAR3);
                    } else {
                        logger.warn("Unrecognized hybridization in config file: ", this.currentChars);
                    }
                } else if (this.scalarType == 6) {
                    if ("A".equals(this.currentChars)) {
                        this.atomType.setFlag(512, true);
                    } else if ("D".equals(this.currentChars)) {
                        this.atomType.setFlag(256, true);
                    } else {
                        logger.warn("Unrecognized H-bond donor/acceptor pattern in config file: ", this.currentChars);
                    }
                } else if (this.scalarType == 7) {
                    this.atomType.setProperty("cdk:HOSE code spherical matcher", this.currentChars);
                } else if (this.scalarType == 9) {
                    this.atomType.setProperty("cdk:Part of ring of size", Integer.valueOf(this.currentChars));
                } else if (this.scalarType == 8) {
                    this.atomType.setProperty("cdk:Chemical Group", Integer.valueOf(this.currentChars));
                } else if (this.scalarType == 10) {
                    this.atomType.setFlag(32, true);
                } else if (this.scalarType == 13) {
                    this.atomType.setProperty("cdk:Pi Bond Count", Integer.valueOf(this.currentChars));
                } else if (this.scalarType == 14) {
                    this.atomType.setProperty("cdk:Lone Pair Count", Integer.valueOf(this.currentChars));
                }
            }
            catch (Exception exception) {
                logger.error("Value (", this.currentChars, ") is not off the expected type: ", exception.getMessage());
                logger.debug(exception);
            }
            this.scalarType = 0;
        }
        this.currentChars = "";
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        block22: {
            block24: {
                block23: {
                    block21: {
                        this.currentChars = "";
                        logger.debug("START Element: ", raw);
                        logger.debug("  uri: ", uri);
                        logger.debug("  local: ", local);
                        logger.debug("  raw: ", raw);
                        if (!"atomType".equals(local)) break block21;
                        this.atomType = builder.newInstance(IAtomType.class, "R");
                        for (int i = 0; i < atts.getLength(); ++i) {
                            if (!"id".equals(atts.getQName(i))) continue;
                            this.atomType.setAtomTypeName(atts.getValue(i));
                        }
                        break block22;
                    }
                    if (!"atom".equals(local)) break block23;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if ("elementType".equals(atts.getQName(i))) {
                            this.atomType.setSymbol(atts.getValue(i));
                            continue;
                        }
                        if (!"formalCharge".equals(atts.getQName(i))) continue;
                        try {
                            this.atomType.setFormalCharge(Integer.parseInt(atts.getValue(i)));
                            continue;
                        }
                        catch (NumberFormatException exception) {
                            logger.error("Value of <atom> @", atts.getQName(i), " is not an integer: ", atts.getValue(i));
                            logger.debug(exception);
                        }
                    }
                    break block22;
                }
                if (!"label".equals(local)) break block24;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!"value".equals(atts.getQName(i))) continue;
                    if (this.atomType.getAtomTypeName() != null) {
                        this.atomType.setID(this.atomType.getAtomTypeName());
                    }
                    this.atomType.setAtomTypeName(atts.getValue(i));
                }
                break block22;
            }
            if (!"scalar".equals(local)) break block22;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                if ("cdk:maxBondOrder".equals(atts.getValue(i))) {
                    this.scalarType = 1;
                    continue;
                }
                if ("cdk:bondOrderSum".equals(atts.getValue(i))) {
                    this.scalarType = 2;
                    continue;
                }
                if ("cdk:hybridization".equals(atts.getValue(i))) {
                    this.scalarType = 3;
                    continue;
                }
                if ("cdk:formalNeighbourCount".equals(atts.getValue(i))) {
                    this.scalarType = 4;
                    continue;
                }
                if ("cdk:valency".equals(atts.getValue(i))) {
                    this.scalarType = 5;
                    continue;
                }
                if ("cdk:formalCharge".equals(atts.getValue(i))) {
                    this.scalarType = 11;
                    continue;
                }
                if ("cdk:DA".equals(atts.getValue(i))) {
                    this.scalarType = 6;
                    continue;
                }
                if ("cdk:sphericalMatcher".equals(atts.getValue(i))) {
                    this.scalarType = 7;
                    continue;
                }
                if ("cdk:ringSize".equals(atts.getValue(i))) {
                    this.scalarType = 9;
                    continue;
                }
                if ("cdk:ringConstant".equals(atts.getValue(i))) {
                    this.scalarType = 8;
                    continue;
                }
                if ("cdk:aromaticAtom".equals(atts.getValue(i))) {
                    this.scalarType = 10;
                    continue;
                }
                if ("emboss:vdwrad".equals(atts.getValue(i))) {
                    this.scalarType = 12;
                    continue;
                }
                if ("cdk:piBondCount".equals(atts.getValue(i))) {
                    this.scalarType = 13;
                    continue;
                }
                if (!"cdk:lonePairCount".equals(atts.getValue(i))) continue;
                this.scalarType = 14;
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        logger.debug("character data");
        this.currentChars = this.currentChars + new String(chars, start, length);
    }
}

