/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugReaction
extends Reaction
implements IReaction {
    private static final long serialVersionUID = -8958358842308217875L;
    final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugReaction.class);

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug("Setting flag: ", flagType + "=" + flagValue);
        super.setFlag(flagType, flagValue);
    }

    @Override
    public boolean getFlag(int flagType) {
        this.logger.debug("Setting flag: ", flagType + "=" + super.getFlag(flagType));
        return super.getFlag(flagType);
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.addProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public int getReactantCount() {
        this.logger.debug("Getting reactant count: ", super.getReactantCount());
        return super.getReactantCount();
    }

    @Override
    public int getProductCount() {
        this.logger.debug("Getting product count: ", super.getProductCount());
        return super.getProductCount();
    }

    @Override
    public IAtomContainerSet getReactants() {
        this.logger.debug("Getting reactants: ", super.getReactants());
        return super.getReactants();
    }

    @Override
    public void setReactants(IAtomContainerSet reactants) {
        this.logger.debug("Setting reactants: ", reactants);
        super.setReactants(reactants);
    }

    @Override
    public IAtomContainerSet getProducts() {
        this.logger.debug("Getting products: ", super.getProducts());
        return super.getProducts();
    }

    @Override
    public void setProducts(IAtomContainerSet products) {
        this.logger.debug("Setting products: ", products);
        super.setProducts(products);
    }

    @Override
    public IAtomContainerSet getAgents() {
        this.logger.debug("Getting agents: ", super.getAgents());
        return super.getAgents();
    }

    @Override
    public void addReactant(IAtomContainer reactant) {
        this.logger.debug("Adding reactant: ", reactant);
        super.addReactant(reactant);
    }

    @Override
    public void addAgent(IAtomContainer agent) {
        this.logger.debug("Adding agent: ", agent);
        super.addAgent(agent);
    }

    @Override
    public void addReactant(IAtomContainer reactant, Double coefficient) {
        this.logger.debug("Adding reactant with coefficient: ", reactant, "" + coefficient);
        super.addReactant(reactant, coefficient);
    }

    @Override
    public void addProduct(IAtomContainer product) {
        this.logger.debug("Adding product: ", product);
        super.addProduct(product);
    }

    @Override
    public void addProduct(IAtomContainer product, Double coefficient) {
        this.logger.debug("Adding product with coefficient: ", product, "" + coefficient);
        super.addProduct(product, coefficient);
    }

    @Override
    public Double getReactantCoefficient(IAtomContainer reactant) {
        this.logger.debug("Setting reactant coefficient: ", reactant, "" + super.getReactantCoefficient(reactant));
        return super.getReactantCoefficient(reactant);
    }

    @Override
    public Double getProductCoefficient(IAtomContainer product) {
        this.logger.debug("Setting product coefficient: ", product, "" + super.getProductCoefficient(product));
        return super.getProductCoefficient(product);
    }

    @Override
    public boolean setReactantCoefficient(IAtomContainer reactant, Double coefficient) {
        this.logger.debug("Setting reactant coefficient: ", reactant, "" + coefficient);
        return super.setReactantCoefficient(reactant, coefficient);
    }

    @Override
    public boolean setProductCoefficient(IAtomContainer product, Double coefficient) {
        this.logger.debug("Setting product coefficient: ", product, "" + coefficient);
        return super.setProductCoefficient(product, coefficient);
    }

    @Override
    public Double[] getReactantCoefficients() {
        this.logger.debug("Getting reactant coefficients: ", super.getReactantCoefficients().length);
        return super.getReactantCoefficients();
    }

    @Override
    public Double[] getProductCoefficients() {
        this.logger.debug("Getting product coefficients: ", super.getProductCoefficients().length);
        return super.getProductCoefficients();
    }

    @Override
    public boolean setReactantCoefficients(Double[] coefficients) {
        this.logger.debug("Setting reactant coefficients: ", coefficients.length);
        return super.setReactantCoefficients(coefficients);
    }

    @Override
    public boolean setProductCoefficients(Double[] coefficients) {
        this.logger.debug("Setting product coefficients: ", coefficients.length);
        return super.setProductCoefficients(coefficients);
    }

    @Override
    public void setDirection(IReaction.Direction direction) {
        this.logger.debug("Setting direction: ", new Object[]{direction});
        super.setDirection(direction);
    }

    @Override
    public IReaction.Direction getDirection() {
        this.logger.debug("Getting direction: ", new Object[]{super.getDirection()});
        return super.getDirection();
    }
}

