/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.dict.DictionaryHandler;
import org.openscience.cdk.dict.Entry;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Dictionary {
    private final Map<String, Entry> entries = new Hashtable<String, Entry>();
    private String ownNS = null;

    public static Dictionary unmarshal(Reader reader) {
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(Dictionary.class);
        DictionaryHandler handler = new DictionaryHandler();
        XMLReader parser = null;
        try {
            SAXParserFactory factor = SAXParserFactory.newInstance();
            factor.setNamespaceAware(true);
            factor.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parser = factor.newSAXParser().getXMLReader();
            logger.debug("Using " + parser);
        }
        catch (Exception e2) {
            logger.error("Could not instantiate any JAXP parser!");
            logger.debug(e2);
        }
        try {
            if (parser == null) {
                logger.debug("parser object was null!");
                return null;
            }
            parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.debug("Deactivated validation");
        }
        catch (SAXException e3) {
            logger.warn("Cannot deactivate validation.");
            logger.debug(e3);
        }
        parser.setContentHandler(handler);
        Dictionary dict = null;
        try {
            parser.parse(new InputSource(reader));
            dict = handler.getDictionary();
        }
        catch (IOException e4) {
            logger.error("IOException: " + e4);
            logger.debug(e4);
        }
        catch (SAXException saxe) {
            logger.error("SAXException: " + saxe.getClass().getName());
            logger.debug(saxe);
        }
        return dict;
    }

    void addEntry(Entry entry) {
        this.entries.put(entry.getID().toLowerCase(), entry);
    }

    public Entry[] getEntries() {
        int size = this.entries.size();
        Entry[] entryArray = new Entry[size];
        Iterator<Entry> elements = this.entries.values().iterator();
        for (int counter = 0; elements.hasNext() && counter < size; ++counter) {
            entryArray[counter] = elements.next();
        }
        return entryArray;
    }

    public boolean hasEntry(String identifier) {
        return this.entries.containsKey(identifier);
    }

    public Entry getEntry(String identifier) {
        return this.entries.get(identifier);
    }

    public int size() {
        return this.entries.size();
    }

    public void setNS(String nameSpace) {
        this.ownNS = nameSpace;
    }

    public String getNS() {
        return this.ownNS;
    }
}

