/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

public class MolecularFormulaSet
implements Iterable<IMolecularFormula>,
IMolecularFormulaSet,
Cloneable {
    private static final long serialVersionUID = -2043178712150212550L;
    private final List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public MolecularFormulaSet() {
    }

    public MolecularFormulaSet(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    @Override
    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    @Override
    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    @Override
    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    @Override
    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    @Override
    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    @Override
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    @Override
    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MolecularFormulaSet clone = new MolecularFormulaSet();
        for (IMolecularFormula mf : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)mf.clone());
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

