/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip;

import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class Ligand
implements ILigand {
    private final IAtomContainer container;
    private final IAtom centralAtom;
    private final IAtom ligandAtom;
    private final VisitedAtoms visitedAtoms;

    public Ligand(IAtomContainer container2, VisitedAtoms visitedAtoms, IAtom centralAtom, IAtom ligandAtom) {
        this.container = container2;
        this.centralAtom = centralAtom;
        this.ligandAtom = ligandAtom;
        this.visitedAtoms = new VisitedAtoms();
        this.visitedAtoms.visited(visitedAtoms);
        this.visitedAtoms.visited(centralAtom);
    }

    @Override
    public IAtomContainer getAtomContainer() {
        return this.container;
    }

    @Override
    public IAtom getCentralAtom() {
        return this.centralAtom;
    }

    @Override
    public IAtom getLigandAtom() {
        return this.ligandAtom;
    }

    @Override
    public VisitedAtoms getVisitedAtoms() {
        return this.visitedAtoms;
    }

    @Override
    public boolean isVisited(IAtom atom) {
        return this.visitedAtoms.isVisited(atom);
    }
}

