/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.volume;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IRingSet;

public class VABCVolume {
    private static final Map<String, Double> bondiiVolumes = VABCVolume.loadVolumes();
    private static AtomTypeFactory atomTypeList = null;

    private static Map<String, Double> loadVolumes() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("H", 7.2382293504);
        map.put("C", 20.5795259250667);
        map.put("N", 15.5985308577667);
        map.put("O", 14.7102267005611);
        map.put("Cl", 22.4492971208333);
        map.put("Br", 26.5218483279667);
        map.put("F", 13.3057882007064);
        map.put("I", 32.5150310206656);
        map.put("S", 24.4290240576);
        map.put("P", 24.4290240576);
        map.put("As", 26.5218483279667);
        map.put("B", 40.48);
        map.put("Se", 28.7309115245333);
        map.put("Si", 38.7923854248);
        return Collections.unmodifiableMap(map);
    }

    public static double calculate(IAtomContainer molecule) throws CDKException {
        if (atomTypeList == null) {
            atomTypeList = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", molecule.getBuilder());
        }
        double sum = 0.0;
        int totalHCount = 0;
        for (IAtom atom : molecule.atoms()) {
            Double bondiiVolume = bondiiVolumes.get(atom.getSymbol());
            if (bondiiVolume == null) {
                throw new CDKException("Unsupported element.");
            }
            sum += bondiiVolume.doubleValue();
            IAtomType type = atomTypeList.getAtomType(atom.getAtomTypeName());
            if (type == null) {
                throw new CDKException("Unknown atom type for atom: " + atom.getSymbol());
            }
            if (type.getFormalNeighbourCount() == null) {
                throw new CDKException("Formal neighbor count not given for : " + type.getAtomTypeName());
            }
            int hCount = type.getFormalNeighbourCount() - molecule.getConnectedBondsCount(atom);
            sum += (double)hCount * bondiiVolumes.get("H");
            totalHCount += hCount;
        }
        sum -= 5.92 * (double)(molecule.getBondCount() + totalHCount);
        boolean[] originalFlags = molecule.getFlags();
        Aromaticity.cdkLegacy().apply(molecule);
        IRingSet ringSet = Cycles.sssr(molecule).toRingSet();
        if (ringSet.getAtomContainerCount() > 0) {
            int aromRingCount = 0;
            int nonAromRingCount = 0;
            for (IAtomContainer ring : ringSet.atomContainers()) {
                if (VABCVolume.ringIsAromatic(ring)) {
                    ++aromRingCount;
                    continue;
                }
                ++nonAromRingCount;
            }
            molecule.setFlags(originalFlags);
            sum -= 14.7 * (double)aromRingCount;
            sum -= 3.8 * (double)nonAromRingCount;
        }
        return sum;
    }

    private static boolean ringIsAromatic(IAtomContainer ring) {
        for (IAtom atom : ring.atoms()) {
            if (atom.getFlag(32)) continue;
            return false;
        }
        return true;
    }
}

