/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public final class ShortestPaths {
    private static final int[] EMPTY_PATH = new int[0];
    private static final int[][] EMPTY_PATHS = new int[0][];
    private final Route[] routeTo;
    private final int[] distTo;
    private final int[] nPathsTo;
    private final boolean[] precedes;
    private final int start;
    private final int limit;
    private final IAtomContainer container;

    public ShortestPaths(IAtomContainer container2, IAtom start) {
        this(GraphUtil.toAdjList(container2), container2, container2.indexOf(start));
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container2, int start) {
        this(adjacent, container2, start, null);
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container2, int start, int[] ordering) {
        this(adjacent, container2, start, adjacent.length, ordering);
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container2, int start, int limit, int[] ordering) {
        int n = adjacent.length;
        this.container = container2;
        this.start = start;
        this.limit = limit;
        this.distTo = new int[n];
        this.routeTo = new Route[n];
        this.nPathsTo = new int[n];
        this.precedes = new boolean[n];
        if (n == 0) {
            return;
        }
        if (start == -1) {
            throw new IllegalArgumentException("invalid vertex start - atom not found container");
        }
        for (int i = 0; i < n; ++i) {
            this.distTo[i] = Integer.MAX_VALUE;
        }
        this.distTo[start] = 0;
        this.routeTo[start] = new Source(start);
        this.nPathsTo[start] = 1;
        this.precedes[start] = true;
        if (ordering != null) {
            this.compute(adjacent, ordering);
        } else {
            this.compute(adjacent);
        }
    }

    private void compute(int[][] adjacent) {
        int[] queue = new int[adjacent.length];
        queue[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int v = queue[i];
            int dist = this.distTo[v] + 1;
            for (int w : adjacent[v]) {
                if (dist > this.limit) continue;
                if (dist < this.distTo[w]) {
                    this.distTo[w] = dist;
                    this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
                    this.nPathsTo[w] = this.nPathsTo[v];
                    queue[n++] = w;
                    continue;
                }
                if (this.distTo[w] != dist) continue;
                this.routeTo[w] = new Branch(this.routeTo[w], new SequentialRoute(this.routeTo[v], w));
                int n2 = w;
                this.nPathsTo[n2] = this.nPathsTo[n2] + this.nPathsTo[v];
            }
        }
    }

    private void compute(int[][] adjacent, int[] ordering) {
        int[] queue = new int[adjacent.length];
        queue[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int v = queue[i];
            int dist = this.distTo[v] + 1;
            for (int w : adjacent[v]) {
                if (dist < this.distTo[w]) {
                    this.distTo[w] = dist;
                    this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
                    this.nPathsTo[w] = this.nPathsTo[v];
                    this.precedes[w] = this.precedes[v] && ordering[w] < ordering[this.start];
                    queue[n++] = w;
                    continue;
                }
                if (this.distTo[w] != dist || !this.precedes[v] || ordering[w] >= ordering[this.start]) continue;
                if (this.precedes[w]) {
                    this.routeTo[w] = new Branch(this.routeTo[w], new SequentialRoute(this.routeTo[v], w));
                    int n2 = w;
                    this.nPathsTo[n2] = this.nPathsTo[n2] + this.nPathsTo[v];
                    continue;
                }
                this.precedes[w] = true;
                this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
            }
        }
    }

    public int[] pathTo(int end) {
        if (end < 0 || end >= this.routeTo.length) {
            return EMPTY_PATH;
        }
        return this.routeTo[end] != null ? this.routeTo[end].toPath(this.distTo[end] + 1) : EMPTY_PATH;
    }

    public int[] pathTo(IAtom end) {
        return this.pathTo(this.container.indexOf(end));
    }

    public boolean isPrecedingPathTo(int end) {
        return end >= 0 && end < this.routeTo.length && this.precedes[end];
    }

    public int[][] pathsTo(int end) {
        if (end < 0 || end >= this.routeTo.length) {
            return EMPTY_PATHS;
        }
        return this.routeTo[end] != null ? this.routeTo[end].toPaths(this.distTo[end] + 1) : EMPTY_PATHS;
    }

    public int[][] pathsTo(IAtom end) {
        return this.pathsTo(this.container.indexOf(end));
    }

    public IAtom[] atomsTo(int end) {
        int[] path = this.pathTo(end);
        IAtom[] atoms = new IAtom[path.length];
        int n = path.length;
        for (int i = 0; i < n; ++i) {
            atoms[i] = this.container.getAtom(path[i]);
        }
        return atoms;
    }

    public IAtom[] atomsTo(IAtom end) {
        return this.atomsTo(this.container.indexOf(end));
    }

    public int nPathsTo(int end) {
        return end < 0 || end >= this.nPathsTo.length ? 0 : this.nPathsTo[end];
    }

    public int nPathsTo(IAtom end) {
        return this.nPathsTo(this.container.indexOf(end));
    }

    public int distanceTo(int end) {
        return end < 0 || end >= this.nPathsTo.length ? Integer.MAX_VALUE : this.distTo[end];
    }

    public int distanceTo(IAtom end) {
        return this.distanceTo(this.container.indexOf(end));
    }

    private static interface Route {
        public int[][] toPaths(int var1);

        public int[] toPath(int var1);
    }

    private static class Source
    implements Route {
        private final int v;

        public Source(int v) {
            this.v = v;
        }

        @Override
        public int[][] toPaths(int n) {
            return new int[][]{this.toPath(n)};
        }

        @Override
        public int[] toPath(int n) {
            int[] path = new int[n];
            path[0] = this.v;
            return path;
        }
    }

    private class SequentialRoute
    implements Route {
        private final int v;
        private final Route parent;

        private SequentialRoute(Route parent, int v) {
            this.v = v;
            this.parent = parent;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] paths = this.parent.toPaths(n);
            int i = ShortestPaths.this.distTo[this.v];
            for (int[] path : paths) {
                path[i] = this.v;
            }
            return paths;
        }

        @Override
        public int[] toPath(int n) {
            int[] path = this.parent.toPath(n);
            path[((ShortestPaths)ShortestPaths.this).distTo[this.v]] = this.v;
            return path;
        }
    }

    private class Branch
    implements Route {
        private final Route left;
        private final Route right;

        private Branch(Route left, Route right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] leftPaths = this.left.toPaths(n);
            int[][] rightPaths = this.right.toPaths(n);
            int[][] paths = (int[][])Arrays.copyOf(leftPaths, leftPaths.length + rightPaths.length);
            System.arraycopy(rightPaths, 0, paths, leftPaths.length, rightPaths.length);
            return paths;
        }

        @Override
        public int[] toPath(int n) {
            return this.left.toPath(n);
        }
    }
}

