/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import org.openscience.cdk.graph.invariant.InvariantRanker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public final class Canon {
    private static final int N_PRIMES = 10000;
    private final int[][] g;
    private final long[] labelling;
    private final long[] symmetry;
    private boolean symOnly;
    private static final int[] PRIMES = Canon.loadPrimes();

    private Canon(int[][] g, long[] partition, boolean[] hydrogens, boolean symOnly) {
        this.g = g;
        this.symOnly = symOnly;
        this.labelling = (long[])partition.clone();
        this.symmetry = this.refine(this.labelling, hydrogens);
    }

    public static long[] label(IAtomContainer container2, int[][] g, int opts) {
        return Canon.label(container2, g, Canon.basicInvariants(container2, g, opts));
    }

    public static long[] label(IAtomContainer container2, int[][] g) {
        return Canon.label(container2, g, 0);
    }

    public static long[] label(IAtomContainer container2, int[][] g, long[] initial) {
        if (initial.length != g.length) {
            throw new IllegalArgumentException("number of initial != number of atoms");
        }
        return new Canon((int[][])g, (long[])initial, (boolean[])Canon.terminalHydrogens((IAtomContainer)container2, (int[][])g), (boolean)false).labelling;
    }

    public static long[] label(IAtomContainer container2, int[][] g, Comparator<IAtom> cmp) {
        long part;
        if (g.length == 0) {
            return new long[0];
        }
        IAtom[] atoms = AtomContainerManipulator.getAtomArray(container2);
        Arrays.sort(atoms, cmp);
        long[] initial = new long[atoms.length];
        initial[container2.indexOf((IAtom)atoms[0])] = part = 1L;
        for (int i = 1; i < atoms.length; ++i) {
            if (cmp.compare(atoms[i], atoms[i - 1]) != 0) {
                // empty if block
            }
            initial[container2.indexOf((IAtom)atoms[i])] = ++part;
        }
        return Canon.label(container2, g, initial);
    }

    public static long[] symmetry(IAtomContainer container2, int[][] g, int opts) {
        return new Canon((int[][])g, (long[])Canon.basicInvariants((IAtomContainer)container2, (int[][])g, (int)opts), (boolean[])Canon.terminalHydrogens((IAtomContainer)container2, (int[][])g), (boolean)true).symmetry;
    }

    public static long[] symmetry(IAtomContainer container2, int[][] g) {
        return Canon.symmetry(container2, g, 0);
    }

    private long[] refine(long[] invariants, boolean[] hydrogens) {
        int ord = this.g.length;
        InvariantRanker ranker = new InvariantRanker(ord);
        int[] currVs = new int[ord];
        int[] nextVs = new int[ord];
        int nnu = ord;
        for (int i = 0; i < ord; ++i) {
            currVs[i] = i;
        }
        long[] prev = invariants;
        long[] curr = Arrays.copyOf(invariants, ord);
        Arrays.fill(prev, 1L);
        int n = 0;
        int m = 0;
        long[] symmetry = null;
        while (n < ord) {
            int i;
            while ((n = ranker.rank(currVs, nextVs, nnu, curr, prev)) > m && n < ord) {
                nnu = 0;
                for (i = 0; i < ord && nextVs[i] >= 0; ++i) {
                    int v = nextVs[i];
                    currVs[nnu++] = v;
                    curr[v] = hydrogens[v] ? prev[v] : this.primeProduct(this.g[v], prev, hydrogens);
                }
                m = n;
            }
            if (symmetry == null) {
                for (i = 0; i < this.g.length; ++i) {
                    if (!hydrogens[i]) continue;
                    curr[i] = prev[this.g[i][0]];
                    hydrogens[i] = false;
                }
                n = ranker.rank(currVs, nextVs, nnu, curr, prev);
                symmetry = Arrays.copyOf(prev, ord);
                nnu = 0;
                for (i = 0; i < ord && nextVs[i] >= 0; ++i) {
                    currVs[nnu++] = nextVs[i];
                }
            }
            if (this.symOnly || n == ord) {
                return symmetry;
            }
            int lo = nextVs[0];
            for (int i2 = 1; i2 < ord && nextVs[i2] >= 0 && prev[nextVs[i2]] == prev[lo]; ++i2) {
                int n2 = nextVs[i2];
                prev[n2] = prev[n2] + 1L;
            }
            System.arraycopy(nextVs, 0, currVs, 0, nnu);
        }
        if (symmetry == null) {
            symmetry = new long[]{};
        }
        return symmetry;
    }

    private long primeProduct(int[] ws, long[] ranks, boolean[] hydrogens) {
        long prod = 1L;
        for (int w : ws) {
            if (hydrogens[w]) continue;
            prod *= (long)PRIMES[(int)ranks[w]];
        }
        return prod;
    }

    public static long[] basicInvariants(IAtomContainer container2, int[][] graph) {
        return Canon.basicInvariants(container2, graph, 0);
    }

    public static long[] basicInvariants(IAtomContainer container2, int[][] graph, int flav) {
        long[] labels = new long[graph.length];
        for (int v = 0; v < graph.length; ++v) {
            IAtom atom = container2.getAtom(v);
            int deg = graph[v].length;
            int impH = Canon.implH(atom);
            int expH = 0;
            int elem = Canon.atomicNumber(atom);
            int chg = Canon.charge(atom);
            for (int w : graph[v]) {
                if (Canon.atomicNumber(container2.getAtom(w)) != 1) continue;
                ++expH;
            }
            long label = 0L;
            label |= (long)(deg + impH & 0xF);
            label <<= 4;
            label |= (long)(deg - expH & 0xF);
            label <<= 7;
            label |= (long)(elem & 0x7F);
            label <<= 1;
            label |= (long)(chg >> 31 & 1);
            label <<= 2;
            label |= (long)(Math.abs(chg) & 3);
            label <<= 4;
            label |= (long)(impH + expH & 0xF);
            if ((flav & 8) != 0 && atom.getMassNumber() != null) {
                label <<= 10;
                label |= (long)atom.getMassNumber().intValue();
            }
            labels[v] = label;
        }
        return labels;
    }

    private static int atomicNumber(IAtom atom) {
        Integer elem = atom.getAtomicNumber();
        if (elem != null) {
            return elem;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-pseudoatom had unset atomic number");
    }

    private static int implH(IAtom atom) {
        Integer h = atom.getImplicitHydrogenCount();
        if (h != null) {
            return h;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-pseudoatom had unset hydrogen count");
    }

    private static int charge(IAtom atom) {
        Integer charge = atom.getFormalCharge();
        if (charge != null) {
            return charge;
        }
        return 0;
    }

    static boolean[] terminalHydrogens(IAtomContainer ac, int[][] g) {
        boolean[] hydrogens = new boolean[ac.getAtomCount()];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            IAtom atom = ac.getAtom(i);
            hydrogens[i] = atom.getAtomicNumber() == 1 && atom.getMassNumber() == null && g[i].length == 1;
        }
        return hydrogens;
    }

    private static int[] loadPrimes() {
        int[] nArray;
        BufferedReader br = new BufferedReader(new InputStreamReader(Canon.class.getResourceAsStream("primes.dat")));
        try {
            String line;
            int[] primes = new int[10000];
            int i = 0;
            while ((line = br.readLine()) != null) {
                primes[i++] = Integer.parseInt(line);
            }
            assert (i == 10000);
            nArray = primes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NumberFormatException e2) {
                System.err.println("Critical - could not load primes table for canonical labelling!");
                return new int[0];
            }
        }
        br.close();
        return nArray;
    }
}

