/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.Arrays;
import java.util.Objects;
import org.openscience.cdk.graph.invariant.exception.BadMatrixFormatException;
import org.openscience.cdk.graph.invariant.exception.IndexOutOfBoundsException;
import org.openscience.cdk.graph.invariant.exception.MatrixNotInvertibleException;

public class GIMatrix {
    private double[][] array;
    private int m;
    private int n;

    public GIMatrix(int[][] array) {
        double[][] temp = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            temp[i] = new double[array[i].length];
            for (int j = 0; j < array[i].length; ++j) {
                temp[i][j] = array[i][j];
            }
        }
        this.array = temp;
        this.m = temp.length;
        this.n = temp[0].length;
    }

    public GIMatrix(double[][] array) throws BadMatrixFormatException {
        this.verifyMatrixFormat(array);
        double[][] temp = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            temp[i] = new double[array[i].length];
            for (int j = 0; j < array[i].length; ++j) {
                temp[i][j] = array[i][j];
            }
        }
        this.array = temp;
        this.m = array.length;
        this.n = array[0].length;
    }

    public GIMatrix(int line, int col) {
        this.array = new double[line][col];
        for (int i = 0; i < line; ++i) {
            for (int j = 0; j < col; ++j) {
                this.array[i][j] = 0.0;
            }
        }
        this.m = line;
        this.n = col;
    }

    public GIMatrix(GIMatrix matrix) {
        double[][] temp = new double[matrix.height()][];
        for (int i = 0; i < matrix.height(); ++i) {
            temp[i] = new double[matrix.width()];
            for (int j = 0; j < matrix.width(); ++j) {
                try {
                    temp[i][j] = matrix.getValueAt(i, j);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        this.array = temp;
        this.m = this.array.length;
        this.n = this.array[0].length;
    }

    public GIMatrix(GIMatrix[][] table) throws BadMatrixFormatException {
        this.verifyTableFormat(table);
        this.n = 0;
        this.m = 0;
        for (GIMatrix[] giMatrices : table) {
            this.m += giMatrices[0].height();
        }
        for (int j = 0; j < table[0].length; ++j) {
            this.n += table[0][j].width();
        }
        double[][] temp = new double[this.m][this.n];
        int k = 0;
        for (int i = 0; i < this.m; ++i) {
            temp[i] = new double[this.n];
            if (i == table[k][0].height()) {
                ++k;
            }
            int h = 0;
            for (int j = 0; j < this.n; ++j) {
                if (j == table[k][h].width()) {
                    ++h;
                }
                try {
                    GIMatrix tempMatrix = table[k][h];
                    temp[i][j] = tempMatrix.getValueAt(i - k * tempMatrix.height(), j - h * tempMatrix.width());
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        this.array = temp;
    }

    public int height() {
        return this.m;
    }

    public int width() {
        return this.n;
    }

    public double[][] getArrayValue() {
        return this.array;
    }

    public void setArrayValue(double[][] array) throws BadMatrixFormatException {
        this.verifyMatrixFormat(array);
        this.array = array;
    }

    public double getValueAt(int i, int j) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m || j < 0 || j >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[i][j];
    }

    public void setValueAt(int i, int j, double element) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m || j < 0 || j >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.array[i][j] = element;
    }

    public GIMatrix getLine(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m) {
            throw new IndexOutOfBoundsException();
        }
        double[][] line = new double[1][this.n];
        for (int k = 0; k < this.n; ++k) {
            line[0][k] = this.array[i][k];
        }
        try {
            return new GIMatrix(line);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public GIMatrix getColumn(int j) throws IndexOutOfBoundsException {
        if (j < 0 || j >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        double[][] column = new double[this.m][1];
        for (int k = 0; k < this.m; ++k) {
            column[k][0] = this.array[k][j];
        }
        try {
            return new GIMatrix(column);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public void setLine(int i, GIMatrix line) throws IndexOutOfBoundsException, BadMatrixFormatException {
        if (i < 0 || i >= this.m) {
            throw new IndexOutOfBoundsException();
        }
        if (line.height() != 1 || line.width() != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int k = 0; k < this.n; ++k) {
            this.array[i][k] = line.getValueAt(0, k);
        }
    }

    public void setColumn(int j, GIMatrix column) throws IndexOutOfBoundsException, BadMatrixFormatException {
        if (j < 0 || j >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        if (column.height() != this.m || column.width() != 1) {
            throw new BadMatrixFormatException();
        }
        for (int k = 0; k < this.m; ++k) {
            this.array[k][j] = column.getValueAt(k, 0);
        }
    }

    public static GIMatrix identity(int n) {
        double[][] identity = new double[n][n];
        for (int i = 0; i < n; ++i) {
            int j;
            for (j = 0; j < i; ++j) {
                identity[i][j] = 0.0;
            }
            identity[i][i] = 1.0;
            for (j = i + 1; j < n; ++j) {
                identity[i][j] = 0.0;
            }
        }
        try {
            return new GIMatrix(identity);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public static GIMatrix zero(int m, int n) {
        double[][] zero = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                zero[i][j] = 0.0;
            }
        }
        try {
            return new GIMatrix(zero);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GIMatrix)) {
            return false;
        }
        GIMatrix matrix = (GIMatrix)obj;
        if (this.height() != matrix.height() || this.width() != matrix.width()) {
            throw new RuntimeException(new BadMatrixFormatException());
        }
        double[][] temp = matrix.getArrayValue();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.array[i][j] == temp[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.m, this.n);
        result = 31 * result + Arrays.hashCode((Object[])this.array);
        return result;
    }

    public boolean isSquare() {
        return this.m == this.n;
    }

    public boolean isSymmetric() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int i = 1; i < this.m; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.array[i][j] == this.array[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAntisymmetric() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j <= i; ++j) {
                if (this.array[i][j] == -this.array[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTriangularSuperior() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int i = 1; i < this.m; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.array[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTriangularInferior() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int i = 1; i < this.m; ++i) {
            for (int j = i; j < this.n; ++j) {
                if (this.array[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonal() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        for (int i = 1; i < this.m; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.array[i][j] == 0.0 && this.array[j][i] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isInvertible() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        return this.determinant() != 0.0;
    }

    public GIMatrix inverse() throws MatrixNotInvertibleException {
        GIMatrix table;
        try {
            if (!this.isInvertible()) {
                throw new MatrixNotInvertibleException();
            }
        }
        catch (BadMatrixFormatException e2) {
            throw new MatrixNotInvertibleException();
        }
        GIMatrix I = GIMatrix.identity(this.n);
        try {
            GIMatrix[][] temp = new GIMatrix[][]{{this, I}};
            table = new GIMatrix(temp);
        }
        catch (BadMatrixFormatException e3) {
            return null;
        }
        table = table.GaussJordan();
        double[][] inv = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = this.n; j < 2 * this.n; ++j) {
                try {
                    inv[i][j - this.n] = table.getValueAt(i, j);
                    continue;
                }
                catch (IndexOutOfBoundsException e4) {
                    return null;
                }
            }
        }
        try {
            return new GIMatrix(inv);
        }
        catch (BadMatrixFormatException e5) {
            return null;
        }
    }

    public GIMatrix GaussJordan() {
        GIMatrix tempMatrix = new GIMatrix(this);
        try {
            int j = 0;
            int k = 0;
            boolean end = false;
            for (int i = 0; i < this.m && !end; ++i) {
                boolean allZero = true;
                while (j < this.n) {
                    for (k = i; k < this.m; ++k) {
                        if (tempMatrix.getValueAt(k, j) == 0.0) continue;
                        allZero = false;
                        break;
                    }
                    if (!allZero) break;
                    ++j;
                }
                if (j == this.n) {
                    end = true;
                    continue;
                }
                if (k != i) {
                    tempMatrix = tempMatrix.invertLine(i, k);
                }
                if (tempMatrix.getValueAt(i, j) != 1.0) {
                    tempMatrix = tempMatrix.multiplyLine(i, 1.0 / tempMatrix.getValueAt(i, j));
                }
                for (int q = 0; q < this.m; ++q) {
                    if (q == i) continue;
                    tempMatrix = tempMatrix.addLine(q, i, -tempMatrix.getValueAt(q, j));
                }
            }
            return tempMatrix;
        }
        catch (IndexOutOfBoundsException e2) {
            return null;
        }
    }

    public GIMatrix transpose() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        double[][] transpose = new double[this.array.length][this.array[0].length];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                transpose[i][j] = this.array[j][i];
            }
        }
        return new GIMatrix(transpose);
    }

    public GIMatrix diagonal() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        double[][] diagonal = new double[this.array.length][this.array[0].length];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                diagonal[i][j] = i == j ? this.array[i][j] : 0.0;
            }
        }
        return new GIMatrix(diagonal);
    }

    public GIMatrix multiplyLine(int i, double c) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m) {
            throw new IndexOutOfBoundsException();
        }
        double[][] temp = this.array;
        for (int k = 0; k < this.n; ++k) {
            temp[i][k] = c * temp[i][k];
        }
        try {
            return new GIMatrix(temp);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public GIMatrix invertLine(int i, int j) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m || j < 0 || j >= this.m) {
            throw new IndexOutOfBoundsException();
        }
        double[][] temp = this.array;
        double[] tempLine = temp[j];
        temp[j] = temp[i];
        temp[i] = tempLine;
        try {
            return new GIMatrix(temp);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public GIMatrix addLine(int i, int j, double c) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.m || j < 0 || j >= this.m) {
            throw new IndexOutOfBoundsException();
        }
        double[][] temp = this.array;
        for (int k = 0; k < this.n; ++k) {
            temp[i][k] = temp[i][k] + c * temp[j][k];
        }
        try {
            return new GIMatrix(temp);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public GIMatrix add(GIMatrix b) {
        if (b == null || this.m != b.m || this.n != b.n) {
            return null;
        }
        GIMatrix result = new GIMatrix(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                result.array[i][j] = this.array[i][j] + b.array[i][j];
            }
        }
        return result;
    }

    public GIMatrix multiply(double c) {
        double[][] temp = this.array;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                temp[i][j] = c * temp[i][j];
            }
        }
        try {
            return new GIMatrix(temp);
        }
        catch (BadMatrixFormatException e2) {
            return null;
        }
    }

    public GIMatrix multiply(GIMatrix matrix) throws BadMatrixFormatException {
        if (this.n != matrix.height()) {
            throw new BadMatrixFormatException();
        }
        int p = matrix.width();
        double[][] temp = new double[this.m][p];
        double[][] multiplied = matrix.getArrayValue();
        for (int i = 0; i < this.m; ++i) {
            for (int k = 0; k < p; ++k) {
                temp[i][k] = this.array[i][0] * multiplied[0][k];
                for (int j = 1; j < this.n; ++j) {
                    temp[i][k] = temp[i][k] + this.array[i][j] * multiplied[j][k];
                }
            }
        }
        return new GIMatrix(temp);
    }

    public double determinant() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        return this.det(this.array);
    }

    private double det(double[][] mat) {
        if (mat.length == 1) {
            return mat[0][0];
        }
        double temp = mat[0][0] * this.det(this.M(mat, 0, 0));
        for (int k = 1; k < mat.length; ++k) {
            temp += this.det(this.M(mat, 0, k)) * (k % 2 == 0 ? mat[0][k] : -mat[0][k]);
        }
        return temp;
    }

    private double[][] M(double[][] mat, int i, int j) {
        int h;
        int k;
        double[][] temp = new double[mat.length - 1][mat[0].length - 1];
        for (k = 0; k < i; ++k) {
            for (h = 0; h < j; ++h) {
                temp[k][h] = mat[k][h];
            }
            for (h = j + 1; h < mat[0].length; ++h) {
                temp[k][h - 1] = mat[k][h];
            }
        }
        for (k = i + 1; k < mat.length; ++k) {
            for (h = 0; h < j; ++h) {
                temp[k - 1][h] = mat[k][h];
            }
            for (h = j + 1; h < mat[0].length; ++h) {
                temp[k - 1][h - 1] = mat[k][h];
            }
        }
        return temp;
    }

    public double trace() throws BadMatrixFormatException {
        if (this.m != this.n) {
            throw new BadMatrixFormatException();
        }
        double trace = this.array[0][0];
        for (int i = 1; i < this.m; ++i) {
            trace += this.array[i][i];
        }
        return trace;
    }

    private void verifyMatrixFormat(double[][] testedMatrix) throws BadMatrixFormatException {
        if (testedMatrix.length == 0 || testedMatrix[0].length == 0) {
            throw new BadMatrixFormatException();
        }
        int noOfColumns = testedMatrix[0].length;
        for (int i = 1; i < testedMatrix.length; ++i) {
            if (testedMatrix[i].length == noOfColumns) continue;
            throw new BadMatrixFormatException();
        }
    }

    private void verifyTableFormat(GIMatrix[][] testedTable) throws BadMatrixFormatException {
        if (testedTable.length == 0 || testedTable[0].length == 0) {
            throw new BadMatrixFormatException();
        }
        int noOfColumns = testedTable[0].length;
        for (GIMatrix[] giMatrices : testedTable) {
            if (giMatrices.length != noOfColumns) {
                throw new BadMatrixFormatException();
            }
            int currentHeigth = giMatrices[0].height();
            for (int j = 1; j < testedTable[0].length; ++j) {
                if (giMatrices[j].height() == currentHeigth) continue;
                throw new BadMatrixFormatException();
            }
        }
        for (int j = 0; j < testedTable[0].length; ++j) {
            int currentWidth = testedTable[0][j].width();
            for (int i = 1; i < testedTable.length; ++i) {
                if (testedTable[i][j].width() == currentWidth) continue;
                throw new BadMatrixFormatException();
            }
        }
    }
}

