/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiStatus;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class InChINumbersTools {
    public static long[] getNumbers(IAtomContainer atomContainer) throws CDKException {
        String aux = InChINumbersTools.auxInfo(atomContainer, new InchiFlag[0]);
        long[] numbers = new long[atomContainer.getAtomCount()];
        InChINumbersTools.parseAuxInfo(aux, numbers);
        return numbers;
    }

    public static void parseAuxInfo(String aux, long[] numbers) {
        aux = aux.substring(aux.indexOf("/N:") + 3);
        String numberStringAux = aux.substring(0, aux.indexOf(47));
        int i = 1;
        for (String numberString : numberStringAux.split("[,;]")) {
            numbers[Integer.parseInt((String)numberString) - 1] = i++;
        }
    }

    public static long[] getUSmilesNumbers(IAtomContainer container2) throws CDKException {
        String aux = InChINumbersTools.auxInfo(container2, InchiFlag.RecMet, InchiFlag.FixedH);
        return InChINumbersTools.parseUSmilesNumbers(aux, container2);
    }

    static long[] parseUSmilesNumbers(String aux, IAtomContainer container2) {
        int[] first;
        long[] numbers = new long[container2.getAtomCount()];
        int label = 1;
        int index = aux.indexOf("/R:");
        if (index >= 0) {
            int endIndex = aux.indexOf(47, index + 8);
            if (endIndex < 0) {
                endIndex = aux.length();
            }
            String[] baseNumbers = aux.substring(index + 8, endIndex).split(";");
            first = new int[baseNumbers.length];
            Arrays.fill(first, -1);
            for (int i = 0; i < baseNumbers.length; ++i) {
                String[] numbering = baseNumbers[i].split(",");
                first[i] = Integer.parseInt(numbering[0]) - 1;
                for (String number : numbering) {
                    numbers[Integer.parseInt((String)number) - 1] = label++;
                }
            }
        } else {
            index = aux.indexOf("/N:");
            if (index >= 0) {
                String[] baseNumbers = aux.substring(index + 3, aux.indexOf(47, index + 3)).split(";");
                first = new int[baseNumbers.length];
                Arrays.fill(first, -1);
                index = aux.indexOf("/F:");
                if (index >= 0) {
                    String[] fixedHNumbers = aux.substring(index + 3, aux.indexOf(47, index + 3)).split(";");
                    for (int i = 0; i < fixedHNumbers.length; ++i) {
                        String[] numbering;
                        String component = fixedHNumbers[i];
                        if (component.charAt(component.length() - 1) == 'm') {
                            int n = component.length() > 1 ? Integer.parseInt(component.substring(0, component.length() - 1)) : 1;
                            for (int j = 0; j < n; ++j) {
                                String[] numbering2 = baseNumbers[i + j].split(",");
                                first[i + j] = Integer.parseInt(numbering2[0]) - 1;
                                for (String number : numbering2) {
                                    numbers[Integer.parseInt((String)number) - 1] = label++;
                                }
                            }
                            continue;
                        }
                        for (String number : numbering = component.split(",")) {
                            numbers[Integer.parseInt((String)number) - 1] = label++;
                        }
                    }
                } else {
                    for (int i = 0; i < baseNumbers.length; ++i) {
                        String[] numbering = baseNumbers[i].split(",");
                        first[i] = Integer.parseInt(numbering[0]) - 1;
                        for (String number : numbering) {
                            numbers[Integer.parseInt((String)number) - 1] = label++;
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("AuxInfo did not contain extractable base numbers (/N: or /R:).");
            }
        }
        for (int v : first) {
            IAtom correctedStart;
            List<IAtom> neighbors;
            IAtom atom;
            if (v < 0 || (atom = container2.getAtom(v)).getFormalCharge() == null || atom.getAtomicNumber() != 8 || atom.getFormalCharge() != -1 || (neighbors = container2.getConnectedAtomsList(atom)).size() != 1 || (correctedStart = InChINumbersTools.findPiBondedOxygen(container2, neighbors.get(0))) == null) continue;
            InChINumbersTools.exch(numbers, v, container2.indexOf(correctedStart));
        }
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] != 0L) continue;
            numbers[i] = label++;
        }
        return numbers;
    }

    private static void exch(long[] values, int i, int j) {
        long k = values[i];
        values[i] = values[j];
        values[j] = k;
    }

    private static IAtom findPiBondedOxygen(IAtomContainer container2, IAtom atom) {
        for (IBond bond : container2.getConnectedBondsList(atom)) {
            int charge;
            if (bond.getOrder() != IBond.Order.DOUBLE) continue;
            IAtom neighbor = bond.getOther(atom);
            int n = charge = neighbor.getFormalCharge() == null ? 0 : neighbor.getFormalCharge();
            if (neighbor.getAtomicNumber() != 8 || charge != 0) continue;
            return neighbor;
        }
        return null;
    }

    static String auxInfo(IAtomContainer container2, InchiFlag ... flags) throws CDKException {
        InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
        boolean org = factory.getIgnoreAromaticBonds();
        factory.setIgnoreAromaticBonds(true);
        InChIGenerator gen = factory.getInChIGenerator(container2, flags);
        factory.setIgnoreAromaticBonds(org);
        if (gen.getStatus() == InchiStatus.ERROR) {
            throw new CDKException("Could not generate InChI Numbers: " + gen.getMessage());
        }
        return gen.getAuxInfo();
    }
}

