/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiKeyOutput;
import io.github.dan2097.jnainchi.InchiKeyStatus;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiOutput;
import io.github.dan2097.jnainchi.InchiRadical;
import io.github.dan2097.jnainchi.InchiStatus;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.JnaInchi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIOptionParser;
import org.openscience.cdk.inchi.JniInchiSupport;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class InChIGenerator {
    private static final InchiOptions DEFAULT_OPTIONS = new InchiOptions.InchiOptionsBuilder().withFlag(InchiFlag.AuxNone).withTimeoutMilliSeconds(5000L).build();
    protected InchiOptions options;
    protected final InchiInput input = new InchiInput();
    protected InchiOutput output;
    private final boolean auxNone;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(InChIGenerator.class);
    protected IAtomContainer atomContainer;

    protected InChIGenerator(IAtomContainer atomContainer, InchiOptions options, boolean ignoreAromaticBonds) throws CDKException {
        this.options = options;
        if (options == null) {
            this.options = DEFAULT_OPTIONS;
        }
        this.generateInchiFromCDKAtomContainer(atomContainer, ignoreAromaticBonds);
        this.auxNone = this.options.getFlags().contains((Object)InchiFlag.AuxNone);
    }

    protected InChIGenerator(IAtomContainer atomContainer, boolean ignoreAromaticBonds) throws CDKException {
        this(atomContainer, DEFAULT_OPTIONS, ignoreAromaticBonds);
    }

    protected InChIGenerator(IAtomContainer atomContainer, String optStr, boolean ignoreAromaticBonds) throws CDKException {
        this(atomContainer, InChIOptionParser.parseString(optStr), ignoreAromaticBonds);
    }

    private static InchiOptions convertJniToJnaOpts(List<INCHI_OPTION> jniOpts) {
        InchiOptions.InchiOptionsBuilder builder = new InchiOptions.InchiOptionsBuilder();
        for (INCHI_OPTION jniOpt : jniOpts) {
            InchiFlag flag = JniInchiSupport.toJnaOption(jniOpt);
            if (flag == null) continue;
            builder.withFlag(flag);
        }
        return builder.build();
    }

    @Deprecated
    protected InChIGenerator(IAtomContainer atomContainer, List<INCHI_OPTION> opts, boolean ignoreAromaticBonds) throws CDKException {
        this(atomContainer, InChIGenerator.convertJniToJnaOpts(opts), ignoreAromaticBonds);
    }

    private void generateInchiFromCDKAtomContainer(IAtomContainer atomContainer, boolean ignore) throws CDKException {
        this.atomContainer = atomContainer;
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        boolean all3d = true;
        boolean all2d = true;
        while (atoms.hasNext()) {
            IAtom atom = atoms.next();
            if (atom.getPoint3d() == null) {
                all3d = false;
            }
            if (atom.getPoint2d() != null) continue;
            all2d = false;
        }
        HashMap<IAtom, InchiAtom> atomMap = new HashMap<IAtom, InchiAtom>();
        for (IAtom atom : atomContainer.atoms()) {
            Integer implicitH;
            Integer isotopeNumber;
            double z;
            double y;
            double x;
            Cloneable p;
            if (all3d) {
                p = atom.getPoint3d();
                x = p.x;
                y = p.y;
                z = p.z;
            } else if (all2d) {
                p = atom.getPoint2d();
                x = ((Point2d)p).x;
                y = ((Point2d)p).y;
                z = 0.0;
            } else {
                x = 0.0;
                y = 0.0;
                z = 0.0;
            }
            String el = atom.getSymbol();
            InchiAtom iatom = new InchiAtom(el, x, y, z);
            this.input.addAtom(iatom);
            atomMap.put(atom, iatom);
            int charge = atom.getFormalCharge();
            if (charge != 0) {
                iatom.setCharge(charge);
            }
            if ((isotopeNumber = atom.getMassNumber()) != null) {
                iatom.setIsotopicMass(isotopeNumber);
            }
            iatom.setImplicitHydrogen((implicitH = atom.getImplicitHydrogenCount()) != null ? implicitH : -1);
            int count = atomContainer.getConnectedSingleElectronsCount(atom);
            if (count == 1) {
                iatom.setRadical(InchiRadical.DOUBLET);
                continue;
            }
            if (count == 2) {
                Enum spin = (Enum)atom.getProperty("cdk:SpinMultiplicity");
                if (spin != null) {
                    if (spin.name().equals("DivalentSinglet")) {
                        iatom.setRadical(InchiRadical.SINGLET);
                        continue;
                    }
                    iatom.setRadical(InchiRadical.TRIPLET);
                    continue;
                }
                iatom.setRadical(InchiRadical.TRIPLET);
                continue;
            }
            if (count == 0) continue;
            throw new CDKException("Unrecognised radical type");
        }
        for (IBond bond : atomContainer.bonds()) {
            InchiBondStereo iDisplay;
            InchiBondType order;
            InchiAtom at0 = (InchiAtom)atomMap.get(bond.getBegin());
            InchiAtom at1 = (InchiAtom)atomMap.get(bond.getEnd());
            IBond.Order bo = bond.getOrder();
            if (!ignore && bond.isAromatic()) {
                order = InchiBondType.ALTERN;
            } else if (bo == IBond.Order.SINGLE) {
                order = InchiBondType.SINGLE;
            } else if (bo == IBond.Order.DOUBLE) {
                order = InchiBondType.DOUBLE;
            } else if (bo == IBond.Order.TRIPLE) {
                order = InchiBondType.TRIPLE;
            } else {
                throw new CDKException("Failed to generate InChI: Unsupported bond type");
            }
            IBond.Stereo display = bond.getStereo();
            switch (display) {
                case UP: {
                    iDisplay = InchiBondStereo.SINGLE_1UP;
                    break;
                }
                case UP_INVERTED: {
                    iDisplay = InchiBondStereo.SINGLE_2UP;
                    break;
                }
                case DOWN: {
                    iDisplay = InchiBondStereo.SINGLE_1DOWN;
                    break;
                }
                case DOWN_INVERTED: {
                    iDisplay = InchiBondStereo.SINGLE_2DOWN;
                    break;
                }
                case UP_OR_DOWN: {
                    iDisplay = InchiBondStereo.SINGLE_1EITHER;
                    break;
                }
                case UP_OR_DOWN_INVERTED: {
                    iDisplay = InchiBondStereo.SINGLE_2EITHER;
                    break;
                }
                case E_OR_Z: {
                    iDisplay = InchiBondStereo.DOUBLE_EITHER;
                    break;
                }
                default: {
                    iDisplay = InchiBondStereo.NONE;
                }
            }
            InchiBond ibond = new InchiBond(at0, at1, order, iDisplay);
            this.input.addBond(ibond);
        }
        for (IStereoElement stereoElem : atomContainer.stereoElements()) {
            InchiStereoParity parity;
            IAtom replace;
            InchiStereoParity p;
            InchiAtom at3;
            InchiAtom at2;
            InchiAtom at1;
            InchiAtom at0;
            Enum stereoType;
            if (stereoElem instanceof ITetrahedralChirality) {
                ITetrahedralChirality chirality = (ITetrahedralChirality)stereoElem;
                IAtom[] surroundingAtoms = chirality.getLigands();
                stereoType = chirality.getStereo();
                InchiAtom atC = (InchiAtom)atomMap.get(chirality.getChiralAtom());
                at0 = (InchiAtom)atomMap.get(surroundingAtoms[0]);
                at1 = (InchiAtom)atomMap.get(surroundingAtoms[1]);
                at2 = (InchiAtom)atomMap.get(surroundingAtoms[2]);
                at3 = (InchiAtom)atomMap.get(surroundingAtoms[3]);
                if (stereoType == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
                    p = InchiStereoParity.ODD;
                } else if (stereoType == ITetrahedralChirality.Stereo.CLOCKWISE) {
                    p = InchiStereoParity.EVEN;
                } else {
                    throw new CDKException("Unknown tetrahedral chirality");
                }
                InchiStereo jniStereo = InchiStereo.createTetrahedralStereo(atC, at0, at1, at2, at3, p);
                this.input.addStereo(jniStereo);
                continue;
            }
            if (stereoElem instanceof IDoubleBondStereochemistry) {
                IDoubleBondStereochemistry dbStereo = (IDoubleBondStereochemistry)stereoElem;
                IBond[] surroundingBonds = dbStereo.getBonds();
                if (surroundingBonds[0] == null || surroundingBonds[1] == null) {
                    throw new CDKException("Cannot generate an InChI with incomplete double bond info");
                }
                stereoType = dbStereo.getStereo();
                IBond stereoBond = dbStereo.getStereoBond();
                if (stereoBond.contains(surroundingBonds[0].getBegin())) {
                    at1 = (InchiAtom)atomMap.get(surroundingBonds[0].getBegin());
                    at0 = (InchiAtom)atomMap.get(surroundingBonds[0].getEnd());
                } else {
                    at0 = (InchiAtom)atomMap.get(surroundingBonds[0].getBegin());
                    at1 = (InchiAtom)atomMap.get(surroundingBonds[0].getEnd());
                }
                if (stereoBond.contains(surroundingBonds[1].getBegin())) {
                    at2 = (InchiAtom)atomMap.get(surroundingBonds[1].getBegin());
                    at3 = (InchiAtom)atomMap.get(surroundingBonds[1].getEnd());
                } else {
                    at2 = (InchiAtom)atomMap.get(surroundingBonds[1].getEnd());
                    at3 = (InchiAtom)atomMap.get(surroundingBonds[1].getBegin());
                }
                if (stereoType == IDoubleBondStereochemistry.Conformation.TOGETHER) {
                    p = InchiStereoParity.ODD;
                } else if (stereoType == IDoubleBondStereochemistry.Conformation.OPPOSITE) {
                    p = InchiStereoParity.EVEN;
                } else {
                    throw new CDKException("Unknown double bond stereochemistry");
                }
                this.input.addStereo(InchiStereo.createDoubleBondStereo(at0, at1, at2, at3, p));
                continue;
            }
            if (!(stereoElem instanceof ExtendedTetrahedral)) continue;
            ExtendedTetrahedral extendedTetrahedral = (ExtendedTetrahedral)stereoElem;
            ITetrahedralChirality.Stereo winding = extendedTetrahedral.winding();
            IAtom focus = (IAtom)extendedTetrahedral.getFocus();
            IAtom[] terminals = extendedTetrahedral.findTerminalAtoms(atomContainer);
            Object[] peripherals = extendedTetrahedral.peripherals();
            if (ExtendedTetrahedral.getLength(atomContainer, focus) > 2) continue;
            List<IBond> t0Bonds = InChIGenerator.onlySingleBonded(atomContainer.getConnectedBondsList(terminals[0]));
            List<IBond> t1Bonds = InChIGenerator.onlySingleBonded(atomContainer.getConnectedBondsList(terminals[1]));
            if (t0Bonds.size() == 2) {
                replace = t0Bonds.remove(0).getOther(terminals[0]);
                for (int i = 0; i < peripherals.length; ++i) {
                    if (replace != peripherals[i]) continue;
                    peripherals[i] = terminals[0];
                }
            }
            if (t1Bonds.size() == 2) {
                replace = t1Bonds.remove(0).getOther(terminals[1]);
                for (int i = 0; i < peripherals.length; ++i) {
                    if (replace != peripherals[i]) continue;
                    peripherals[i] = terminals[1];
                }
            }
            IAtom t0Neighbor = t0Bonds.get(0).getOther(terminals[0]);
            IAtom t1Neighbor = t1Bonds.get(0).getOther(terminals[1]);
            for (int i = 0; i < peripherals.length; ++i) {
                if (i != 0 && t0Neighbor.equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 0);
                    winding = winding.invert();
                    continue;
                }
                if (i != 1 && terminals[0].equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 1);
                    winding = winding.invert();
                    continue;
                }
                if (i != 2 && terminals[1].equals(peripherals[i])) {
                    InChIGenerator.swap(peripherals, i, 2);
                    winding = winding.invert();
                    continue;
                }
                if (i == 3 || !t1Neighbor.equals(peripherals[i])) continue;
                InChIGenerator.swap(peripherals, i, 3);
                winding = winding.invert();
            }
            if (winding == ITetrahedralChirality.Stereo.ANTI_CLOCKWISE) {
                parity = InchiStereoParity.ODD;
            } else if (winding == ITetrahedralChirality.Stereo.CLOCKWISE) {
                parity = InchiStereoParity.EVEN;
            } else {
                throw new CDKException("Unknown extended tetrahedral chirality");
            }
            this.input.addStereo(InchiStereo.createAllenalStereo((InchiAtom)atomMap.get(focus), (InchiAtom)atomMap.get(peripherals[0]), (InchiAtom)atomMap.get(peripherals[1]), (InchiAtom)atomMap.get(peripherals[2]), (InchiAtom)atomMap.get(peripherals[3]), parity));
        }
        this.output = JnaInchi.toInchi(this.input, this.options);
    }

    private static List<IBond> onlySingleBonded(List<IBond> bonds) {
        ArrayList<IBond> filtered = new ArrayList<IBond>();
        for (IBond bond : bonds) {
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            filtered.add(bond);
        }
        return filtered;
    }

    private static void swap(Object[] objs, int i, int j) {
        Object tmp = objs[i];
        objs[i] = objs[j];
        objs[j] = tmp;
    }

    @Deprecated
    public INCHI_RET getReturnStatus() {
        return JniInchiSupport.toJniStatus(this.output.getStatus());
    }

    public InchiStatus getStatus() {
        return this.output.getStatus();
    }

    public String getInchi() {
        return this.output.getInchi();
    }

    public String getInchiKey() throws CDKException {
        InchiKeyOutput inchiKeyOutput = JnaInchi.inchiToInchiKey(this.getInchi());
        if (inchiKeyOutput.getStatus() == InchiKeyStatus.OK) {
            return inchiKeyOutput.getInchiKey();
        }
        throw new CDKException("Error while creating InChIKey: " + (Object)((Object)inchiKeyOutput.getStatus()));
    }

    public String getAuxInfo() {
        if (this.auxNone) {
            LOGGER.warn("AuxInfo requested but AuxNone option is set (default).");
        }
        return this.output.getAuxInfo();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }
}

