/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiOptions;
import java.util.List;
import net.sf.jniinchi.INCHI_OPTION;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

public class InChIGeneratorFactory {
    private static InChIGeneratorFactory INSTANCE;
    private boolean ignoreAromaticBonds = true;

    private InChIGeneratorFactory() throws CDKException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InChIGeneratorFactory getInstance() throws CDKException {
        Class<InChIGeneratorFactory> clazz = InChIGeneratorFactory.class;
        synchronized (InChIGeneratorFactory.class) {
            if (INSTANCE == null) {
                INSTANCE = new InChIGeneratorFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Deprecated
    public void setIgnoreAromaticBonds(boolean ignore) {
        this.ignoreAromaticBonds = ignore;
    }

    @Deprecated
    public boolean getIgnoreAromaticBonds() {
        return this.ignoreAromaticBonds;
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container2) throws CDKException {
        return new InChIGenerator(container2, this.ignoreAromaticBonds);
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container2, String options) throws CDKException {
        return new InChIGenerator(container2, options, this.ignoreAromaticBonds);
    }

    @Deprecated
    public InChIGenerator getInChIGenerator(IAtomContainer container2, List<INCHI_OPTION> options) throws CDKException {
        if (options == null) {
            throw new IllegalArgumentException("Null options");
        }
        return new InChIGenerator(container2, options, this.ignoreAromaticBonds);
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container2, InchiFlag ... flags) throws CDKException {
        if (flags == null) {
            throw new IllegalArgumentException("Null flags");
        }
        InchiOptions options = new InchiOptions.InchiOptionsBuilder().withFlag(flags).build();
        return this.getInChIGenerator(container2, options);
    }

    public InChIGenerator getInChIGenerator(IAtomContainer container2, InchiOptions options) throws CDKException {
        if (options == null) {
            throw new IllegalArgumentException("Null flags");
        }
        return new InChIGenerator(container2, options, this.ignoreAromaticBonds);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        return new InChIToStructure(inchi, builder);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }

    public InChIToStructure getInChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        return new InChIToStructure(inchi, builder, options);
    }
}

