/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.INChIContentProcessorTool;
import org.openscience.cdk.io.formats.INChIPlainTextFormat;
import org.openscience.cdk.io.formats.IResourceFormat;

public class INChIPlainTextReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private final INChIContentProcessorTool inchiTool;

    public INChIPlainTextReader(Reader input) {
        this.init();
        this.setReader(input);
        this.inchiTool = new INChIContentProcessorTool();
    }

    public INChIPlainTextReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public INChIPlainTextReader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return INChIPlainTextFormat.getInstance();
    }

    @Override
    public void setReader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    private void init() {
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IChemFile.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile cf) throws CDKException {
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                if (!line.startsWith("INChI=") && !line.startsWith("InChI=")) continue;
                cf = cf.getBuilder().newInstance(IChemFile.class, new Object[0]);
                String INChI = line.substring(6);
                StringTokenizer tokenizer = new StringTokenizer(INChI, "/");
                tokenizer.nextToken();
                String formula = tokenizer.nextToken();
                String connections = null;
                if (tokenizer.hasMoreTokens()) {
                    connections = tokenizer.nextToken().substring(1);
                }
                IAtomContainer parsedContent = this.inchiTool.processFormula(cf.getBuilder().newInstance(IAtomContainer.class, new Object[0]), formula);
                if (connections != null) {
                    this.inchiTool.processConnections(connections, parsedContent, -1);
                }
                IAtomContainerSet moleculeSet = cf.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                moleculeSet.addAtomContainer(cf.getBuilder().newInstance(IAtomContainer.class, parsedContent));
                IChemModel model = cf.getBuilder().newInstance(IChemModel.class, new Object[0]);
                model.setMoleculeSet(moleculeSet);
                IChemSequence sequence = cf.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel(model);
                cf.addChemSequence(sequence);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            throw new CDKException("Error while reading INChI file: " + exception.getMessage(), exception);
        }
        return cf;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

