/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class MDLV2000Writer
extends DefaultChemObjectWriter {
    public static final String OptForceWriteAs2DCoordinates = "ForceWriteAs2DCoordinates";
    public static final String OptWriteMajorIsotopes = "WriteMajorIsotopes";
    public static final String OptWriteAromaticBondTypes = "WriteAromaticBondTypes";
    public static final String OptWriteQueryFormatValencies = "WriteQueryFormatValencies";
    public static final String OptWriteDefaultProperties = "WriteDefaultProperties";
    public static final String OptProgramName = "ProgramName";
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Writer.class);
    private final Pattern NUMERED_R_GROUP = Pattern.compile("R(\\d+)");
    private static final int NN8 = 8;
    private static final int WIDTH = 3;
    private BooleanIOSetting forceWriteAs2DCoords;
    private BooleanIOSetting writeMajorIsotopes;
    private BooleanIOSetting writeAromaticBondTypes;
    @Deprecated
    private BooleanIOSetting writeQueryFormatValencies;
    private BooleanIOSetting writeDefaultProps;
    private StringIOSetting programNameOpt;
    private BufferedWriter writer;

    public MDLV2000Writer(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.initIOSettings();
    }

    public MDLV2000Writer(OutputStream output) {
        this(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    public MDLV2000Writer() {
        this(new StringWriter());
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IAtomContainer.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IChemModel.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        this.customizeJob();
        try {
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                IChemFile file = object.getBuilder().newInstance(IChemFile.class, new Object[0]);
                IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel((IChemModel)object);
                file.addChemSequence(sequence);
                this.writeChemFile(file);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.debug(ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), ex);
        }
        throw new CDKException("Only supported is writing of IChemFile, IChemModel, and IAtomContainer objects.");
    }

    private void writeChemFile(IChemFile file) throws Exception {
        IAtomContainer bigPile = file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtomContainer container2 : ChemFileManipulator.getAllAtomContainers(file)) {
            bigPile.add(container2);
            if (container2.getTitle() != null) {
                if (bigPile.getTitle() != null) {
                    bigPile.setTitle(bigPile.getTitle() + "; " + container2.getTitle());
                } else {
                    bigPile.setTitle(container2.getTitle());
                }
            }
            if (container2.getProperty("cdk:Remark") == null) continue;
            if (bigPile.getProperty("cdk:Remark") != null) {
                bigPile.setProperty("cdk:Remark", bigPile.getProperty("cdk:Remark") + "; " + container2.getProperty("cdk:Remark"));
                continue;
            }
            bigPile.setProperty("cdk:Remark", container2.getProperty("cdk:Remark"));
        }
        this.writeMolecule(bigPile);
    }

    private String getProgName() {
        String progname = this.programNameOpt.getSetting();
        if (progname == null) {
            return "        ";
        }
        if (progname.length() > 8) {
            return progname.substring(0, 8);
        }
        if (progname.length() < 8) {
            return String.format("%-8s", progname);
        }
        return progname;
    }

    public void writeMolecule(IAtomContainer container2) throws Exception {
        int i;
        IAtom atom;
        int f;
        int dim = this.getNumberOfDimensions(container2);
        StringBuilder line = new StringBuilder();
        TreeMap<Integer, Integer> rgroups = null;
        TreeMap<Integer, String> aliases = null;
        String title = container2.getTitle();
        if (title == null) {
            title = "";
        }
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        this.writer.write(title);
        this.writer.write(10);
        this.writer.write("  ");
        this.writer.write(this.getProgName());
        this.writer.write(new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis()));
        if (dim != 0) {
            this.writer.write(Integer.toString(dim));
            this.writer.write(68);
        }
        this.writer.write(10);
        String comment = (String)container2.getProperty("cdk:Remark");
        if (comment == null) {
            comment = "";
        }
        if (comment.length() > 80) {
            comment = comment.substring(0, 80);
        }
        this.writer.write(comment);
        this.writer.write(10);
        HashMap<IAtom, ITetrahedralChirality> atomstereo = new HashMap<IAtom, ITetrahedralChirality>();
        HashMap<IAtom, Integer> atomindex = new HashMap<IAtom, Integer>();
        for (IStereoElement element : container2.stereoElements()) {
            if (!(element instanceof ITetrahedralChirality)) continue;
            atomstereo.put(((ITetrahedralChirality)element).getChiralAtom(), (ITetrahedralChirality)element);
        }
        for (IAtom atom2 : container2.atoms()) {
            atomindex.put(atom2, atomindex.size());
        }
        line.append(MDLV2000Writer.formatMDLInt(container2.getAtomCount(), 3));
        line.append(MDLV2000Writer.formatMDLInt(container2.getBondCount(), 3));
        LinkedHashMap<Integer, IAtom> atomLists = new LinkedHashMap<Integer, IAtom>();
        for (f = 0; f < container2.getAtomCount(); ++f) {
            QueryAtom queryAtom;
            Expr expr;
            if (!(container2.getAtom(f) instanceof IQueryAtom) || !MDLV2000Writer.isValidAtomListExpression(expr = (queryAtom = (QueryAtom)AtomRef.deref(container2.getAtom(f))).getExpression())) continue;
            atomLists.put(f, container2.getAtom(f));
        }
        line.append(MDLV2000Writer.formatMDLInt(atomLists.size(), 3));
        line.append("  0");
        line.append(MDLV2000Writer.getChiralFlag(atomstereo.values()) ? "  1" : "  0");
        line.append("  0  0  0  0  0999 V2000");
        this.writer.write(line.toString());
        this.writer.write(10);
        for (f = 0; f < container2.getAtomCount(); ++f) {
            int last;
            atom = container2.getAtom(f);
            line.setLength(0);
            switch (dim) {
                case 0: {
                    line.append("    0.0000    0.0000    0.0000 ");
                    break;
                }
                case 2: {
                    if (atom.getPoint2d() != null) {
                        line.append(MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().x));
                        line.append(MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().y));
                        line.append("    0.0000 ");
                        break;
                    }
                    line.append("    0.0000    0.0000    0.0000 ");
                    break;
                }
                case 3: {
                    if (atom.getPoint3d() != null) {
                        line.append(MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().x));
                        line.append(MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().y));
                        line.append(MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().z)).append(" ");
                        break;
                    }
                    line.append("    0.0000    0.0000    0.0000 ");
                }
            }
            if (container2.getAtom(f) instanceof IPseudoAtom) {
                IPseudoAtom pseudoAtom = (IPseudoAtom)container2.getAtom(f);
                String label = pseudoAtom.getLabel();
                if (label == null) {
                    label = "";
                }
                Matcher matcher = this.NUMERED_R_GROUP.matcher(label);
                if (pseudoAtom.getAtomicNumber() == 0 && !label.isEmpty() && matcher.matches()) {
                    line.append("R# ");
                    if (rgroups == null) {
                        rgroups = new TreeMap<Integer, Integer>();
                    }
                    rgroups.put(f + 1, Integer.parseInt(matcher.group(1)));
                } else if (label.length() > 3) {
                    if (aliases == null) {
                        aliases = new TreeMap<Integer, String>();
                    }
                    aliases.put(f + 1, label);
                    line.append(MDLV2000Writer.formatMDLString(atom.getSymbol(), 3));
                } else if (!label.isEmpty()) {
                    line.append(MDLV2000Writer.formatMDLString(label, 3));
                } else {
                    line.append(MDLV2000Writer.formatMDLString(atom.getSymbol(), 3));
                }
            } else if (atomLists.containsKey(f)) {
                line.append(MDLV2000Writer.formatMDLString("L", 3));
            } else {
                line.append(MDLV2000Writer.formatMDLString(container2.getAtom(f).getSymbol(), 3));
            }
            int[] atomprops = new int[12];
            atomprops[0] = this.determineIsotope(atom);
            atomprops[1] = this.determineCharge(container2, atom);
            atomprops[2] = this.determineStereoParity(container2, atomstereo, atomindex, atom);
            atomprops[5] = this.determineValence(container2, atom);
            atomprops[9] = this.determineAtomMap(atom);
            line.append(MDLV2000Writer.formatMDLInt(atomprops[0], 2));
            line.append(MDLV2000Writer.formatMDLInt(atomprops[1], 3));
            if (!this.writeDefaultProps.isSet()) {
                for (last = atomprops.length - 1; last >= 0 && atomprops[last] == 0; --last) {
                }
                if (last >= 2 && last < 5) {
                    last = 5;
                }
            }
            for (int i2 = 2; i2 <= last; ++i2) {
                line.append(MDLV2000Writer.formatMDLInt(atomprops[i2], 3));
            }
            line.append('\n');
            this.writer.write(line.toString());
        }
        for (IBond bond : container2.bonds()) {
            int bondType;
            block89: {
                block88: {
                    line.setLength(0);
                    if (bond.getAtomCount() != 2) {
                        logger.warn("Skipping bond with more/less than two atoms: " + bond);
                        continue;
                    }
                    if (bond.getStereo() == IBond.Stereo.UP_INVERTED || bond.getStereo() == IBond.Stereo.DOWN_INVERTED || bond.getStereo() == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                        line.append(MDLV2000Writer.formatMDLInt((Integer)atomindex.get(bond.getEnd()) + 1, 3));
                        line.append(MDLV2000Writer.formatMDLInt((Integer)atomindex.get(bond.getBegin()) + 1, 3));
                    } else {
                        line.append(MDLV2000Writer.formatMDLInt((Integer)atomindex.get(bond.getBegin()) + 1, 3));
                        line.append(MDLV2000Writer.formatMDLInt((Integer)atomindex.get(bond.getEnd()) + 1, 3));
                    }
                    bondType = 0;
                    if (!(bond instanceof QueryBond)) break block88;
                    QueryBond qbond = (QueryBond)bond;
                    Expr e2 = qbond.getExpression();
                    switch (e2.type()) {
                        case ALIPHATIC_ORDER: 
                        case ORDER: {
                            bondType = e2.value();
                            break;
                        }
                        case IS_AROMATIC: {
                            bondType = 4;
                            break;
                        }
                        case SINGLE_OR_DOUBLE: {
                            bondType = 5;
                            break;
                        }
                        case SINGLE_OR_AROMATIC: {
                            bondType = 6;
                            break;
                        }
                        case DOUBLE_OR_AROMATIC: {
                            bondType = 7;
                            break;
                        }
                        case TRUE: {
                            bondType = 8;
                            break;
                        }
                        case OR: {
                            if (e2.equals(new Expr(Expr.Type.ALIPHATIC_ORDER, 1).or(new Expr(Expr.Type.ALIPHATIC_ORDER, 2))) || e2.equals(new Expr(Expr.Type.ALIPHATIC_ORDER, 2).or(new Expr(Expr.Type.ALIPHATIC_ORDER, 1)))) {
                                bondType = 5;
                                break;
                            }
                            if (e2.equals(new Expr(Expr.Type.ALIPHATIC_ORDER, 1).or(new Expr(Expr.Type.IS_AROMATIC))) || e2.equals(new Expr(Expr.Type.IS_AROMATIC).or(new Expr(Expr.Type.ALIPHATIC_ORDER, 1)))) {
                                bondType = 6;
                                break;
                            }
                            if (e2.equals(new Expr(Expr.Type.ALIPHATIC_ORDER, 2).or(new Expr(Expr.Type.IS_AROMATIC))) || e2.equals(new Expr(Expr.Type.IS_AROMATIC).or(new Expr(Expr.Type.ALIPHATIC_ORDER, 2)))) {
                                bondType = 6;
                                break;
                            }
                            break block89;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported bond type!");
                        }
                    }
                    break block89;
                }
                if (bond.getOrder() != null) {
                    switch (bond.getOrder()) {
                        case SINGLE: 
                        case DOUBLE: 
                        case TRIPLE: {
                            if (this.writeAromaticBondTypes.isSet() && bond.isAromatic()) {
                                bondType = 4;
                                break;
                            }
                            bondType = bond.getOrder().numeric();
                            break;
                        }
                        case UNSET: {
                            if (!bond.isAromatic()) break;
                            if (!this.writeAromaticBondTypes.isSet()) {
                                throw new CDKException("Bond at idx " + container2.indexOf(bond) + " was an unspecific aromatic bond which should only be used for queries in Molfiles. These can be written if desired by enabling the option 'WriteAromaticBondTypes'.");
                            }
                            bondType = 4;
                        }
                    }
                }
            }
            if (bondType == 0) {
                throw new CDKException("Bond at idx=" + container2.indexOf(bond) + " is not supported by Molfile, bond=" + (Object)((Object)bond.getOrder()));
            }
            line.append(MDLV2000Writer.formatMDLInt(bondType, 3));
            line.append("  ");
            switch (bond.getStereo()) {
                case UP: {
                    line.append("1");
                    break;
                }
                case UP_INVERTED: {
                    line.append("1");
                    break;
                }
                case DOWN: {
                    line.append("6");
                    break;
                }
                case DOWN_INVERTED: {
                    line.append("6");
                    break;
                }
                case UP_OR_DOWN: {
                    line.append("4");
                    break;
                }
                case UP_OR_DOWN_INVERTED: {
                    line.append("4");
                    break;
                }
                case E_OR_Z: {
                    line.append("3");
                    break;
                }
                default: {
                    line.append("0");
                }
            }
            if (this.writeDefaultProps.isSet()) {
                line.append("  0  0  0");
            }
            line.append('\n');
            this.writer.write(line.toString());
        }
        for (i = 0; i < container2.getAtomCount(); ++i) {
            atom = container2.getAtom(i);
            if (atom.getProperty("cdk:Comment") == null || !(atom.getProperty("cdk:Comment") instanceof String) || ((String)atom.getProperty("cdk:Comment")).trim().equals("")) continue;
            this.writer.write("V  ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write((String)atom.getProperty("cdk:Comment"));
            this.writer.write(10);
        }
        for (i = 0; i < container2.getAtomCount(); ++i) {
            atom = container2.getAtom(i);
            Integer charge = atom.getFormalCharge();
            if (charge == null || charge == 0) continue;
            this.writer.write("M  CHG  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(charge, 3));
            this.writer.write(10);
        }
        if (container2.getSingleElectronCount() > 0) {
            LinkedHashMap<Integer, SPIN_MULTIPLICITY> atomIndexSpinMap = new LinkedHashMap<Integer, SPIN_MULTIPLICITY>();
            block41: for (int i3 = 0; i3 < container2.getAtomCount(); ++i3) {
                IAtom atom3 = container2.getAtom(i3);
                int eCount = container2.getConnectedSingleElectronsCount(atom3);
                switch (eCount) {
                    case 0: {
                        continue block41;
                    }
                    case 1: {
                        atomIndexSpinMap.put(i3, SPIN_MULTIPLICITY.Monovalent);
                        continue block41;
                    }
                    case 2: {
                        SPIN_MULTIPLICITY multiplicity = (SPIN_MULTIPLICITY)((Object)atom3.getProperty("cdk:SpinMultiplicity"));
                        if (multiplicity != null) {
                            atomIndexSpinMap.put(i3, multiplicity);
                            continue block41;
                        }
                        atomIndexSpinMap.put(i3, SPIN_MULTIPLICITY.DivalentSinglet);
                        continue block41;
                    }
                    default: {
                        logger.debug("Invalid number of radicals found: " + eCount);
                    }
                }
            }
            Iterator<Map.Entry<Integer, SPIN_MULTIPLICITY>> iterator = atomIndexSpinMap.entrySet().iterator();
            for (int i4 = 0; i4 < atomIndexSpinMap.size(); i4 += 8) {
                if (atomIndexSpinMap.size() - i4 <= 8) {
                    this.writer.write("M  RAD" + MDLV2000Writer.formatMDLInt(atomIndexSpinMap.size() - i4, 3));
                    this.writeRadicalPattern(iterator, 0);
                } else {
                    this.writer.write("M  RAD" + MDLV2000Writer.formatMDLInt(8, 3));
                    this.writeRadicalPattern(iterator, 0);
                }
                this.writer.write(10);
            }
        }
        for (int i5 = 0; i5 < container2.getAtomCount(); ++i5) {
            atom = container2.getAtom(i5);
            if (atom instanceof IPseudoAtom) continue;
            Integer atomicMass = atom.getMassNumber();
            if (!this.writeMajorIsotopes.isSet() && this.isMajorIsotope(atom)) {
                atomicMass = null;
            }
            if (atomicMass == null) continue;
            this.writer.write("M  ISO  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i5 + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(atomicMass, 3));
            this.writer.write(10);
        }
        if (rgroups != null) {
            StringBuilder rgpLine = new StringBuilder();
            int cnt = 0;
            for (Map.Entry e3 : rgroups.entrySet()) {
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)e3.getKey(), 4));
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)e3.getValue(), 4));
                if (++cnt != 8) continue;
                rgpLine.insert(0, "M  RGP" + MDLV2000Writer.formatMDLInt(cnt, 3));
                this.writer.write(rgpLine.toString());
                this.writer.write(10);
                rgpLine = new StringBuilder();
                cnt = 0;
            }
            if (cnt != 0) {
                rgpLine.insert(0, "M  RGP" + MDLV2000Writer.formatMDLInt(cnt, 3));
                this.writer.write(rgpLine.toString());
                this.writer.write(10);
            }
        }
        if (aliases != null) {
            for (Map.Entry e4 : aliases.entrySet()) {
                this.writer.write("A" + MDLV2000Writer.formatMDLInt((Integer)e4.getKey(), 5));
                this.writer.write(10);
                String label = (String)e4.getValue();
                if (label.length() > 70) {
                    label = label.substring(0, 70);
                }
                this.writer.write(label);
                this.writer.write(10);
            }
        }
        MDLV2000Writer.writeAtomLists(atomLists, this.writer);
        this.writeSgroups(container2, this.writer, atomindex);
        this.writer.write("M  END");
        this.writer.write(10);
        this.writer.flush();
    }

    static boolean getChiralFlag(Iterable<? extends IStereoElement> stereo) {
        boolean chiral = true;
        int seenGrpInfo = 0;
        int numTetrahedral = 0;
        for (IStereoElement iStereoElement : stereo) {
            if (iStereoElement.getConfigClass() != 16896) continue;
            ++numTetrahedral;
            if (iStereoElement.getGroupInfo() == 0) continue;
            if (seenGrpInfo == 0) {
                seenGrpInfo = iStereoElement.getGroupInfo();
            } else if (seenGrpInfo != iStereoElement.getGroupInfo()) {
                logger.warn("Molecule has enhanced stereochemistry that cannot be represented in V2000");
            }
            chiral = false;
        }
        if (numTetrahedral == 0) {
            chiral = false;
        }
        return chiral;
    }

    private static void writeAtomLists(Map<Integer, IAtom> atomLists, BufferedWriter writer) throws IOException {
        ArrayList<String> legacyLines = new ArrayList<String>(atomLists.size());
        ArrayList<String> alsLines = new ArrayList<String>(atomLists.size());
        for (Map.Entry<Integer, IAtom> entry : atomLists.entrySet()) {
            QueryAtom qa = (QueryAtom)AtomRef.deref(entry.getValue());
            Expr expression = qa.getExpression();
            List<String> elements = MDLV2000Writer.getAtomList(expression);
            StringBuilder legacyBuilder = new StringBuilder(80);
            StringBuilder alsBuilder = new StringBuilder(80);
            alsBuilder.append("M  ALS ");
            alsBuilder.append(MDLV2000Writer.formatMDLInt(entry.getKey() + 1, 3));
            alsBuilder.append(MDLV2000Writer.formatMDLInt(elements.size(), 3));
            legacyBuilder.append(MDLV2000Writer.formatMDLInt(entry.getKey() + 1, 3));
            if (expression.type() == Expr.Type.NOT) {
                alsBuilder.append(" T ");
                legacyBuilder.append(" T    ");
            } else {
                alsBuilder.append(" F ");
                legacyBuilder.append(" F    ");
            }
            for (String symbol : elements) {
                alsBuilder.append(MDLV2000Writer.formatMDLString(symbol, 4));
            }
            legacyBuilder.append(MDLV2000Writer.formatMDLInt(elements.size(), 1));
            for (Integer atomicNumber : MDLV2000Writer.getAtomListNumbers(expression)) {
                legacyBuilder.append(" ").append(MDLV2000Writer.formatMDLInt(atomicNumber, 3));
            }
            alsBuilder.append('\n');
            legacyBuilder.append('\n');
            alsLines.add(alsBuilder.toString());
            legacyLines.add(legacyBuilder.toString());
        }
        for (String line : legacyLines) {
            writer.write(line);
        }
        for (String line : alsLines) {
            writer.write(line);
        }
    }

    private static boolean isValidAtomListExpression(Expr exp) {
        Expr rootToCheck;
        if (Expr.Type.NOT == exp.type()) {
            rootToCheck = exp.left();
        } else if (Expr.Type.OR == exp.type()) {
            rootToCheck = exp;
        } else {
            return false;
        }
        EnumSet<Expr.Type> allowedTypes = EnumSet.of(Expr.Type.ELEMENT, Expr.Type.ALIPHATIC_ELEMENT, Expr.Type.AROMATIC_ELEMENT);
        return MDLV2000Writer.allOrsOfAllowedTypes(rootToCheck, allowedTypes);
    }

    private static boolean allOrsOfAllowedTypes(Expr expr, Set<Expr.Type> allowedTypes) {
        if (expr.type() == Expr.Type.OR) {
            return MDLV2000Writer.allOrsOfAllowedTypes(expr.left(), allowedTypes) && MDLV2000Writer.allOrsOfAllowedTypes(expr.right(), allowedTypes);
        }
        return allowedTypes.contains((Object)expr.type());
    }

    private static List<String> getAtomList(Expr exp) {
        ArrayList<Expr> elist = new ArrayList<Expr>();
        MDLV2000Writer.getLeafNodes(exp, elist);
        return elist.stream().map(expr -> Elements.ofNumber(expr.value()).symbol()).collect(Collectors.toList());
    }

    private static List<Integer> getAtomListNumbers(Expr exp) {
        ArrayList<Expr> elist = new ArrayList<Expr>();
        MDLV2000Writer.getLeafNodes(exp, elist);
        return elist.stream().map(Expr::value).collect(Collectors.toList());
    }

    private static void getLeafNodes(Expr exr, List<Expr> elist) {
        if (exr.type().equals((Object)Expr.Type.OR) || exr.type().equals((Object)Expr.Type.AND)) {
            MDLV2000Writer.getLeafNodes(exr.left(), elist);
            MDLV2000Writer.getLeafNodes(exr.right(), elist);
        } else if (exr.type().equals((Object)Expr.Type.NOT)) {
            MDLV2000Writer.getLeafNodes(exr.left(), elist);
        } else {
            elist.add(exr);
        }
    }

    private int determineCharge(IAtomContainer mol, IAtom atom) {
        Integer q = atom.getFormalCharge();
        if (q == null) {
            q = 0;
        }
        switch (q) {
            case -3: {
                return 7;
            }
            case -2: {
                return 6;
            }
            case -1: {
                return 5;
            }
            case 0: {
                if (mol.getConnectedSingleElectronsCount(atom) == 1) {
                    return 4;
                }
                return 0;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private int determineIsotope(IAtom atom) {
        Integer mass = atom.getMassNumber();
        IIsotope major = null;
        if (mass == null) {
            return 0;
        }
        try {
            major = Isotopes.getInstance().getMajorIsotope(atom.getSymbol());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.writeMajorIsotopes.isSet() && major != null && mass.equals(major.getMassNumber())) {
            mass = null;
        }
        if (mass != null) {
            mass = mass - (major != null ? major.getMassNumber() : 0);
            return mass >= -3 && mass <= 4 ? mass : 0;
        }
        return 0;
    }

    private int determineAtomMap(IAtom atom) {
        Object amap = atom.getProperty("cdk:AtomAtomMapping");
        if (amap == null) {
            return 0;
        }
        if (amap instanceof Integer) {
            return (Integer)amap;
        }
        if (amap instanceof String) {
            try {
                return Integer.parseInt((String)amap);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.warn("Skipping non-integer atom map: " + amap + " type:" + amap);
        return 0;
    }

    private int determineValence(IAtomContainer container2, IAtom atom) {
        int explicitValence = (int)AtomContainerManipulator.getBondOrderSum(container2, atom);
        int charge = atom.getFormalCharge() == null ? 0 : atom.getFormalCharge();
        Integer element = atom.getAtomicNumber();
        int valence = 0;
        if (element != null) {
            int actual;
            int implied = MDLValence.implicitValence(element, charge, explicitValence);
            if (atom.getImplicitHydrogenCount() != null) {
                actual = explicitValence + atom.getImplicitHydrogenCount();
            } else if (atom.getValency() != null) {
                actual = atom.getValency();
            } else {
                return 0;
            }
            if (implied != actual) {
                if (actual == 0) {
                    return 15;
                }
                if (actual > 0 && actual < 15) {
                    return actual;
                }
            }
        }
        return valence;
    }

    private int determineStereoParity(IAtomContainer container2, Map<IAtom, ITetrahedralChirality> atomstereo, Map<IAtom, Integer> atomindex, IAtom atom) {
        int i;
        ITetrahedralChirality tc = atomstereo.get(atom);
        if (tc == null) {
            return 0;
        }
        int parity = tc.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE ? 1 : 2;
        IAtom focus = tc.getChiralAtom();
        IAtom[] carriers = tc.getLigands();
        int hidx = -1;
        for (i = 0; i < 4; ++i) {
            if (!carriers[i].equals(focus) && carriers[i].getAtomicNumber() != 1) continue;
            if (hidx >= 0) {
                parity = 0;
            }
            hidx = i;
        }
        if (parity != 0) {
            for (i = 0; i < 4; ++i) {
                for (int j = i + 1; j < 4; ++j) {
                    int a = atomindex.get(carriers[i]);
                    int b = atomindex.get(carriers[j]);
                    if (i == hidx) {
                        a = container2.getAtomCount();
                    }
                    if (j == hidx) {
                        b = container2.getAtomCount();
                    }
                    if (a <= b) continue;
                    parity ^= 3;
                }
            }
        }
        return parity;
    }

    private boolean isMajorIsotope(IAtom atom) {
        if (atom.getMassNumber() == null) {
            return false;
        }
        try {
            IIsotope major = Isotopes.getInstance().getMajorIsotope(atom.getSymbol());
            return major != null && major.getMassNumber().equals(atom.getMassNumber());
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSgroups(IAtomContainer container2, BufferedWriter writer, Map<IAtom, Integer> atomidxs) throws IOException {
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)container2.getProperty("cdk:CtabSgroups");
        if (sgroups == null) {
            return;
        }
        sgroups = new ArrayList<Sgroup>(sgroups);
        sgroups.removeIf(sgroup -> !sgroup.getType().isCtabStandard());
        ArrayList<AbstractMap.SimpleEntry<Sgroup, Sgroup>> parentList = new ArrayList<AbstractMap.SimpleEntry<Sgroup, Sgroup>>();
        for (Sgroup sgroup2 : sgroups) {
            for (Sgroup sgroup3 : sgroup2.getParents()) {
                parentList.add(new AbstractMap.SimpleEntry<Sgroup, Sgroup>(sgroup2, sgroup3));
            }
        }
        for (List list : this.wrap(sgroups, 8)) {
            writer.write("M  STY");
            writer.write(MDLV2000Writer.formatMDLInt(list.size(), 3));
            for (Sgroup sgroup4 : list) {
                writer.write(32);
                writer.write(MDLV2000Writer.formatMDLInt(1 + sgroups.indexOf(sgroup4), 3));
                writer.write(32);
                writer.write(sgroup4.getType().getKey());
            }
            writer.write(10);
        }
        for (List list : this.wrap(parentList, 8)) {
            writer.write("M  SPL");
            writer.write(MDLV2000Writer.formatMDLInt(list.size(), 3));
            for (Map.Entry entry : list) {
                writer.write(32);
                writer.write(MDLV2000Writer.formatMDLInt(1 + sgroups.indexOf(entry.getKey()), 3));
                writer.write(32);
                writer.write(MDLV2000Writer.formatMDLInt(1 + sgroups.indexOf(entry.getValue()), 3));
            }
            writer.write(10);
        }
        for (int id = 1; id <= sgroups.size(); ++id) {
            Sgroup sgroup5 = (Sgroup)sgroups.get(id - 1);
            for (List list : this.wrap(sgroup5.getAtoms(), 15)) {
                writer.write("M  SAL ");
                writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                writer.write(MDLV2000Writer.formatMDLInt(list.size(), 3));
                for (IAtom atom : list) {
                    writer.write(32);
                    writer.write(MDLV2000Writer.formatMDLInt(1 + atomidxs.get(atom), 3));
                }
                writer.write(10);
            }
            for (List list : this.wrap(sgroup5.getBonds(), 15)) {
                writer.write("M  SBL ");
                writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                writer.write(MDLV2000Writer.formatMDLInt(list.size(), 3));
                for (IBond bond : list) {
                    writer.write(32);
                    writer.write(MDLV2000Writer.formatMDLInt(1 + container2.indexOf(bond), 3));
                }
                writer.write(10);
            }
            Set<SgroupKey> attributeKeys = sgroup5.getAttributeKeys();
            block23: for (SgroupKey key : attributeKeys) {
                switch (key) {
                    case CtabSubScript: {
                        writer.write("M  SMT ");
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write((String)sgroup5.getValue(key));
                        writer.write(10);
                        break;
                    }
                    case CtabExpansion: {
                        boolean expanded = (Boolean)sgroup5.getValue(key);
                        if (!expanded) break;
                        writer.write("M  SDS EXP");
                        writer.write(MDLV2000Writer.formatMDLInt(1, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(10);
                        break;
                    }
                    case CtabBracket: {
                        List brackets = (List)sgroup5.getValue(key);
                        for (Object bracket : brackets) {
                            writer.write("M  SDI ");
                            writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                            writer.write(MDLV2000Writer.formatMDLInt(4, 3));
                            writer.write(MDLV2000Writer.formatMDLFloat((float)((SgroupBracket)bracket).getFirstPoint().x));
                            writer.write(MDLV2000Writer.formatMDLFloat((float)((SgroupBracket)bracket).getFirstPoint().y));
                            writer.write(MDLV2000Writer.formatMDLFloat((float)((SgroupBracket)bracket).getSecondPoint().x));
                            writer.write(MDLV2000Writer.formatMDLFloat((float)((SgroupBracket)bracket).getSecondPoint().y));
                            writer.write(10);
                        }
                        continue block23;
                    }
                    case CtabBracketStyle: {
                        writer.write("M  SBT");
                        writer.write(MDLV2000Writer.formatMDLInt(1, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt((Integer)sgroup5.getValue(key), 3));
                        writer.write(10);
                        break;
                    }
                    case CtabConnectivity: {
                        writer.write("M  SCN");
                        writer.write(MDLV2000Writer.formatMDLInt(1, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write(((String)sgroup5.getValue(key)).toUpperCase(Locale.ROOT));
                        writer.write(10);
                        break;
                    }
                    case CtabSubType: {
                        writer.write("M  SST");
                        writer.write(MDLV2000Writer.formatMDLInt(1, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write((String)sgroup5.getValue(key));
                        writer.write(10);
                        break;
                    }
                    case CtabParentAtomList: {
                        Collection parentAtomList = (Collection)sgroup5.getValue(key);
                        for (List list : this.wrap(parentAtomList, 15)) {
                            writer.write("M  SPA ");
                            writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                            writer.write(MDLV2000Writer.formatMDLInt(list.size(), 3));
                            for (IAtom atom : list) {
                                writer.write(32);
                                writer.write(MDLV2000Writer.formatMDLInt(1 + atomidxs.get(atom), 3));
                            }
                            writer.write(10);
                        }
                        continue block23;
                    }
                    case CtabComponentNumber: {
                        Integer compNumber = (Integer)sgroup5.getValue(key);
                        writer.write("M  SNC");
                        writer.write(MDLV2000Writer.formatMDLInt(1, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write(MDLV2000Writer.formatMDLInt(compNumber, 3));
                        writer.write(10);
                        break;
                    }
                    case Data: {
                        void var15_37;
                        String string = (String)sgroup5.getValue(SgroupKey.Data);
                        if (string == null) break;
                        String string2 = string.replaceAll("[\r\n]", " ");
                        while (var15_37.length() > 69) {
                            writer.write("M  SCD ");
                            writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                            writer.write(32);
                            writer.write(var15_37.substring(0, 69));
                            writer.write(10);
                            String string3 = var15_37.substring(69);
                        }
                        writer.write("M  SED ");
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write((String)var15_37);
                        writer.write(10);
                        break;
                    }
                    case DataFieldName: {
                        char[] pad = new char[30];
                        Arrays.fill(pad, ' ');
                        String name = (String)sgroup5.getValue(SgroupKey.DataFieldName);
                        String fmt = (String)sgroup5.getValue(SgroupKey.DataFieldFormat);
                        String units = (String)sgroup5.getValue(SgroupKey.DataFieldUnits);
                        if (name == null) break;
                        if (name.length() > 30) {
                            name = name.substring(0, 30);
                        }
                        writer.write("M  SDT ");
                        writer.write(MDLV2000Writer.formatMDLInt(id, 3));
                        writer.write(32);
                        writer.write(name);
                        writer.write(pad, 0, 30 - name.length());
                        if (fmt != null && fmt.length() > 0 && (fmt.charAt(0) == 'N' || fmt.charAt(0) == 'F' || fmt.charAt(0) == 'T')) {
                            writer.write(fmt.charAt(0) + " ");
                        } else {
                            writer.write("  ");
                        }
                        if (units != null) {
                            if (units.length() > 20) {
                                units = units.substring(0, 20);
                            }
                            writer.write(units);
                        }
                        writer.write(10);
                        break;
                    }
                }
            }
        }
    }

    private <T> List<List<T>> wrap(Collection<T> set, int lim) {
        ArrayList<List<T>> wrapped = new ArrayList<List<T>>();
        ArrayList<T> list = new ArrayList<T>(set);
        if (set.size() <= lim) {
            if (!list.isEmpty()) {
                wrapped.add(list);
            }
        } else {
            int i = 0;
            while (i + lim < set.size()) {
                wrapped.add(list.subList(i, i + lim));
                i += lim;
            }
            wrapped.add(list.subList(i, list.size()));
        }
        return wrapped;
    }

    private int getNumberOfDimensions(IAtomContainer mol) {
        for (IAtom atom : mol.atoms()) {
            if (atom.getPoint3d() != null && !this.forceWriteAs2DCoords.isSet()) {
                return 3;
            }
            if (atom.getPoint2d() == null) continue;
            return 2;
        }
        return 0;
    }

    private void writeRadicalPattern(Iterator<Map.Entry<Integer, SPIN_MULTIPLICITY>> iterator, int i) throws IOException {
        Map.Entry<Integer, SPIN_MULTIPLICITY> entry = iterator.next();
        this.writer.write(" ");
        this.writer.write(MDLV2000Writer.formatMDLInt(entry.getKey() + 1, 3));
        this.writer.write(" ");
        this.writer.write(MDLV2000Writer.formatMDLInt(entry.getValue().getValue(), 3));
        if (++i < 8 && iterator.hasNext()) {
            this.writeRadicalPattern(iterator, i);
        }
    }

    protected static String formatMDLInt(int x, int n) {
        char[] buf = new char[n];
        Arrays.fill(buf, ' ');
        String val = Integer.toString(x);
        if (val.length() > n) {
            val = "0";
        }
        int off = n - val.length();
        for (int i = 0; i < val.length(); ++i) {
            buf[off + i] = val.charAt(i);
        }
        return new String(buf);
    }

    protected static String formatMDLFloat(float fl) {
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
        String s = Double.isNaN(fl) || Double.isInfinite(fl) ? "0.0000" : nf.format(fl);
        int l = 10 - s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLString(String s, int le) {
        if ((s = s.trim()).length() > le) {
            return s.substring(0, le);
        }
        int l = le - s.length();
        for (int f = 0; f < l; ++f) {
            s = s + " ";
        }
        return s;
    }

    private void initIOSettings() {
        this.forceWriteAs2DCoords = (BooleanIOSetting)this.addSetting(new BooleanIOSetting(OptForceWriteAs2DCoordinates, IOSetting.Importance.LOW, "Should coordinates always be written as 2D?", "false"));
        this.writeMajorIsotopes = (BooleanIOSetting)this.addSetting(new BooleanIOSetting(OptWriteMajorIsotopes, IOSetting.Importance.LOW, "Write atomic mass of any non-null atomic mass including major isotopes (e.g. [12]C)", "true"));
        this.writeAromaticBondTypes = (BooleanIOSetting)this.addSetting(new BooleanIOSetting(OptWriteAromaticBondTypes, IOSetting.Importance.LOW, "Should aromatic bonds be written as bond type 4?", "false"));
        this.writeQueryFormatValencies = (BooleanIOSetting)this.addSetting(new BooleanIOSetting(OptWriteQueryFormatValencies, IOSetting.Importance.LOW, "Should valencies be written in the MDL Query format? (deprecated)", "false"));
        this.writeDefaultProps = (BooleanIOSetting)this.addSetting(new BooleanIOSetting(OptWriteDefaultProperties, IOSetting.Importance.LOW, "Write trailing zero's on atom/bond property blocks even if they're not used.", "true"));
        this.programNameOpt = (StringIOSetting)this.addSetting(new StringIOSetting(OptProgramName, IOSetting.Importance.LOW, "Program name to write at the top of the molfile header, should be exactly 8 characters long", "CDK"));
    }

    public void setWriteAromaticBondTypes(boolean val) {
        try {
            this.writeAromaticBondTypes.setSetting(Boolean.toString(val));
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    public static enum SPIN_MULTIPLICITY {
        None(0, 0),
        Monovalent(2, 1),
        DivalentSinglet(1, 2),
        DivalentTriplet(3, 2);

        private final int value;
        private final int singleElectrons;

        private SPIN_MULTIPLICITY(int value, int singleElectrons) {
            this.value = value;
            this.singleElectrons = singleElectrons;
        }

        public int getValue() {
            return this.value;
        }

        public int getSingleElectrons() {
            return this.singleElectrons;
        }

        public static SPIN_MULTIPLICITY ofValue(int value) throws CDKException {
            switch (value) {
                case 0: {
                    return None;
                }
                case 1: {
                    return DivalentSinglet;
                }
                case 2: {
                    return Monovalent;
                }
                case 3: {
                    return DivalentTriplet;
                }
            }
            throw new CDKException("unknown spin multiplicity: " + value);
        }
    }
}

