/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MOPAC7Format;

public class Mopac7Reader
extends DefaultChemObjectReader {
    BufferedReader input;
    private static final String[] parameters = new String[]{"NO. OF FILLED LEVELS", "TOTAL ENERGY", "FINAL HEAT OF FORMATION", "IONIZATION POTENTIAL", "ELECTRONIC ENERGY", "CORE-CORE REPULSION", "MOLECULAR WEIGHT", "EHOMO", "ELUMO"};
    private static final String[] units = new String[]{"", "EV", "KJ", "", "EV", "EV", "", "EV", "EV"};
    private static final String eigenvalues = "EIGENVALUES";
    private static final String filledLevels = "NO. OF FILLED LEVELS";

    public Mopac7Reader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public Mopac7Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Mopac7Reader() {
        this(new StringReader(""));
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        String[] expected_columns = new String[]{"NO.", "ATOM", "X", "Y", "Z"};
        StringBuilder eigenvalues = new StringBuilder();
        if (object instanceof IAtomContainer) {
            IAtomContainer container2 = (IAtomContainer)object;
            try {
                String line = this.input.readLine();
                while (line != null) {
                    if (line.contains("****  MAX. NUMBER OF ATOMS ALLOWED")) {
                        throw new CDKException(line);
                    }
                    if (line.contains("TO CONTINUE CALCULATION SPECIFY \"GEO-OK\"")) {
                        throw new CDKException(line);
                    }
                    if ("CARTESIAN COORDINATES".equals(line.trim())) {
                        IAtomContainer atomcontainer = (IAtomContainer)object;
                        line = this.input.readLine();
                        if (line == null) {
                            throw new IllegalArgumentException("Blank line expected, but reached end of input");
                        }
                        line = this.input.readLine();
                        String[] columns = line.trim().split(" +");
                        int okCols = 0;
                        if (columns.length == expected_columns.length) {
                            for (int i = 0; i < expected_columns.length; ++i) {
                                okCols += columns[i].equals(expected_columns[i]) ? 1 : 0;
                            }
                        }
                        if (okCols < expected_columns.length) continue;
                        String blank = this.input.readLine();
                        if (blank == null) {
                            throw new IllegalArgumentException("Blank line expected, but reached end of input");
                        }
                        int atomIndex = 0;
                        while (!line.trim().isEmpty()) {
                            line = this.input.readLine();
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            int token = 0;
                            IElement atom = null;
                            double[] point3d = new double[3];
                            while (tokenizer.hasMoreTokens()) {
                                String tokenStr = tokenizer.nextToken();
                                switch (token) {
                                    case 0: {
                                        atomIndex = Integer.parseInt(tokenStr) - 1;
                                        if (atomIndex < atomcontainer.getAtomCount()) {
                                            atom = atomcontainer.getAtom(atomIndex);
                                            break;
                                        }
                                        atom = null;
                                        break;
                                    }
                                    case 1: {
                                        if (atom == null || tokenStr.equals(atom.getSymbol())) break;
                                        atom = null;
                                        break;
                                    }
                                    case 2: {
                                        point3d[0] = Double.parseDouble(tokenStr);
                                        break;
                                    }
                                    case 3: {
                                        point3d[1] = Double.parseDouble(tokenStr);
                                        break;
                                    }
                                    case 4: {
                                        point3d[2] = Double.parseDouble(tokenStr);
                                        if (atom == null) break;
                                        atom.setPoint3d(new Point3d(point3d));
                                    }
                                }
                                ++token;
                                if (atom != null) continue;
                                break;
                            }
                            if (atom != null && atomIndex + 1 < atomcontainer.getAtomCount()) continue;
                            break;
                        }
                    } else if (line.contains(eigenvalues)) {
                        line = this.input.readLine();
                        line = this.input.readLine();
                        while (!line.trim().equals("")) {
                            eigenvalues.append(line);
                            line = this.input.readLine();
                        }
                        container2.setProperty(eigenvalues, eigenvalues.toString());
                    } else {
                        for (int i = 0; i < parameters.length; ++i) {
                            if (!line.contains(parameters[i])) continue;
                            String value = line.substring(line.lastIndexOf(61) + 1).trim();
                            int pos = (value = value.replaceAll(units[i], "").trim()).indexOf(32);
                            if (pos >= 0) {
                                value = value.substring(0, pos - 1);
                            }
                            container2.setProperty(parameters[i], value.trim());
                            break;
                        }
                    }
                    line = this.input.readLine();
                }
                this.calcHomoLumo(container2);
                return (T)container2;
            }
            catch (IOException exception) {
                throw new CDKException(exception.getMessage());
            }
        }
        return null;
    }

    private void calcHomoLumo(IAtomContainer mol) {
        int nFilledLevels;
        Object eigenProp = mol.getProperty(eigenvalues);
        if (eigenProp == null) {
            return;
        }
        Object filledLevelsProp = mol.getProperty(filledLevels);
        if (filledLevelsProp == null) {
            return;
        }
        try {
            nFilledLevels = Integer.parseInt(filledLevelsProp.toString());
        }
        catch (NumberFormatException exception) {
            return;
        }
        String[] eigenVals = eigenProp.toString().split("\\s");
        int levelCounter = 0;
        for (String eigenVal : eigenVals) {
            if (eigenVal.trim().isEmpty()) continue;
            try {
                Double.parseDouble(eigenVal);
                if (++levelCounter == nFilledLevels) {
                    mol.setProperty("EHOMO", eigenVal);
                    continue;
                }
                if (levelCounter != nFilledLevels + 1) continue;
                mol.setProperty("ELUMO", eigenVal);
            }
            catch (NumberFormatException exception) {
                return;
            }
        }
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.input = new BufferedReader(new InputStreamReader(input));
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public IResourceFormat getFormat() {
        return MOPAC7Format.getInstance();
    }
}

