/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.rebond.RebondTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PMPFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class PMPReader
extends DefaultChemObjectReader {
    private static final String PMP_ZORDER = "ZOrder";
    private static final String PMP_ID = "Id";
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(PMPReader.class);
    private IAtomContainer modelStructure;
    private IChemObject chemObject;
    private final Map<Integer, Integer> atomids = new Hashtable<Integer, Integer>();
    private final Map<Integer, Integer> atomGivenIds = new Hashtable<Integer, Integer>();
    private final Map<Integer, Integer> bondids = new Hashtable<Integer, Integer>();
    private final Map<Integer, Integer> bondAtomOnes = new Hashtable<Integer, Integer>();
    private final Map<Integer, Integer> bondAtomTwos = new Hashtable<Integer, Integer>();
    private final Map<Integer, Double> bondOrders = new Hashtable<Integer, Double>();
    final Pattern objHeader;
    final Pattern objCommand;
    final Pattern atomTypePattern;
    int lineNumber;
    int bondCounter = 0;
    private final RebondTool rebonder;

    public PMPReader(Reader input) {
        this.input = new BufferedReader(input);
        this.lineNumber = 0;
        this.objHeader = Pattern.compile(".*\\((\\d+)\\s(\\w+)$");
        this.objCommand = Pattern.compile(".*\\(A\\s([CFDIO])\\s(\\w+)\\s+\"?(.*?)\"?\\)$");
        this.atomTypePattern = Pattern.compile("^(\\d+)\\s+(\\w+)$");
        this.rebonder = new RebondTool(2.0, 0.5, 0.5);
    }

    public PMPReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public PMPReader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return PMPFormat.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IChemFile.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private String readLine() throws IOException {
        String line = this.input.readLine();
        ++this.lineNumber;
        logger.debug("LINE (" + this.lineNumber + "): ", line);
        return line;
    }

    private IChemFile readChemFile(IChemFile chemFile) {
        try {
            String line = this.readLine();
            while (this.input.ready() && line != null) {
                if (line.startsWith("%%Header Start")) {
                    while (this.input.ready() && line != null && !line.startsWith("%%Header End")) {
                        String version2;
                        if (line.startsWith("%%Version Number") && !(version2 = this.readLine().trim()).equals("3.00")) {
                            logger.error("The PMPReader only supports PMP files with version 3.00");
                            return null;
                        }
                        line = this.readLine();
                    }
                } else if (line.startsWith("%%Model Start")) {
                    this.modelStructure = chemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                    while (this.input.ready() && line != null && !line.startsWith("%%Model End")) {
                        Matcher objHeaderMatcher = this.objHeader.matcher(line);
                        if (objHeaderMatcher.matches()) {
                            String object = objHeaderMatcher.group(2);
                            this.constructObject(chemFile.getBuilder(), object);
                            int id = Integer.parseInt(objHeaderMatcher.group(1));
                            line = this.readLine();
                            while (this.input.ready() && line != null && !line.trim().equals(")")) {
                                Matcher objCommandMatcher = this.objCommand.matcher(line);
                                objHeaderMatcher = this.objHeader.matcher(line);
                                if (objHeaderMatcher.matches()) {
                                    object = objHeaderMatcher.group(2);
                                    id = Integer.parseInt(objHeaderMatcher.group(1));
                                    this.constructObject(chemFile.getBuilder(), object);
                                } else if (objCommandMatcher.matches()) {
                                    String format = objCommandMatcher.group(1);
                                    String command = objCommandMatcher.group(2);
                                    String field = objCommandMatcher.group(3);
                                    this.processModelCommand(object, command, format, field);
                                } else {
                                    logger.warn("Skipping line: " + line);
                                }
                                line = this.readLine();
                            }
                            if (this.chemObject instanceof IAtom) {
                                this.atomids.put(id, this.modelStructure.getAtomCount());
                                this.atomGivenIds.put(Integer.valueOf((String)this.chemObject.getProperty(PMP_ID)), id);
                                this.modelStructure.addAtom((IAtom)this.chemObject);
                            } else if (!(this.chemObject instanceof IBond)) {
                                logger.error("chemObject is not initialized or of bad class type");
                            }
                        }
                        line = this.readLine();
                    }
                    assert (line != null);
                    if (line.startsWith("%%Model End")) {
                        int bondsFound = this.bondids.size();
                        logger.debug("Found #bonds: ", bondsFound);
                        logger.debug("#atom ones: ", this.bondAtomOnes.size());
                        logger.debug("#atom twos: ", this.bondAtomTwos.size());
                        logger.debug("#orders: ", this.bondOrders.size());
                        for (Integer index : this.bondids.keySet()) {
                            double order = this.bondOrders.get(index) != null ? this.bondOrders.get(index) : 1.0;
                            logger.debug("index: ", index);
                            logger.debug("ones: ", this.bondAtomOnes.get(index));
                            IAtom atom1 = this.modelStructure.getAtom(this.atomids.get(this.bondAtomOnes.get(index)));
                            IAtom atom2 = this.modelStructure.getAtom(this.atomids.get(this.bondAtomTwos.get(index)));
                            IBond bond = this.modelStructure.getBuilder().newInstance(IBond.class, atom1, atom2);
                            if (order == 1.0) {
                                bond.setOrder(IBond.Order.SINGLE);
                            } else if (order == 2.0) {
                                bond.setOrder(IBond.Order.DOUBLE);
                            } else if (order == 3.0) {
                                bond.setOrder(IBond.Order.TRIPLE);
                            } else if (order == 4.0) {
                                bond.setOrder(IBond.Order.QUADRUPLE);
                            }
                            this.modelStructure.addBond(bond);
                        }
                    }
                } else if (line.startsWith("%%Traj Start")) {
                    IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                    double energyFragment = 0.0;
                    double energyTotal = 0.0;
                    int Z = 1;
                    while (this.input.ready() && line != null && !line.startsWith("%%Traj End")) {
                        if (line.startsWith("%%Start Frame")) {
                            IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                            ICrystal crystal = chemFile.getBuilder().newInstance(ICrystal.class, new Object[0]);
                            while (this.input.ready() && line != null && !line.startsWith("%%End Frame")) {
                                if (line.startsWith("%%Atom Coords")) {
                                    if (energyFragment != 0.0 && energyTotal != 0.0) {
                                        Z = (int)Math.round(energyTotal / energyFragment);
                                        logger.debug("Z derived from energies: ", Z);
                                    }
                                    int expatoms = this.modelStructure.getAtomCount();
                                    for (int molCount = 1; molCount <= Z; ++molCount) {
                                        IAtomContainer clone = this.modelStructure.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                                        for (int i = 0; i < expatoms; ++i) {
                                            line = this.readLine();
                                            IAtom a = clone.getBuilder().newInstance(IAtom.class, new Object[0]);
                                            StringTokenizer st = new StringTokenizer(line, " ");
                                            a.setPoint3d(new Point3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                            a.setCovalentRadius(0.6);
                                            IAtom modelAtom = this.modelStructure.getAtom(this.atomids.get(this.atomGivenIds.get(i + 1)));
                                            a.setSymbol(modelAtom.getSymbol());
                                            clone.addAtom(a);
                                        }
                                        this.rebonder.rebond(clone);
                                        crystal.add(clone);
                                    }
                                } else if (line.startsWith("%%E/Frag")) {
                                    line = this.readLine().trim();
                                    energyFragment = Double.parseDouble(line);
                                } else if (line.startsWith("%%Tot E")) {
                                    line = this.readLine().trim();
                                    energyTotal = Double.parseDouble(line);
                                } else if (line.startsWith("%%Lat Vects")) {
                                    line = this.readLine();
                                    StringTokenizer st = new StringTokenizer(line, " ");
                                    crystal.setA(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                    line = this.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setB(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                    line = this.readLine();
                                    st = new StringTokenizer(line, " ");
                                    crystal.setC(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                                } else if (line.startsWith("%%Space Group")) {
                                    line = this.readLine().trim();
                                    if ("P 21 21 21 (1)".equals(line)) {
                                        crystal.setSpaceGroup("P 2_1 2_1 2_1");
                                    } else {
                                        crystal.setSpaceGroup("P1");
                                    }
                                }
                                line = this.readLine();
                            }
                            chemModel.setCrystal(crystal);
                            chemSequence.addChemModel(chemModel);
                        }
                        line = this.readLine();
                    }
                    chemFile.addChemSequence(chemSequence);
                }
                line = this.readLine();
            }
        }
        catch (IOException e2) {
            logger.error("An IOException happened: ", e2.getMessage());
            logger.debug(e2);
            chemFile = null;
        }
        catch (CDKException e3) {
            logger.error("An CDKException happened: ", e3.getMessage());
            logger.debug(e3);
            chemFile = null;
        }
        return chemFile;
    }

    private void processModelCommand(String object, String command, String format, String field) {
        logger.debug(object + "->" + command + " (" + format + "): " + field);
        if ("Model".equals(object)) {
            logger.warn("Unkown PMP Model command: " + command);
        } else if ("Atom".equals(object)) {
            if ("ACL".equals(command)) {
                Matcher atomTypeMatcher = this.atomTypePattern.matcher(field);
                if (atomTypeMatcher.matches()) {
                    int atomicnum = Integer.parseInt(atomTypeMatcher.group(1));
                    String type = atomTypeMatcher.group(2);
                    ((IAtom)this.chemObject).setAtomicNumber(atomicnum);
                    ((IAtom)this.chemObject).setSymbol(type);
                } else {
                    logger.error("Incorrectly formated field value: " + field + ".");
                }
            } else if ("Charge".equals(command)) {
                try {
                    double charge = Double.parseDouble(field);
                    ((IAtom)this.chemObject).setCharge(charge);
                }
                catch (NumberFormatException e2) {
                    logger.error("Incorrectly formated float field: " + field + ".");
                }
            } else if (!"CMAPPINGS".equals(command) && !"FFType".equals(command)) {
                if (PMP_ID.equals(command)) {
                    this.chemObject.setProperty(PMP_ID, field);
                } else if (!"Mass".equals(command) && !"XYZ".equals(command)) {
                    if (PMP_ZORDER.equals(command)) {
                        this.chemObject.setProperty(PMP_ZORDER, field);
                    } else {
                        logger.warn("Unkown PMP Atom command: " + command);
                    }
                }
            }
        } else if ("Bond".equals(object)) {
            if ("Atom1".equals(command)) {
                int atomid = Integer.parseInt(field);
                this.bondAtomOnes.put(this.bondCounter, atomid);
            } else if ("Atom2".equals(command)) {
                int atomid = Integer.parseInt(field);
                logger.debug("atomids: " + this.atomids);
                logger.debug("atomid: " + atomid);
                this.bondAtomTwos.put(this.bondCounter, atomid);
            } else if ("Order".equals(command)) {
                double order = Double.parseDouble(field);
                this.bondOrders.put(this.bondCounter, order);
            } else if (PMP_ID.equals(command)) {
                int bondid = Integer.parseInt(field);
                this.bondids.put(this.bondCounter, bondid);
            } else if (!("Label".equals(command) || "3DGridOrigin".equals(command) || "3DGridMatrix".equals(command) || "3DGridDivision".equals(command))) {
                logger.warn("Unkown PMP Bond command: " + command);
            }
        } else {
            logger.warn("Unkown PMP object: " + object);
        }
    }

    private void constructObject(IChemObjectBuilder builder, String object) {
        if ("Atom".equals(object)) {
            this.chemObject = builder.newInstance(IAtom.class, "C");
        } else if ("Bond".equals(object)) {
            ++this.bondCounter;
            this.chemObject = builder.newInstance(IBond.class, new Object[0]);
        } else if ("Model".equals(object)) {
            this.modelStructure = builder.newInstance(IAtomContainer.class, new Object[0]);
        } else {
            logger.error("Cannot construct PMP object type: " + object);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

