/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesXMLFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.pubchemxml.PubChemXMLHelper;

public class IteratingPCSubstancesXMLReader
extends DefaultIteratingChemObjectReader<IChemModel> {
    private Reader primarySource;
    private XMLStreamReader parser;
    private final PubChemXMLHelper parserHelper;
    private final XMLInputFactory xmlfact;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemModel nextSubstance;

    public IteratingPCSubstancesXMLReader(Reader in, IChemObjectBuilder builder) throws IOException, XMLStreamException {
        this.parserHelper = new PubChemXMLHelper(builder);
        this.xmlfact = XMLInputFactory.newFactory();
        this.xmlfact.setProperty("javax.xml.stream.isNamespaceAware", true);
        this.parser = this.xmlfact.createXMLStreamReader(in);
        this.primarySource = in;
        this.nextSubstance = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public IteratingPCSubstancesXMLReader(InputStream in, IChemObjectBuilder builder) throws Exception {
        this(new InputStreamReader(in), builder);
    }

    @Override
    public IResourceFormat getFormat() {
        return PubChemSubstancesXMLFormat.getInstance();
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.parser.next() == 8) {
                    return false;
                }
                while (this.parser.next() != 8) {
                    if (this.parser.getEventType() != 1 || !"PC-Substance".equals(this.parser.getLocalName())) continue;
                    this.hasNext = true;
                    break;
                }
                if (this.hasNext) {
                    this.nextSubstance = this.parserHelper.parseSubstance(this.parser);
                }
            }
            catch (Exception e2) {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new RuntimeException("Error while parsing the XML: " + e2.getMessage(), e2);
                }
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextSubstance = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @Override
    public IChemModel next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextSubstance;
    }

    @Override
    public void close() throws IOException {
        this.primarySource.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) throws CDKException {
        this.primarySource = reader;
        try {
            this.parser = this.xmlfact.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e2) {
            throw new CDKException("Error while opening the input:" + e2.getMessage(), e2);
        }
        this.nextSubstance = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    public void setReader(InputStream reader) throws CDKException {
        this.setReader(new InputStreamReader(reader));
    }
}

