/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator.event;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.cml.CMLErrorHandler;
import org.openscience.cdk.io.cml.CMLResolver;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.event.DefaultEventChemObjectReader;
import org.openscience.cdk.io.iterator.event.EventCMLHandler;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class EventCMLReader
extends DefaultEventChemObjectReader {
    private XMLReader parser;
    private Reader input;
    private final IChemObjectBuilder builder;
    private final EventCMLHandler cdo;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(EventCMLReader.class);

    public EventCMLReader(Reader input, IReaderListener listener, IChemObjectBuilder builder) {
        this.init();
        this.input = input;
        this.cdo = new EventCMLHandler(this, builder);
        this.builder = builder;
        this.addChemObjectIOListener(listener);
    }

    @Override
    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    @Override
    public IAtomContainer getAtomContainer() {
        return this.cdo.getAtomContainer();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = reader;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (ParserConfigurationException | SAXException e2) {
                logger.warn("Could not instantiate JAXP/SAX XML reader: ", e2.getMessage());
                logger.debug(e2);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e3) {
                logger.warn("Could not instantiate Aelfred2 XML reader!");
                logger.debug(e3);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e4) {
                logger.warn("Could not instantiate Xerces XML reader!");
                logger.debug(e4);
            }
        }
        if (!success) {
            logger.error("Could not instantiate any XML parser!");
        }
    }

    public void process() throws CDKException {
        logger.debug("Started parsing from input...");
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info("Deactivated validation");
        }
        catch (SAXException e2) {
            logger.warn("Cannot deactivate validation.");
        }
        this.parser.setContentHandler(new EventCMLHandler(this, this.builder));
        this.parser.setEntityResolver(new CMLResolver());
        this.parser.setErrorHandler(new CMLErrorHandler());
        try {
            logger.debug("Parsing from Reader");
            this.parser.parse(new InputSource(this.input));
        }
        catch (IOException e3) {
            String error = "Error while reading file: " + e3.getMessage();
            logger.error(error);
            logger.debug(e3);
            throw new CDKException(error, e3);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error = "Found well-formedness error in line " + spe.getLineNumber();
            logger.error(error);
            logger.debug(saxe);
            throw new CDKException(error, saxe);
        }
        catch (SAXException saxe) {
            String error = "Error while parsing XML: " + saxe.getMessage();
            logger.error(error);
            logger.debug(saxe);
            throw new CDKException(error, saxe);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

