/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.random.DefaultRandomAccessChemObjectReader;
import org.openscience.cdk.io.random.IRandomAccessChemObjectReader;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public abstract class RandomAccessReader
extends DefaultRandomAccessChemObjectReader
implements IRandomAccessChemObjectReader<IChemObject> {
    protected static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RandomAccessReader.class);
    protected RandomAccessFile raFile;
    protected IOSetting[] headerOptions = null;
    private final String filename;
    protected ISimpleChemObjectReader chemObjectReader;
    protected final int indexVersion = 1;
    protected long[][] index = null;
    protected int records;
    protected int currentRecord = 0;
    protected byte[] b;
    protected final IChemObjectBuilder builder;
    protected boolean indexCreated = false;

    public RandomAccessReader(File file, IChemObjectBuilder builder) throws IOException {
        this(file, builder, null);
    }

    public RandomAccessReader(File file, IChemObjectBuilder builder, IReaderListener listener) throws IOException {
        this.filename = file.getAbsolutePath();
        this.builder = builder;
        this.setChemObjectReader(this.createChemObjectReader());
        if (listener != null) {
            this.addChemObjectIOListener(listener);
        }
        this.raFile = new RandomAccessFile(file, "r");
        this.records = 0;
        this.setIndexCreated(false);
        this.indexTheFile();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception x) {
            logger.debug("Error during finalize");
        }
        super.finalize();
    }

    @Override
    public synchronized IChemObject readRecord(int record) throws Exception {
        String buffer = this.readContent(record);
        if (this.chemObjectReader == null) {
            throw new CDKException("No chemobject reader!");
        }
        this.chemObjectReader.setReader(new StringReader(buffer));
        this.currentRecord = record;
        return this.processContent();
    }

    protected String readContent(int record) throws IOException, CDKException {
        logger.debug("Current record ", record);
        if (record < 0 || record >= this.records) {
            throw new CDKException("No such record " + record);
        }
        this.raFile.seek(this.index[record][0]);
        int length = (int)this.index[record][1];
        this.raFile.read(this.b, 0, length);
        return new String(this.b, 0, length);
    }

    protected IChemObject processContent() throws CDKException {
        return this.chemObjectReader.read(this.builder.newInstance(IChemFile.class, new Object[0]));
    }

    protected long[][] resize(long[][] index, int newLength) {
        long[][] newIndex = new long[newLength][3];
        for (int i = 0; i < index.length; ++i) {
            newIndex[i][0] = index[i][0];
            newIndex[i][1] = index[i][1];
            newIndex[i][2] = index[i][2];
        }
        return newIndex;
    }

    protected abstract boolean isRecordEnd(String var1);

    protected synchronized void saveIndex(File file) throws Exception {
        if (this.records == 0) {
            if (!file.delete()) {
                LoggingToolFactory.createLoggingTool(RandomAccessReader.class).warn("Could not delete index file.");
            }
            return;
        }
        try (FileWriter out = new FileWriter(file);){
            out.write(Integer.toString(1));
            out.write(10);
            out.write(this.filename);
            out.write(10);
            out.write(Long.toString(this.raFile.length()));
            out.write(10);
            out.write(Integer.toString(this.records));
            out.write(10);
            for (int i = 0; i < this.records; ++i) {
                out.write(Long.toString(this.index[i][0]));
                out.write(9);
                out.write(Long.toString(this.index[i][1]));
                out.write(9);
                out.write(Long.toString(this.index[i][2]));
                out.write(10);
            }
            out.write(Integer.toString(this.records));
            out.write(10);
            out.write(this.filename);
            out.write(10);
        }
    }

    protected synchronized void loadIndex(File file) throws Exception {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String version2 = in.readLine();
            try {
                if (Integer.parseInt(version2) != 1) {
                    in.close();
                    throw new Exception("Expected index version 1 instead of " + version2);
                }
            }
            catch (Exception x) {
                in.close();
                throw new Exception("Invalid index version " + version2);
            }
            String fileIndexed = in.readLine();
            if (!this.filename.equals(fileIndexed)) {
                in.close();
                throw new Exception("Index for " + fileIndexed + " found instead of " + this.filename + ". Creating new index.");
            }
            String line = in.readLine();
            int fileLength = Integer.parseInt(line);
            if ((long)fileLength != this.raFile.length()) {
                in.close();
                throw new Exception("Index for file of size " + fileLength + " found instead of " + this.raFile.length());
            }
            line = in.readLine();
            int indexLength = Integer.parseInt(line);
            if (indexLength <= 0) {
                in.close();
                throw new Exception("Index of zero length! " + file.getAbsolutePath());
            }
            this.index = new long[indexLength][3];
            this.records = 0;
            int maxRecordLength = 0;
            for (int i = 0; i < this.index.length; ++i) {
                line = in.readLine();
                String[] result = line.split("\t");
                for (int j = 0; j < 3; ++j) {
                    try {
                        this.index[i][j] = Long.parseLong(result[j]);
                        continue;
                    }
                    catch (Exception x) {
                        in.close();
                        throw new Exception("Error reading index! " + result[j], x);
                    }
                }
                if ((long)maxRecordLength < this.index[this.records][1]) {
                    maxRecordLength = (int)this.index[this.records][1];
                }
                ++this.records;
            }
            line = in.readLine();
            int indexLength2 = Integer.parseInt(line);
            if (indexLength2 <= 0) {
                in.close();
                throw new Exception("Index of zero lenght!");
            }
            if (indexLength2 != indexLength) {
                in.close();
                throw new Exception("Wrong index length!");
            }
            line = in.readLine();
            if (!line.equals(this.filename)) {
                in.close();
                throw new Exception("Index for " + line + " found instead of " + this.filename);
            }
            this.b = new byte[maxRecordLength];
        }
    }

    protected synchronized void makeIndex() throws Exception {
        String s;
        File indexFile = RandomAccessReader.getIndexFile(this.filename);
        if (indexFile.exists()) {
            try {
                this.loadIndex(indexFile);
                this.setIndexCreated(true);
                return;
            }
            catch (Exception x) {
                logger.warn(x.getMessage());
            }
        }
        this.indexCreated = false;
        long now2 = System.currentTimeMillis();
        int recordLength = 1000;
        int maxRecordLength = 0;
        int maxRecords = (int)this.raFile.length() / recordLength;
        if (maxRecords == 0) {
            maxRecords = 1;
        }
        this.index = new long[maxRecords][3];
        long start = 0L;
        long end = 0L;
        this.raFile.seek(0L);
        this.records = 0;
        recordLength = 0;
        while ((s = this.raFile.readLine()) != null) {
            if (start == -1L) {
                start = this.raFile.getFilePointer();
            }
            if (this.isRecordEnd(s)) {
                if (this.records >= maxRecords) {
                    maxRecords = recordLength == 0 ? maxRecords + maxRecords >>> 1 : this.records + (int)((long)this.records + (this.raFile.length() - (long)this.records * this.raFile.getFilePointer()) / (long)recordLength);
                    this.index = this.resize(this.index, maxRecords);
                }
                this.index[this.records][0] = start;
                this.index[this.records][1] = (end += 4L) - start;
                this.index[this.records][2] = -1L;
                if ((long)maxRecordLength < this.index[this.records][1]) {
                    maxRecordLength = (int)this.index[this.records][1];
                }
                ++this.records;
                recordLength = (int)((long)recordLength + (end - start));
                start = this.raFile.getFilePointer();
                continue;
            }
            end = this.raFile.getFilePointer();
        }
        this.b = new byte[maxRecordLength];
        logger.info("Index created in " + (System.currentTimeMillis() - now2) + " ms.");
        try {
            this.saveIndex(indexFile);
        }
        catch (Exception x) {
            logger.error(x);
        }
    }

    public static File getIndexFile(String filename) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File f = new File(filename);
        File indexFile = new File(tmpDir, f.getName() + "_cdk.index");
        f = null;
        return indexFile;
    }

    public void close() throws IOException {
        this.raFile.close();
    }

    public synchronized IChemObjectReader getChemObjectReader() {
        return this.chemObjectReader;
    }

    public abstract ISimpleChemObjectReader createChemObjectReader();

    public synchronized void setChemObjectReader(ISimpleChemObjectReader chemObjectReader) {
        this.chemObjectReader = chemObjectReader;
    }

    @Override
    public boolean hasNext() {
        return this.currentRecord < this.records - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentRecord > 0;
    }

    @Override
    public IChemObject first() {
        try {
            return this.readRecord(0);
        }
        catch (Exception x) {
            logger.error(x);
            return null;
        }
    }

    @Override
    public IChemObject last() {
        try {
            return this.readRecord(this.records - 1);
        }
        catch (Exception x) {
            logger.error(x);
            return null;
        }
    }

    @Override
    public IChemObject next() {
        try {
            return this.readRecord(this.currentRecord + 1);
        }
        catch (Exception x) {
            logger.error(x);
            throw new NoSuchElementException();
        }
    }

    @Override
    public IChemObject previous() {
        try {
            return this.readRecord(this.currentRecord - 1);
        }
        catch (Exception x) {
            logger.error(x);
            return null;
        }
    }

    @Override
    public void set(IChemObject arg0) {
    }

    @Override
    public void add(IChemObject arg0) {
    }

    @Override
    public int previousIndex() {
        return this.currentRecord - 1;
    }

    @Override
    public int nextIndex() {
        return this.currentRecord + 1;
    }

    @Override
    public int size() {
        return this.records;
    }

    @Override
    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        super.addChemObjectIOListener(listener);
        if (this.chemObjectReader != null) {
            this.chemObjectReader.addChemObjectIOListener(listener);
        }
    }

    @Override
    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        super.removeChemObjectIOListener(listener);
        if (this.chemObjectReader != null) {
            this.chemObjectReader.removeChemObjectIOListener(listener);
        }
    }

    public synchronized int getCurrentRecord() {
        return this.currentRecord;
    }

    public synchronized boolean isIndexCreated() {
        return this.indexCreated;
    }

    public synchronized void setIndexCreated(boolean indexCreated) {
        this.indexCreated = indexCreated;
        this.notifyAll();
    }

    private void indexTheFile() {
        try {
            this.setIndexCreated(false);
            this.makeIndex();
            this.currentRecord = 0;
            this.raFile.seek(this.index[0][0]);
            this.setIndexCreated(true);
        }
        catch (Exception x) {
            this.setIndexCreated(true);
        }
    }

    public String toString() {
        return this.filename;
    }
}

