/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Arrays;
import java.util.function.Predicate;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;

final class ComponentFilter
implements Predicate<int[]> {
    public static final String KEY = "COMPONENT.GROUPING";
    private final int[] queryComponents;
    private final int[] targetComponents;

    public ComponentFilter(IAtomContainer query, IAtomContainer target) {
        this(query.getProperty(KEY) == null ? ComponentFilter.determineComponents(query, false) : query.getProperty(KEY, int[].class), ComponentFilter.determineComponents(target, true));
    }

    private static int[] determineComponents(IAtomContainer target, boolean auto) {
        int max2;
        int[] components = null;
        if (target.isEmpty()) {
            components = new int[]{};
        }
        if (components == null && target.getAtom(0).getProperty("cdk:ReactionGroup") != null) {
            max2 = 0;
            components = new int[target.getAtomCount() + 1];
            for (int i = 0; i < target.getAtomCount(); ++i) {
                Integer grp = (Integer)target.getAtom(i).getProperty("cdk:ReactionGroup");
                if (grp == null) {
                    grp = 0;
                }
                components[i] = grp;
                if (grp <= max2) continue;
                max2 = grp;
            }
            components[target.getAtomCount()] = max2;
        }
        if (components == null && auto) {
            components = new ConnectedComponents(GraphUtil.toAdjList(target)).components();
            components = Arrays.copyOf(components, components.length + 1);
            max2 = 0;
            for (int grp : components) {
                if (grp <= max2) continue;
                max2 = grp;
            }
            components[target.getAtomCount()] = max2;
        }
        return components;
    }

    public ComponentFilter(int[] grouping, int[] targetComponents) {
        this.queryComponents = grouping;
        this.targetComponents = targetComponents;
    }

    @Override
    public boolean test(int[] mapping) {
        if (this.queryComponents == null) {
            return true;
        }
        int[] usedBy = new int[this.targetComponents[this.targetComponents.length - 1] + 1];
        int[] usedIn = new int[this.queryComponents[this.queryComponents.length - 1] + 1];
        for (int v = 0; v < mapping.length; ++v) {
            if (this.queryComponents[v] == 0) continue;
            int w = mapping[v];
            int queryComponent = this.queryComponents[v];
            int targetComponent = this.targetComponents[w];
            if (usedBy[targetComponent] == 0) {
                usedBy[targetComponent] = queryComponent;
            } else if (usedBy[targetComponent] != queryComponent) {
                return false;
            }
            if (usedIn[queryComponent] == 0) {
                usedIn[queryComponent] = targetComponent;
                continue;
            }
            if (usedIn[queryComponent] == targetComponent) continue;
            return false;
        }
        return true;
    }

    public boolean apply(int[] ints) {
        return this.test(ints);
    }
}

