/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.isomorphism.AtomMapFilter;
import org.openscience.cdk.isomorphism.ComponentFilter;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.QueryStereoFilter;
import org.openscience.cdk.isomorphism.StereoMatch;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

public abstract class Pattern {
    private boolean hasStereo;
    private boolean hasQueryStereo;
    private boolean hasCompGrp;
    private boolean hasRxnMap;

    void determineFilters(IAtomContainer query) {
        this.hasStereo = query.stereoElements().iterator().hasNext();
        this.hasCompGrp = query.getProperty("COMPONENT.GROUPING") != null;
        for (IAtom atom : query.atoms()) {
            Integer compId = (Integer)atom.getProperty("cdk:ReactionGroup");
            Integer mapIdx = (Integer)atom.getProperty("cdk:AtomAtomMapping");
            if (mapIdx != null && mapIdx != 0) {
                this.hasRxnMap = true;
            }
            if (compId != null && compId != 0) {
                this.hasCompGrp = true;
            }
            if (atom instanceof IQueryAtom) {
                this.hasQueryStereo = true;
            }
            if (!this.hasRxnMap || !this.hasCompGrp || !this.hasQueryStereo) continue;
            break;
        }
    }

    Mappings filter(Mappings mappings, IAtomContainer query, IAtomContainer target) {
        if (this.hasStereo) {
            Mappings mappings2 = mappings = this.hasQueryStereo ? mappings.filter(new QueryStereoFilter(query, target)) : mappings.filter(new StereoMatch(query, target));
        }
        if (this.hasCompGrp) {
            mappings = mappings.filter(new ComponentFilter(query, target));
        }
        if (this.hasRxnMap) {
            mappings = mappings.filter(new AtomMapFilter(query, target));
        }
        return mappings;
    }

    public abstract int[] match(IAtomContainer var1);

    public boolean matches(IAtomContainer target) {
        return this.match(target).length > 0;
    }

    public final boolean matches(IReaction target) {
        return this.matches(ReactionManipulator.toMolecule(target));
    }

    public abstract Mappings matchAll(IAtomContainer var1);

    public final Mappings matchAll(IReaction target) {
        return this.matchAll(ReactionManipulator.toMolecule(target));
    }

    public static Pattern findSubstructure(IAtomContainer query) {
        return VentoFoggia.findSubstructure(query);
    }

    public static Pattern findIdentical(IAtomContainer query) {
        return VentoFoggia.findIdentical(query);
    }
}

