/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IRGroup;
import org.openscience.cdk.isomorphism.matchers.IRGroupList;
import org.openscience.cdk.isomorphism.matchers.IRGroupQuery;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class RGroupQuery
extends QueryChemObject
implements IChemObject,
IRGroupQuery {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RGroupQuery.class);
    private IAtomContainer rootStructure;
    private Map<Integer, IRGroupList> rGroupDefinitions;
    private Map<IAtom, Map<Integer, IBond>> rootAttachmentPoints;
    private static final Pattern validLabelPattern = Pattern.compile("^R\\d+$");

    public RGroupQuery(IChemObjectBuilder builder) {
        super(builder);
    }

    public List<IAtom> getRgroupQueryAtoms(Integer rgroupNumber) {
        ArrayList<IAtom> rGroupQueryAtoms = null;
        if (this.rootStructure != null) {
            rGroupQueryAtoms = new ArrayList<IAtom>();
            for (int i = 0; i < this.rootStructure.getAtomCount(); ++i) {
                IPseudoAtom rGroup;
                IAtom atom = this.rootStructure.getAtom(i);
                if (!(atom instanceof IPseudoAtom) || (rGroup = (IPseudoAtom)atom).getLabel().equals("R") || !rGroup.getLabel().startsWith("R") || rgroupNumber != null && !Integer.valueOf(rGroup.getLabel().substring(1)).equals(rgroupNumber)) continue;
                rGroupQueryAtoms.add(atom);
            }
        }
        return rGroupQueryAtoms;
    }

    public List<IAtom> getAllRgroupQueryAtoms() {
        return this.getRgroupQueryAtoms(null);
    }

    public static boolean isValidRgroupQueryLabel(String Rxx) {
        int groupNumber;
        Matcher matcher = validLabelPattern.matcher(Rxx);
        return matcher.find() && (groupNumber = Integer.parseInt(Rxx.substring(1))) >= 1 && groupNumber <= 32;
    }

    @Override
    public boolean areSubstituentsDefined() {
        List<IAtom> allRgroupAtoms = this.getAllRgroupQueryAtoms();
        if (allRgroupAtoms == null) {
            return false;
        }
        for (IAtom rgp : allRgroupAtoms) {
            if (!RGroupQuery.isValidRgroupQueryLabel(((IPseudoAtom)rgp).getLabel())) continue;
            int groupNum = Integer.parseInt(((IPseudoAtom)rgp).getLabel().substring(1));
            if (this.rGroupDefinitions != null && this.rGroupDefinitions.get(groupNum) != null && this.rGroupDefinitions.get(groupNum).getRGroups() != null && this.rGroupDefinitions.get(groupNum).getRGroups().size() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areRootAtomsDefined() {
        for (Integer rgpNum : this.rGroupDefinitions.keySet()) {
            boolean represented = false;
            for (IAtom rootAtom : this.getRootStructure().atoms()) {
                int rootAtomRgrpNumber;
                IPseudoAtom pseudo;
                if (!(rootAtom instanceof IPseudoAtom) || !rootAtom.getSymbol().startsWith("R") || (pseudo = (IPseudoAtom)rootAtom).getLabel().length() <= 1 || (rootAtomRgrpNumber = Integer.parseInt(pseudo.getLabel().substring(1))) != rgpNum) continue;
                represented = true;
                break;
            }
            if (represented) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IAtomContainer> getAllConfigurations() throws CDKException {
        if (!this.areSubstituentsDefined()) {
            throw new CDKException("Can not configure molecules: missing R# group definitions.");
        }
        ArrayList<IAtomContainer> result = new ArrayList<IAtomContainer>();
        ArrayList<Integer> rGroupNumbers = new ArrayList<Integer>();
        ArrayList<Integer[]> distributions = new ArrayList<Integer[]>();
        ArrayList<List<IRGroup>> substitutes = new ArrayList<List<IRGroup>>();
        ArrayList<List<Integer>> occurrences = new ArrayList<List<Integer>>();
        ArrayList<Integer> occurIndexes = new ArrayList<Integer>();
        Iterator<Integer> rGroupNumItr = this.rGroupDefinitions.keySet().iterator();
        if (rGroupNumItr.hasNext()) {
            while (rGroupNumItr.hasNext()) {
                int r = rGroupNumItr.next();
                rGroupNumbers.add(r);
                List<Integer> validOcc = this.rGroupDefinitions.get(r).matchOccurence(this.getRgroupQueryAtoms(r).size());
                if (validOcc.size() == 0) {
                    throw new CDKException("Occurrence '" + this.rGroupDefinitions.get(r).getOccurrence() + "' defined for Rgroup " + r + " results in no subsititute options for this R-group.");
                }
                occurrences.add(validOcc);
                occurIndexes.add(0);
            }
            for (int i = 0; i < rGroupNumbers.size(); ++i) {
                distributions.add(null);
                substitutes.add(null);
            }
            this.findConfigurationsRecursively(rGroupNumbers, occurrences, occurIndexes, distributions, substitutes, 0, result);
        }
        return result;
    }

    private void findConfigurationsRecursively(List<Integer> rGroupNumbers, List<List<Integer>> occurrences, List<Integer> occurIndexes, List<Integer[]> distributions, List<List<IRGroup>> substitutes, int level, List<IAtomContainer> result) throws CDKException {
        if (level == rGroupNumbers.size()) {
            IAtomContainer rootClone;
            if (!this.checkIfThenConditionsMet(rGroupNumbers, distributions)) {
                return;
            }
            IAtomContainer root2 = this.getRootStructure();
            try {
                rootClone = root2.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new CDKException("clone() failed; could not perform R-group substitution.");
            }
            for (int rgpIdx = 0; rgpIdx < rGroupNumbers.size(); ++rgpIdx) {
                int rNum = rGroupNumbers.get(rgpIdx);
                int pos = 0;
                List<IRGroup> mapped = substitutes.get(rgpIdx);
                for (IRGroup substitute : mapped) {
                    IAtom rAtom = this.getRgroupQueryAtoms(rNum).get(pos);
                    if (substitute != null) {
                        IAtomContainer rgrpClone;
                        try {
                            rgrpClone = substitute.getGroup().clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            throw new CDKException("clone() failed; could not perform R-group substitution.");
                        }
                        rootClone.add(rgrpClone);
                        Map<Integer, IBond> map = this.getRootAttachmentPoints().get(rAtom);
                        if (map != null) {
                            for (int apo = 0; apo < map.size(); ++apo) {
                                IBond bond = map.get(apo + 1);
                                int whichAtomInBond = 0;
                                if (bond.getEnd().equals(rAtom)) {
                                    whichAtomInBond = 1;
                                }
                                IAtom subsAt = apo == 0 ? substitute.getFirstAttachmentPoint() : substitute.getSecondAttachmentPoint();
                                IBond cloneBond = rootClone.getBond(this.getBondPosition(bond, root2));
                                if (subsAt == null) continue;
                                IAtom subsCloneAtom = rgrpClone.getAtom(this.getAtomPosition(subsAt, substitute.getGroup()));
                                cloneBond.setAtom(subsCloneAtom, whichAtomInBond);
                            }
                        }
                        if (rAtom.getPoint2d() != null && substitute != null && substitute.getFirstAttachmentPoint() != null && substitute.getFirstAttachmentPoint().getPoint2d() != null) {
                            Point2d pointR = rAtom.getPoint2d();
                            Point2d pointC = substitute.getFirstAttachmentPoint().getPoint2d();
                            double xDiff = pointC.x - pointR.x;
                            double yDiff = pointC.y - pointR.y;
                            for (IAtom subAt : rgrpClone.atoms()) {
                                if (subAt.getPoint2d() == null) continue;
                                subAt.getPoint2d().x -= xDiff;
                                subAt.getPoint2d().y -= yDiff;
                            }
                        }
                    } else {
                        IAtom discarded = rootClone.getAtom(this.getAtomPosition(rAtom, root2));
                        for (IBond r0Bond : rootClone.bonds()) {
                            if (!r0Bond.contains(discarded)) continue;
                            for (IAtom atInBond : r0Bond.atoms()) {
                                atInBond.setProperty("cdk:RestH", this.getRGroupDefinitions().get(rNum).isRestH());
                            }
                        }
                    }
                    ++pos;
                }
            }
            boolean confHasRGroupBonds = true;
            block10: while (confHasRGroupBonds) {
                for (IBond cloneBond : rootClone.bonds()) {
                    boolean removeBond = false;
                    if (cloneBond.getBegin() instanceof IPseudoAtom && RGroupQuery.isValidRgroupQueryLabel(((IPseudoAtom)cloneBond.getBegin()).getLabel())) {
                        removeBond = true;
                    } else if (cloneBond.getEnd() instanceof IPseudoAtom && RGroupQuery.isValidRgroupQueryLabel(((IPseudoAtom)cloneBond.getEnd()).getLabel())) {
                        removeBond = true;
                    }
                    if (removeBond) {
                        rootClone.removeBond(cloneBond);
                        confHasRGroupBonds = true;
                        continue block10;
                    }
                    confHasRGroupBonds = false;
                }
            }
            boolean confHasRGroupAtoms = true;
            block12: while (confHasRGroupAtoms) {
                for (IAtom cloneAt : rootClone.atoms()) {
                    if (cloneAt instanceof IPseudoAtom && RGroupQuery.isValidRgroupQueryLabel(((IPseudoAtom)cloneAt).getLabel())) {
                        rootClone.removeAtomOnly(cloneAt);
                        confHasRGroupAtoms = true;
                        continue block12;
                    }
                    confHasRGroupAtoms = false;
                }
            }
            result.add(rootClone);
        } else {
            for (int idx = 0; idx < occurrences.get(level).size(); ++idx) {
                occurIndexes.set(level, idx);
                int occurrence = occurrences.get(level).get(idx);
                int positions = this.getRgroupQueryAtoms(rGroupNumbers.get(level)).size();
                Integer[] candidate = new Integer[positions];
                for (int j = 0; j < candidate.length; ++j) {
                    candidate[j] = 0;
                }
                ArrayList<Integer[]> rgrpDistributions = new ArrayList<Integer[]>();
                this.findDistributions(occurrence, candidate, rgrpDistributions, 0);
                for (Integer[] distribution : rgrpDistributions) {
                    distributions.set(level, distribution);
                    IRGroup[] mapping = new IRGroup[distribution.length];
                    ArrayList<List<IRGroup>> mappedSubstitutes = new ArrayList<List<IRGroup>>();
                    this.mapSubstitutes(this.getRGroupDefinitions().get(rGroupNumbers.get(level)), 0, distribution, mapping, mappedSubstitutes);
                    for (List list : mappedSubstitutes) {
                        substitutes.set(level, list);
                        this.findConfigurationsRecursively(rGroupNumbers, occurrences, occurIndexes, distributions, substitutes, level + 1, result);
                    }
                }
            }
        }
    }

    private void findDistributions(int occur, Integer[] candidate, List<Integer[]> distributions, int level) {
        if (level != candidate.length) {
            for (int i = 0; i < 2; ++i) {
                candidate[level] = i;
                int sum = 0;
                for (Integer integer : candidate) {
                    sum += integer.intValue();
                }
                if (sum == occur) {
                    distributions.add((Integer[])candidate.clone());
                    continue;
                }
                this.findDistributions(occur, candidate, distributions, level + 1);
            }
        }
    }

    private void mapSubstitutes(IRGroupList rgpList, int listOffset, Integer[] distribution, IRGroup[] mapping, List<List<IRGroup>> result) {
        if (listOffset == distribution.length) {
            ArrayList<IRGroup> mapped = new ArrayList<IRGroup>();
            for (IRGroup rgrp : mapping) {
                mapped.add(rgrp);
            }
            result.add(mapped);
        } else if (distribution[listOffset] == 0) {
            mapping[listOffset] = null;
            this.mapSubstitutes(rgpList, listOffset + 1, distribution, mapping, result);
        } else {
            Iterator<IRGroup> iterator = rgpList.getRGroups().iterator();
            while (iterator.hasNext()) {
                IRGroup rgrp;
                mapping[listOffset] = rgrp = iterator.next();
                this.mapSubstitutes(rgpList, listOffset + 1, distribution, mapping, result);
            }
        }
    }

    private int getAtomPosition(IAtom atom, IAtomContainer container2) {
        for (int i = 0; i < container2.getAtomCount(); ++i) {
            if (!atom.equals(container2.getAtom(i))) continue;
            return i;
        }
        return -1;
    }

    private int getBondPosition(IBond bond, IAtomContainer container2) {
        for (int i = 0; i < container2.getBondCount(); ++i) {
            if (!bond.equals(container2.getBond(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean allZeroArray(Integer[] arr) {
        Integer[] integerArray = arr;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int flag = integerArray[i];
            if (flag == 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfThenConditionsMet(List<Integer> rGroupNumbers, List<Integer[]> distributions) {
        for (int outer = 0; outer < rGroupNumbers.size(); ++outer) {
            int rgroupNum = rGroupNumbers.get(outer);
            if (!this.allZeroArray(distributions.get(outer))) continue;
            for (int inner = 0; inner < rGroupNumbers.size(); ++inner) {
                IRGroupList rgrpList;
                int rgroupNum2 = rGroupNumbers.get(inner);
                if (this.allZeroArray(distributions.get(inner)) || (rgrpList = this.rGroupDefinitions.get(rgroupNum2)).getRequiredRGroupNumber() != rgroupNum) continue;
                logger.info(" Rejecting >> all 0 for " + rgroupNum + " but requirement found from " + rgrpList.getRGroupNumber());
                return false;
            }
        }
        return true;
    }

    @Override
    public int getAtomContainerCount() {
        int retVal = 0;
        if (this.rootStructure != null) {
            ++retVal;
        }
        for (Integer r : this.rGroupDefinitions.keySet()) {
            for (IRGroup rgrp : this.rGroupDefinitions.get(r).getRGroups()) {
                if (rgrp.getGroup() == null) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    @Override
    public List<IAtomContainer> getSubstituents() {
        ArrayList<IAtomContainer> substitutes = new ArrayList<IAtomContainer>();
        for (Integer r : this.rGroupDefinitions.keySet()) {
            for (IRGroup rgrp : this.rGroupDefinitions.get(r).getRGroups()) {
                IAtomContainer subst = rgrp.getGroup();
                if (subst == null) continue;
                substitutes.add(subst);
            }
        }
        return substitutes;
    }

    @Override
    public void setRootStructure(IAtomContainer rootStructure) {
        this.rootStructure = rootStructure;
    }

    @Override
    public IAtomContainer getRootStructure() {
        return this.rootStructure;
    }

    @Override
    public void setRootAttachmentPoints(Map<IAtom, Map<Integer, IBond>> rootAttachmentPoints) {
        this.rootAttachmentPoints = rootAttachmentPoints;
    }

    @Override
    public Map<IAtom, Map<Integer, IBond>> getRootAttachmentPoints() {
        return this.rootAttachmentPoints;
    }

    @Override
    public void setRGroupDefinitions(Map<Integer, IRGroupList> rGroupDefinitions) {
        this.rGroupDefinitions = rGroupDefinitions;
    }

    @Override
    public Map<Integer, IRGroupList> getRGroupDefinitions() {
        return this.rGroupDefinitions;
    }
}

