/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class HydrogenPlacer {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(HydrogenPlacer.class);

    public void placeHydrogens2D(IAtomContainer container2, double bondLength) {
        logger.debug("placing hydrogens on all atoms");
        for (IAtom atom : container2.atoms()) {
            if (atom.getPoint2d() == null) continue;
            this.placeHydrogens2D(container2, atom, bondLength);
        }
        logger.debug("hydrogen placement complete");
    }

    public void placeHydrogens2D(IAtomContainer container2, IAtom atom) {
        double bondLength = GeometryUtil.getBondLengthAverage(container2);
        this.placeHydrogens2D(container2, atom, bondLength);
    }

    public void placeHydrogens2D(IAtomContainer container2, IAtom atom, double bondLength) {
        if (container2 == null) {
            throw new IllegalArgumentException("cannot place hydrogens, no container provided");
        }
        if (atom.getPoint2d() == null) {
            throw new IllegalArgumentException("cannot place hydrogens on atom without coordinates");
        }
        logger.debug("placing hydrogens connected to atom ", atom.getSymbol(), ": ", atom.getPoint2d());
        logger.debug("bond length", bondLength);
        AtomPlacer atomPlacer = new AtomPlacer();
        atomPlacer.setMolecule(container2);
        List<IAtom> connected = container2.getConnectedAtomsList(atom);
        IAtomContainer placed = container2.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer unplaced = container2.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom conAtom : connected) {
            if (conAtom.getPoint2d() == null) {
                if (conAtom.getAtomicNumber() == 1) {
                    unplaced.addAtom(conAtom);
                    continue;
                }
                throw new IllegalArgumentException("cannot place hydrogens, atom has connected non-hydrogens without coordinates");
            }
            placed.addAtom(conAtom);
        }
        logger.debug("Atom placement before procedure:");
        logger.debug("Centre atom ", atom.getSymbol(), ": ", atom.getPoint2d());
        for (int i = 0; i < unplaced.getAtomCount(); ++i) {
            logger.debug("H-" + i, ": ", unplaced.getAtom(i).getPoint2d());
        }
        Point2d centerPlacedAtoms = GeometryUtil.get2DCenter(placed);
        atomPlacer.distributePartners(atom, placed, centerPlacedAtoms, unplaced, bondLength);
        logger.debug("Atom placement after procedure:");
        logger.debug("Centre atom ", atom.getSymbol(), ": ", atom.getPoint2d());
        for (int i = 0; i < unplaced.getAtomCount(); ++i) {
            logger.debug("H-" + i, ": ", unplaced.getAtom(i).getPoint2d());
        }
    }
}

