/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import java.text.DecimalFormat;
import org.openscience.cdk.math.Vector;

public class Matrix {
    public final double[][] matrix;
    public final int rows;
    public int columns;

    public Matrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.matrix = new double[rows][columns];
    }

    public Matrix(double[][] array) {
        int i;
        this.rows = array.length;
        this.columns = array[0].length;
        for (i = 1; i < this.rows; ++i) {
            this.columns = Math.min(this.columns, array[i].length);
        }
        this.matrix = new double[this.rows][this.columns];
        for (i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = array[i][j];
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public Vector getVectorFromRow(int index) {
        double[] row = new double[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            row[i] = this.matrix[index][i];
        }
        return new Vector(row);
    }

    public Vector getVectorFromColumn(int index) {
        double[] column = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            column[i] = this.matrix[i][index];
        }
        return new Vector(column);
    }

    public Vector getVectorFromDiagonal() {
        int size = Math.min(this.rows, this.columns);
        Vector result = new Vector(size);
        for (int i = 0; i < this.rows; ++i) {
            result.vector[i] = this.matrix[i][i];
        }
        return result;
    }

    public Matrix add(Matrix b) {
        if (b == null || this.rows != b.rows || this.columns != b.columns) {
            return null;
        }
        Matrix result = new Matrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[i][j] = this.matrix[i][j] + b.matrix[i][j];
            }
        }
        return result;
    }

    public Matrix sub(Matrix b) {
        if (b == null || this.rows != b.rows || this.columns != b.columns) {
            return null;
        }
        Matrix result = new Matrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[i][j] = this.matrix[i][j] - b.matrix[i][j];
            }
        }
        return result;
    }

    public Matrix mul(Matrix b) {
        if (b == null || this.columns != b.rows) {
            return null;
        }
        Matrix result = new Matrix(this.rows, b.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int k = 0; k < b.columns; ++k) {
                double sum = 0.0;
                for (int j = 0; j < this.columns; ++j) {
                    sum += this.matrix[i][j] * b.matrix[j][k];
                }
                result.matrix[i][k] = sum;
            }
        }
        return result;
    }

    public Vector mul(Vector a) {
        if (a == null || this.columns != a.size) {
            return null;
        }
        Vector result = new Vector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                sum += this.matrix[i][j] * a.vector[j];
            }
            result.vector[i] = sum;
        }
        return result;
    }

    public Matrix mul(double a) {
        Matrix result = new Matrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[i][j] = this.matrix[i][j] * a;
            }
        }
        return result;
    }

    public Matrix duplicate() {
        Matrix result = new Matrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[i][j] = this.matrix[i][j];
            }
        }
        return result;
    }

    public Matrix transpose() {
        Matrix result = new Matrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[j][i] = this.matrix[i][j];
            }
        }
        return result;
    }

    public Matrix similar(Matrix U) {
        Matrix result = new Matrix(U.columns, U.columns);
        for (int i = 0; i < U.columns; ++i) {
            for (int j = 0; j < U.columns; ++j) {
                double sum = 0.0;
                for (int k = 0; k < U.columns; ++k) {
                    double innersum = 0.0;
                    for (int l = 0; l < U.columns; ++l) {
                        innersum += this.matrix[k][l] * U.matrix[l][j];
                    }
                    sum += U.matrix[k][i] * innersum;
                }
                result.matrix[i][j] = sum;
            }
        }
        return result;
    }

    public double contraction() {
        double result = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result += this.matrix[i][j];
            }
        }
        return result;
    }

    public String toString() {
        int j;
        if (this.rows <= 0 || this.columns <= 0) {
            return "[]";
        }
        DecimalFormat format = new DecimalFormat("00.0000");
        format.setPositivePrefix("+");
        StringBuilder str2 = new StringBuilder();
        for (int i = 0; i < this.rows - 1; ++i) {
            for (j = 0; j < this.columns - 1; ++j) {
                if (Math.round(this.matrix[i][j] * 10000.0) != 0L) {
                    str2.append(format.format(this.matrix[i][j]) + " ");
                    continue;
                }
                str2.append("-------- ");
            }
            if (Math.round(this.matrix[i][this.columns - 1] * 10000.0) != 0L) {
                str2.append(format.format(this.matrix[i][this.columns - 1]) + "\n");
                continue;
            }
            str2.append("--------\n");
        }
        for (j = 0; j < this.columns - 1; ++j) {
            if (Math.round(this.matrix[this.rows - 1][j] * 10000.0) != 0L) {
                str2.append(format.format(this.matrix[this.rows - 1][j]) + " ");
                continue;
            }
            str2.append("-------- ");
        }
        if (Math.round(this.matrix[this.rows - 1][this.columns - 1] * 10000.0) != 0L) {
            str2.append(format.format(this.matrix[this.rows - 1][this.columns - 1]));
        } else {
            str2.append("-------- ");
        }
        return str2.toString();
    }

    public Matrix diagonalize(int maxNumRot) {
        int iq;
        int ip;
        Matrix m = this.duplicate();
        if (m.rows != m.columns) {
            System.err.println("Matrix.diagonal: Sizes mismatched");
            return null;
        }
        int n = m.rows;
        Matrix v = new Matrix(this.columns, this.columns);
        Vector d = new Vector(this.columns);
        double[] b = new double[n + 1];
        double[] z = new double[n + 1];
        for (ip = 0; ip < n; ++ip) {
            for (iq = 0; iq < n; ++iq) {
                v.matrix[ip][iq] = 0.0;
            }
            v.matrix[ip][ip] = 1.0;
        }
        for (ip = 0; ip < n; ++ip) {
            b[ip] = d.vector[ip] = m.matrix[ip][ip];
            z[ip] = 0.0;
        }
        int nrot = 0;
        for (int i = 1; i <= 50; ++i) {
            double sm = 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    sm += Math.abs(m.matrix[ip][iq]);
                }
            }
            if (sm == 0.0) {
                return v;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            if (nrot > maxNumRot) break;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(m.matrix[ip][iq]);
                    if (i > 4 && Math.abs(d.vector[ip]) + g == Math.abs(d.vector[ip]) && Math.abs(d.vector[iq]) + g == Math.abs(d.vector[iq])) {
                        m.matrix[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(m.matrix[ip][iq]) > tresh)) continue;
                    double h = d.vector[iq] - d.vector[ip];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = m.matrix[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / m.matrix[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * m.matrix[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    int n4 = ip;
                    d.vector[n4] = d.vector[n4] - h;
                    int n5 = iq;
                    d.vector[n5] = d.vector[n5] + h;
                    m.matrix[ip][iq] = 0.0;
                    for (j = 0; j < ip; ++j) {
                        g = m.matrix[j][ip];
                        h = m.matrix[j][iq];
                        m.matrix[j][ip] = g - s * (h + g * tau);
                        m.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = ip + 1; j < iq; ++j) {
                        g = m.matrix[ip][j];
                        h = m.matrix[j][iq];
                        m.matrix[ip][j] = g - s * (h + g * tau);
                        m.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = iq + 1; j < n; ++j) {
                        g = m.matrix[ip][j];
                        h = m.matrix[iq][j];
                        m.matrix[ip][j] = g - s * (h + g * tau);
                        m.matrix[iq][j] = h + s * (g - h * tau);
                    }
                    for (j = 0; j < n; ++j) {
                        g = v.matrix[j][ip];
                        h = v.matrix[j][iq];
                        v.matrix[j][ip] = g - s * (h + g * tau);
                        v.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    ++nrot;
                }
            }
            for (ip = 0; ip < n; ++ip) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d.vector[ip] = b[ip];
                z[ip] = 0.0;
            }
        }
        System.out.println("Too many iterations in routine JACOBI");
        return v;
    }

    public static Vector elimination(Matrix matrix, Vector vector) {
        int k;
        int j;
        int n = vector.size;
        int[] pivot = new int[n];
        Vector result = new Vector(n);
        Matrix a = matrix.duplicate();
        Vector b = vector.duplicate();
        for (j = 0; j < n - 1; ++j) {
            int i;
            double c = Math.abs(a.matrix[j][j]);
            pivot[j] = j;
            int ipvt = j;
            for (i = j + 1; i < n; ++i) {
                if (!(Math.abs(a.matrix[i][j]) > c)) continue;
                c = Math.abs(a.matrix[i][j]);
                ipvt = i;
            }
            if (pivot[j] != ipvt) {
                double temp;
                pivot[j] = ipvt;
                pivot[ipvt] = j;
                for (k = 0; k < n; ++k) {
                    temp = a.matrix[j][k];
                    a.matrix[j][k] = a.matrix[pivot[j]][k];
                    a.matrix[pivot[j]][k] = temp;
                }
                temp = b.vector[j];
                b.vector[j] = b.vector[pivot[j]];
                b.vector[pivot[j]] = temp;
            }
            for (i = j + 1; i < n; ++i) {
                a.matrix[i][j] = a.matrix[i][j] / a.matrix[j][j];
            }
            for (i = j + 1; i < n; ++i) {
                for (k = j + 1; k < n; ++k) {
                    a.matrix[i][k] = a.matrix[i][k] - a.matrix[i][j] * a.matrix[j][k];
                }
                b.vector[i] = b.vector[i] - a.matrix[i][j] * b.vector[j];
                a.matrix[i][j] = 0.0;
            }
        }
        result.vector[n - 1] = b.vector[n - 1] / a.matrix[n - 1][n - 1];
        for (j = n - 2; j >= 0; --j) {
            result.vector[j] = b.vector[j];
            for (k = n - 1; k > j; --k) {
                result.vector[j] = result.vector[j] - result.vector[k] * a.matrix[j][k];
            }
            result.vector[j] = result.vector[j] / a.matrix[j][j];
        }
        return result;
    }

    public Matrix orthonormalize(Matrix S) {
        Matrix result = this.duplicate();
        for (int p = 0; p < this.columns; ++p) {
            int q;
            int j;
            double length;
            int i;
            for (i = 0; i < this.rows; ++i) {
                result.matrix[i][p] = this.matrix[i][p];
            }
            for (int k = 0; k < p; ++k) {
                length = 0.0;
                for (i = 0; i < this.rows; ++i) {
                    double innersum = 0.0;
                    for (j = 0; j < this.rows; ++j) {
                        innersum += result.matrix[j][p] * S.matrix[i][j];
                    }
                    length += result.matrix[i][k] * innersum;
                }
                for (q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] - result.matrix[q][k] * length;
                }
            }
            length = 0.0;
            for (i = 0; i < this.rows; ++i) {
                for (j = 0; j < this.rows; ++j) {
                    length += result.matrix[i][p] * result.matrix[j][p] * S.matrix[i][j];
                }
            }
            if ((length = Math.sqrt(length)) != 0.0) {
                for (q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] / length;
                }
                continue;
            }
            System.out.println("Warning(orthonormalize):" + (p + 1) + ". Vector has length null");
        }
        return result;
    }

    public Matrix normalize(Matrix S) {
        Matrix result = this.duplicate();
        for (int p = 0; p < this.columns; ++p) {
            double length = 0.0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    length += result.matrix[i][p] * result.matrix[j][p] * S.matrix[i][j];
                }
            }
            if ((length = Math.sqrt(length)) != 0.0) {
                for (int q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] / length;
                }
                continue;
            }
            System.out.println("Warning(orthonormalize):" + (p + 1) + ". Vector has length null");
        }
        return result;
    }
}

