/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.protein.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openscience.cdk.BioPolymer;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IStrand;

public class PDBPolymer
extends BioPolymer
implements Cloneable,
IPDBPolymer {
    private static final long serialVersionUID = 4173552834313952358L;
    final List<String> sequentialListOfMonomers = new ArrayList<String>();
    final List<IPDBStructure> secondaryStructures = new ArrayList<IPDBStructure>();

    @Override
    public void addStructure(IPDBStructure structure) {
        this.secondaryStructures.add(structure);
    }

    @Override
    public Collection<IPDBStructure> getStructures() {
        return new ArrayList<IPDBStructure>(this.secondaryStructures);
    }

    @Override
    public void addAtom(IPDBAtom oAtom) {
        super.addAtom(oAtom);
    }

    public void addAtom(IPDBAtom oAtom, IMonomer oMonomer) {
        super.addAtom(oAtom, oMonomer);
        if (!this.sequentialListOfMonomers.contains(oMonomer.getMonomerName())) {
            this.sequentialListOfMonomers.add(oMonomer.getMonomerName());
        }
    }

    @Override
    public void addAtom(IPDBAtom oAtom, IMonomer oMonomer, IStrand oStrand) {
        super.addAtom(oAtom, oMonomer, oStrand);
        if (!this.sequentialListOfMonomers.contains(oMonomer.getMonomerName())) {
            this.sequentialListOfMonomers.add(oMonomer.getMonomerName());
        }
    }

    public Collection<String> getMonomerNamesInSequentialOrder() {
        return new ArrayList<String>(this.sequentialListOfMonomers);
    }

    @Override
    public IPDBPolymer clone() throws CloneNotSupportedException {
        return (IPDBPolymer)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder stringContent = new StringBuilder();
        stringContent.append("PDBPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }
}

